/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.tools.coverage.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.common.CoverageData;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.common.TransformationCoverageData;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.ui.NodeCoverageModel;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.ui.ProjectCoverageModel;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.ui.TransformationCoverageModel;
import org.eclipse.ocl.utilities.ASTNode;

public class CoverageModel {
    Map<IProject, ProjectCoverageModel> projectModels = new HashMap<IProject, ProjectCoverageModel>();

    public CoverageModel(CoverageData coverageData) {
        this.inflate(coverageData);
    }

    private void inflate(CoverageData data) {
        HashMap<URI, TransformationCoverageModel> uriToTransModels = new HashMap<URI, TransformationCoverageModel>();
        for (TransformationCoverageData transformationData : data.getData()) {
            URI uri = transformationData.getURI();
            TransformationCoverageModel transformationModel = uriToTransModels.containsKey(uri) ? (TransformationCoverageModel)uriToTransModels.get(uri) : new TransformationCoverageModel(uri);
            Module module = transformationModel.getModule();
            if (module == null) continue;
            TreeIterator it = module.eAllContents();
            while (it.hasNext()) {
                ASTNode node;
                EObject o = (EObject)it.next();
                if (!(o instanceof ASTNode) || !TransformationCoverageData.isIncluded((ASTNode)(node = (ASTNode)o))) continue;
                NodeCoverageModel nodeModel = new NodeCoverageModel(node);
                if (transformationModel.containsNode(nodeModel)) {
                    nodeModel = transformationModel.getNode(nodeModel);
                }
                if (transformationData.containsNode(node)) {
                    nodeModel.setTouched(true);
                }
                transformationModel.addNode(nodeModel);
            }
            uriToTransModels.put(uri, transformationModel);
        }
        for (TransformationCoverageModel transModel : uriToTransModels.values()) {
            IProject project = transModel.getProject();
            ProjectCoverageModel projectModel = this.projectModels.containsKey(project) ? this.projectModels.get(project) : new ProjectCoverageModel(project);
            projectModel.addTransformationModel(transModel);
            this.projectModels.put(project, projectModel);
        }
    }

    public ProjectCoverageModel[] getProjectModels() {
        return this.projectModels.values().toArray(new ProjectCoverageModel[this.projectModels.size()]);
    }
}

