/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ocl.transformations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.m2m.internal.qvt.oml.ocl.Logger;
import org.eclipse.m2m.internal.qvt.oml.ocl.metainfo.OclMetainfo;
import org.eclipse.m2m.internal.qvt.oml.ocl.metainfo.OclMetainfoClassLazyLoader;
import org.eclipse.m2m.internal.qvt.oml.ocl.metainfo.OclMetainfoOperation;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.Library;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryCreationException;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryOperation;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryOperationException;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryOperationImpl;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.Messages;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryImpl
extends EObjectImpl
implements Library {
    private static final String ID_ATTR = "id";
    private static final String CLASS_ATTR = "class";
    private static final String IN_MM_TAG = "inMetamodel";
    private static final String OUT_MM_TAG = "outMetamodel";
    private static final String URI_ATTR = "uri";
    private IConfigurationElement myConfiguration;
    private String[] myInMetamodel;
    private String[] myOutMetamodel;
    private Object myInstance;
    private String myId;
    private String myClassName;
    private Class<?> myLibraryClass;
    private Collection<LibraryOperation> myLibraryOperations;
    private OclMetainfo myMetainfo;

    LibraryImpl(IConfigurationElement configuration) throws LibraryCreationException {
        this.myConfiguration = configuration;
        this.load();
    }

    @Override
    public String[] getInMetamodels() {
        return this.myInMetamodel;
    }

    @Override
    public String[] getOutMetamodels() {
        return this.myOutMetamodel;
    }

    @Override
    public Collection<LibraryOperation> getLibraryOperations() throws LibraryCreationException {
        if (this.myLibraryOperations == null) {
            this.myLibraryOperations = LibraryImpl.getLibraryOperations(this);
        }
        return this.myLibraryOperations;
    }

    @Override
    public OclMetainfo getMetainfo() throws LibraryCreationException {
        if (this.myMetainfo == null) {
            this.myMetainfo = new OclMetainfo(new OclMetainfoClassLazyLoader(this.getLibraryClass()));
        }
        return this.myMetainfo;
    }

    public static Collection<LibraryOperation> getLibraryOperations(Library library) throws LibraryCreationException {
        LinkedList<LibraryOperation> operations = new LinkedList<LibraryOperation>();
        List<OclMetainfoOperation> mOperations = library.getMetainfo().getOperations();
        for (OclMetainfoOperation operation : mOperations) {
            try {
                operations.add(new LibraryOperationImpl(operation, library));
            }
            catch (LibraryOperationException e) {
                Logger.getLogger().log(Logger.SEVERE, "Unable to instantiate LibraryOperationImpl", e);
                throw new LibraryCreationException(MessageFormat.format(Messages.LibraryImpl_LoadErrorDueToOperation, library.getLibraryClass().getName(), operation.getName()), e);
            }
        }
        return operations;
    }

    @Override
    public String getId() {
        return this.myId;
    }

    @Override
    public String getNamespace() {
        return this.myConfiguration.getNamespaceIdentifier();
    }

    @Override
    public String getLibraryClassName() {
        return this.myClassName;
    }

    @Override
    public Class<?> getLibraryClass() throws LibraryCreationException {
        if (this.myLibraryClass == null) {
            String namespace = this.myConfiguration.getNamespaceIdentifier();
            Bundle bundle = Platform.getBundle((String)namespace);
            try {
                this.myLibraryClass = bundle.loadClass(this.getLibraryClassName());
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger().log(Logger.SEVERE, "Specified library class not found", e);
                throw new LibraryCreationException(MessageFormat.format(Messages.LibraryImpl_ClassNF, this.getLibraryClassName()), e);
            }
        }
        return this.myLibraryClass;
    }

    @Override
    public Object getLibraryInstance() {
        if (this.myInstance == null) {
            try {
                this.myInstance = this.myConfiguration.createExecutableExtension(CLASS_ATTR);
            }
            catch (CoreException e) {
                Logger.getLogger().log(Logger.SEVERE, "Unable to instantiate library class", e);
            }
        }
        return this.myInstance;
    }

    public String toString() {
        return "OCL library " + this.myClassName;
    }

    private void load() throws LibraryCreationException {
        this.myInMetamodel = this.loadMetamodelURIs(this.myConfiguration.getChildren(IN_MM_TAG));
        this.myOutMetamodel = this.loadMetamodelURIs(this.myConfiguration.getChildren(OUT_MM_TAG));
        this.myClassName = this.myConfiguration.getAttribute(CLASS_ATTR);
        if (this.myClassName == null) {
            Logger.getLogger().log(Logger.SEVERE, "Class was not specified for " + this.myConfiguration.getNamespaceIdentifier());
            throw new LibraryCreationException(Messages.LibraryImpl_ClassNS);
        }
        this.myId = this.myConfiguration.getAttribute(ID_ATTR);
        if (this.myId == null) {
            Logger.getLogger().severe("Id not specified for " + this.myConfiguration.getNamespaceIdentifier());
            throw new LibraryCreationException(MessageFormat.format(Messages.LibraryImpl_IdNS, new Object[0]));
        }
    }

    private String[] loadMetamodelURIs(IConfigurationElement[] metamodels) {
        ArrayList<String> mmURIs = new ArrayList<String>();
        int i = 0;
        while (i < metamodels.length) {
            String nextUri = metamodels[i].getAttribute(URI_ATTR);
            if (nextUri == null) {
                Logger.getLogger().log(Logger.SEVERE, "Metamodel URI not specified for: " + this.myClassName);
            } else {
                mmURIs.add(nextUri);
            }
            ++i;
        }
        return mmURIs.toArray(new String[mmURIs.size()]);
    }

    @Override
    public void loadOperations() throws LibraryCreationException {
        for (LibraryOperation nextOperation : this.getLibraryOperations()) {
            try {
                nextOperation.load();
            }
            catch (LibraryOperationException e) {
                Logger.getLogger().log(Logger.SEVERE, "Library operation loading error, library loading stopped", e);
                throw new LibraryCreationException(MessageFormat.format(Messages.LibraryImpl_LoadErrorDueToOperation, this.getId(), nextOperation.getName()), e);
            }
        }
    }
}

