/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.controls;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.m2m.internal.qvt.oml.common.project.TransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.common.ui.controls.UniSelectTransformationControl;
import org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class BrowseInterpretedTransformationDialog
extends SelectionStatusDialog {
    private final String myInitialTransId;
    private final TransformationRegistry myRegistry;
    private final ILabelProvider myLabelProvider;
    private final UniSelectTransformationControl.IResourceFilter myResourceFilter;
    private final ISelectionListener mySelectionListener;
    private URI mySelectedUri;
    private UniSelectTransformationControl myControl;

    public BrowseInterpretedTransformationDialog(Shell shell, UniSelectTransformationControl.IResourceFilter resourceFilter, ILabelProvider labelProvider, TransformationRegistry registry, String selectedTransId, ISelectionListener selectionListener) {
        super(shell);
        this.setTitle(Messages.BrowseInterpretedTransformationDialog_Title);
        this.setMessage(Messages.BrowseInterpretedTransformationDialog_Description);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setStatusLineAboveButtons(true);
        this.myResourceFilter = resourceFilter;
        this.myRegistry = registry;
        this.myLabelProvider = labelProvider;
        this.myInitialTransId = selectedTransId;
        this.mySelectionListener = selectionListener;
    }

    public URI getSelectedUri() {
        return this.mySelectedUri;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(768));
        this.createMessageArea(composite);
        this.myControl = new UniSelectTransformationControl(parent, this.myResourceFilter, this.myLabelProvider, this.myRegistry, new TransformationRegistry.Filter(){

            public boolean accept(IConfigurationElement element) {
                return "transformation".equals(element.getName());
            }
        });
        this.myControl.addSelectionListener(new UniSelectTransformationControl.ISelectionListener(){

            public void selectionChanged(URI uri) {
                IStatus selStatus = BrowseInterpretedTransformationDialog.this.mySelectionListener.selectionChanged(uri);
                BrowseInterpretedTransformationDialog.this.mySelectedUri = (URI)(selStatus.isOK() ? uri : null);
                BrowseInterpretedTransformationDialog.this.updateStatus(selStatus);
            }
        });
        this.myControl.selectTransformationByUri(this.myInitialTransId);
        return this.myControl;
    }

    protected void computeResult() {
    }

    public static interface ISelectionListener {
        public IStatus selectionChanged(URI var1);
    }
}

