/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.example.databinding.project.ui.rcp.dialogs.CommitterShipDialog;
import org.eclipse.emf.examples.databinding.project.core.IModelResource;
import org.eclipse.emf.examples.databinding.project.core.model.project.CommitterShip;
import org.eclipse.emf.examples.databinding.project.core.model.project.Project;
import org.eclipse.emf.examples.databinding.project.core.model.project.ProjectFactory;
import org.eclipse.emf.examples.databinding.project.core.model.project.ProjectPackage;
import org.eclipse.swt.widgets.Shell;

public class CreateCommittershipHandler
extends AbstractHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEvaluationContext ctx = (IEvaluationContext)event.getApplicationContext();
        Shell shell = (Shell)ctx.getVariable("activeWorkbenchWindowShell");
        IModelResource resource = (IModelResource)ctx.getVariable("modelresource");
        Project parent = (Project)ctx.getVariable("project");
        CommitterShip com = ProjectFactory.eINSTANCE.createCommitterShip();
        if (!resource.setSavePoint().isOK()) throw new ExecutionException("Could not create a save point");
        Command cmd = AddCommand.create((EditingDomain)resource.getEditingDomain(), (Object)parent, (Object)ProjectPackage.Literals.PROJECT__COMMITTERS, (Object)com);
        if (cmd.canExecute()) {
            resource.executeCmd(cmd);
            CommitterShipDialog dialog = new CommitterShipDialog(shell, resource, com, true);
            if (dialog.open() == 0) {
                resource.commit();
                return null;
            } else {
                resource.rollback();
            }
            return null;
        } else {
            resource.rollback();
            throw new ExecutionException("Could not execute add comitter ship command");
        }
    }
}

