/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.util.diagram;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.sirius.junit.util.diagram.AbstractSiriusDiagramTests;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.DomainBasedEdgeServices;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.uml2.uml.Package;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractReconnectTargetEdgeTests
extends AbstractSiriusDiagramTests {
    protected Package root;
    private EObject semanticSource;
    private EObject semanticTarget;
    private EObject semanticNewTarget;
    private EObject edgeSource;
    private EObject edgeTarget;
    private EObject edgeNewTarget;

    @Before
    public void setUp() {
        this.root = this.fixture.getModel();
    }

    protected void reconnectTargetEdge(String reconnectionTargetToolId, DEdge edge) {
        this.reconnectTargetEdge(reconnectionTargetToolId, edge, false);
    }

    protected void reconnectTargetEdge(String reconnectionTargetToolId, DEdge edge, boolean isSynchronized) {
        this.checkSiriusDiagramSynchronization(isSynchronized);
        Diagram diagram = this.getDiagram();
        int initalNbEdges = diagram.getEdges().size();
        EClass initialEdgeType = edge.getTarget().eClass();
        boolean result = this.fixture.applyEdgeReconnectionTool(reconnectionTargetToolId, (DDiagram)this.getDDiagram(), edge, (EdgeTarget)this.getEdgeTarget(), (EdgeTarget)this.getEdgeNewTarget());
        Assert.assertTrue((String)"The reconnexion of edge failed", (boolean)result);
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((String)"Number of edge on diagram should be different after reconnexion.", (long)initalNbEdges, (long)diagram.getEdges().size());
        Assert.assertEquals((String)"New edge target does not match with reconnection target.", (Object)((EdgeTarget)this.getEdgeNewTarget()), (Object)edge.getTargetNode());
        EList semanticElements = edge.getSemanticElements();
        Assert.assertEquals((String)"The reconnected edge representation must have 1 associated semantic element", (long)1L, (long)semanticElements.size());
        EObject element = (EObject)semanticElements.get(0);
        Assert.assertEquals((String)"The type of the reconnected edge should not change.", (Object)initialEdgeType, (Object)element.eClass());
        DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
        Assert.assertEquals((String)"The semantic source should not change.", (Object)this.getSemanticSource(), (Object)domainBasedEdgeServices.getSource(element));
        Assert.assertEquals((String)"The semantic target does not match with reconnection semantic target.", (Object)this.getSemanticNewTarget(), domainBasedEdgeServices.getTargets(element).get(0));
        this.fixture.getEditingDomain().getCommandStack().undo();
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((String)"The semantic source should not change.", (Object)this.getSemanticSource(), (Object)domainBasedEdgeServices.getSource(element));
        Assert.assertEquals((String)"The semantic target should be reseted.", (Object)this.getSemanticTarget(), domainBasedEdgeServices.getTargets(element).get(0));
        this.fixture.getEditingDomain().getCommandStack().redo();
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((String)"The semantic source should not change.", (Object)this.getSemanticSource(), (Object)domainBasedEdgeServices.getSource(element));
        Assert.assertEquals((String)"The semantic target does not match with reconnection semantic target.", (Object)this.getSemanticNewTarget(), domainBasedEdgeServices.getTargets(element).get(0));
    }

    @After
    public void tearDown() {
        this.root = null;
    }

    public EObject getSemanticSource() {
        return this.semanticSource;
    }

    public void setSemanticSource(EObject semanticSource) {
        this.semanticSource = semanticSource;
    }

    public EObject getSemanticTarget() {
        return this.semanticTarget;
    }

    public void setSemanticTarget(EObject semanticTarget) {
        this.semanticTarget = semanticTarget;
    }

    public EObject getSemanticNewTarget() {
        return this.semanticNewTarget;
    }

    public void setSemanticNewTarget(EObject semanticNewTarget) {
        this.semanticNewTarget = semanticNewTarget;
    }

    public EObject getEdgeSource() {
        return this.edgeSource;
    }

    public void setEdgeSource(EObject edgeSource) {
        this.edgeSource = edgeSource;
    }

    public EObject getEdgeTarget() {
        return this.edgeTarget;
    }

    public void setEdgeTarget(EObject edgeTarget) {
        this.edgeTarget = edgeTarget;
    }

    public EObject getEdgeNewTarget() {
        return this.edgeNewTarget;
    }

    public void setEdgeNewTarget(EObject edgeNewTarget) {
        this.edgeNewTarget = edgeNewTarget;
    }
}

