/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.listeners;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.papyrus.uml.tools.helper.ProfileApplicationDelegateRegistry;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;

public class ProfileApplicationListener
extends ResourceSetListenerImpl {
    public ProfileApplicationListener() {
        super(NotificationFilter.NOT_TOUCH.and(NotificationFilter.createFeatureFilter((EStructuralFeature)UMLPackage.Literals.PROFILE_APPLICATION__APPLIED_PROFILE).or(NotificationFilter.createFeatureFilter((EStructuralFeature)UMLPackage.Literals.PACKAGE__PROFILE_APPLICATION))));
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        Package package_;
        Profile profile;
        ProfileApplication application;
        HashMultimap applications = HashMultimap.create();
        HashMultimap unapplications = HashMultimap.create();
        HashMap applied = Maps.newHashMap();
        HashMap unapplied = Maps.newHashMap();
        block8: for (Notification notification : event.getNotifications()) {
            if (notification.getFeature() == UMLPackage.Literals.PACKAGE__PROFILE_APPLICATION) {
                Package package_2 = (Package)notification.getNotifier();
                switch (notification.getEventType()) {
                    case 3: 
                    case 5: {
                        for (Object newValue : ProfileApplicationListener.asIterable(notification.getNewValue())) {
                            ProfileApplication application3 = (ProfileApplication)newValue;
                            applications.values().remove(application3);
                            applications.put((Object)package_2, (Object)application3);
                        }
                        continue block8;
                    }
                    case 4: 
                    case 6: {
                        for (Object oldValue : ProfileApplicationListener.asIterable(notification.getOldValue())) {
                            ProfileApplication application2 = (ProfileApplication)oldValue;
                            if (unapplications.values().contains(application2) || applications.remove((Object)package_2, (Object)application2)) continue;
                            unapplications.put((Object)package_2, (Object)application2);
                        }
                        continue block8;
                    }
                    case 1: {
                        ProfileApplication application2 = (ProfileApplication)notification.getNewValue();
                        if (application2 != null) {
                            applications.values().remove(application2);
                            applications.put((Object)package_2, (Object)application2);
                        }
                        if ((application2 = (ProfileApplication)notification.getOldValue()) == null || unapplications.values().contains(application2)) continue block8;
                        unapplications.put((Object)package_2, (Object)application2);
                    }
                }
                continue;
            }
            if (notification.getFeature() != UMLPackage.Literals.PROFILE_APPLICATION__APPLIED_PROFILE) continue;
            application = (ProfileApplication)notification.getNotifier();
            switch (notification.getEventType()) {
                case 1: {
                    Object newValue;
                    newValue = (Profile)notification.getNewValue();
                    Profile oldValue = (Profile)notification.getOldValue();
                    if (newValue != null) {
                        applied.put(application, newValue);
                    } else {
                        applied.remove(application);
                    }
                    if (oldValue == null || unapplied.containsKey(application) || applications.containsEntry((Object)application.getApplyingPackage(), (Object)application)) continue block8;
                    unapplied.put(application, oldValue);
                }
            }
        }
        for (Map.Entry entry : unapplications.entries()) {
            Package package_2 = (Package)entry.getKey();
            ProfileApplication application3 = (ProfileApplication)entry.getValue();
            Profile profile2 = application3.getAppliedProfile();
            if (profile2 != null) {
                unapplied.remove(application3);
            } else {
                profile2 = (Profile)unapplied.remove(application3);
            }
            if (profile2 == null) continue;
            ProfileApplicationNotification.notify(package_2, 41, profile2, false);
        }
        for (Map.Entry entry : unapplied.entrySet()) {
            application = (ProfileApplication)entry.getKey();
            profile = (Profile)entry.getValue();
            package_ = this.getApplyingPackage(application);
            if (package_ == null) continue;
            boolean touch = package_ != application.getApplyingPackage();
            ProfileApplicationNotification.notify(package_, 41, profile, touch);
        }
        for (Map.Entry entry : applications.entries()) {
            application = (ProfileApplication)entry.getValue();
            Package package_3 = this.getApplyingPackage(application);
            Profile profile2 = application.getAppliedProfile();
            applied.remove(application);
            if (profile2 == null) continue;
            boolean touch = package_3 != application.getApplyingPackage();
            ProfileApplicationNotification.notify(package_3, 40, profile2, touch);
        }
        for (Map.Entry entry : applied.entrySet()) {
            application = (ProfileApplication)entry.getKey();
            profile = (Profile)entry.getValue();
            package_ = this.getApplyingPackage(application);
            if (package_ == null) continue;
            boolean touch = package_ != application.getApplyingPackage();
            ProfileApplicationNotification.notify(package_, 40, profile, touch);
        }
    }

    private Package getApplyingPackage(ProfileApplication application) {
        return ProfileApplicationDelegateRegistry.INSTANCE.getDelegate(application).getApplyingPackage(application);
    }

    static Iterable<?> asIterable(Object value) {
        return value instanceof Iterable ? (Iterable)value : ECollections.singletonEList((Object)value);
    }

    public static boolean isProfileApplicationNotification(Notification notification) {
        return notification != null && notification.getNotifier() instanceof Package && notification instanceof ProfileApplicationNotification;
    }

    public static class ProfileApplicationNotification
    extends ENotificationImpl {
        public static final int PROFILE_APPLIED = 40;
        public static final int PROFILE_UNAPPLIED = 41;
        private final boolean touch;

        private ProfileApplicationNotification(Package package_, int eventType, Profile profile, boolean touch) {
            super((InternalEObject)package_, eventType, -1, (Object)(eventType == 40 ? null : profile), eventType == 40 ? profile : null, -1);
            this.touch = touch;
        }

        public static void notifyProfileApplied(Package package_, Profile profile) {
            ProfileApplicationNotification.notify(package_, 40, profile, true);
        }

        public static void notifyProfileUnapplied(Package package_, Profile profile) {
            ProfileApplicationNotification.notify(package_, 41, profile, true);
        }

        static void notify(Package package_, int eventType, Profile profile, boolean touch) {
            if (((BasicNotifierImpl)package_).eNotificationRequired()) {
                ProfileApplicationNotification notification = new ProfileApplicationNotification(package_, eventType, profile, touch);
                notification.dispatch();
            }
        }

        public boolean isTouch() {
            return this.touch;
        }

        public Package getNotifyingPackage() {
            return (Package)this.getNotifier();
        }

        public Profile getAppliedProfile() {
            return (Profile)this.getNewValue();
        }

        public Profile getUnappliedProfile() {
            return (Profile)this.getOldValue();
        }
    }
}

