/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.sequence.services.utils;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.SequenceDiagramOrderServices;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.OccurrenceSpecificationHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.UMLTemporalHelper;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.PackageableElement;

public class SequenceDiagramUMLHelper {
    public Interaction getOwningInteraction(Element element) {
        Interaction result = null;
        if (element instanceof InteractionFragment) {
            InteractionFragment fragment = (InteractionFragment)element;
            if (fragment.getEnclosingInteraction() != null) {
                result = fragment.getEnclosingInteraction();
            } else if (fragment.getEnclosingOperand() != null) {
                result = this.getOwningInteraction((Element)fragment.getEnclosingOperand());
            } else {
                Element element2 = fragment.getOwner();
                if (element2 instanceof CombinedFragment) {
                    CombinedFragment combinedFragment = (CombinedFragment)element2;
                    result = this.getOwningInteraction((Element)combinedFragment);
                } else if (fragment instanceof Interaction) {
                    Interaction interaction;
                    result = interaction = (Interaction)fragment;
                }
            }
        } else if (element instanceof Message) {
            Message message = (Message)element;
            result = message.getInteraction();
        } else if (element instanceof Lifeline) {
            Lifeline lifeline = (Lifeline)element;
            result = lifeline.getInteraction();
        } else if (element instanceof Gate) {
            Gate gate = (Gate)element;
            result = this.getOwningInteraction(gate.getOwner());
        }
        return result;
    }

    public NamedElement getOtherEnd(OccurrenceSpecification occurrenceSpecification) {
        OccurrenceSpecification result = null;
        if (occurrenceSpecification instanceof ExecutionOccurrenceSpecification) {
            ExecutionOccurrenceSpecification executionOccurrenceSpecification = (ExecutionOccurrenceSpecification)occurrenceSpecification;
            ExecutionSpecification execution = executionOccurrenceSpecification.getExecution();
            if (executionOccurrenceSpecification == execution.getStart()) {
                result = execution.getFinish();
            } else if (executionOccurrenceSpecification == execution.getFinish()) {
                result = execution.getStart();
            }
        } else if (occurrenceSpecification instanceof MessageOccurrenceSpecification) {
            MessageOccurrenceSpecification messageOccurrenceSpecification = (MessageOccurrenceSpecification)occurrenceSpecification;
            Message message = messageOccurrenceSpecification.getMessage();
            if (messageOccurrenceSpecification == message.getSendEvent()) {
                result = message.getReceiveEvent();
            } else if (messageOccurrenceSpecification == message.getReceiveEvent()) {
                result = message.getSendEvent();
            }
        }
        return result;
    }

    public boolean isCoveringASubsetOf(NamedElement source, NamedElement target) {
        if (source instanceof InteractionFragment) {
            InteractionFragment targetFragment;
            InteractionFragment sourceFragment = (InteractionFragment)source;
            if (target instanceof InteractionFragment && (targetFragment = (InteractionFragment)target).getCovereds().containsAll((Collection)sourceFragment.getCovereds())) {
                return true;
            }
        }
        return false;
    }

    public Element getBaseElement(NamedElement interactionFragment) {
        NamedElement result = interactionFragment;
        if (interactionFragment instanceof ExecutionOccurrenceSpecification) {
            ExecutionOccurrenceSpecification executionOccurrenceSpecification = (ExecutionOccurrenceSpecification)interactionFragment;
            result = executionOccurrenceSpecification.getExecution();
        } else if (interactionFragment instanceof MessageOccurrenceSpecification) {
            MessageOccurrenceSpecification messageOccurrenceSpecification = (MessageOccurrenceSpecification)interactionFragment;
            result = messageOccurrenceSpecification.getMessage();
        }
        return result;
    }

    public NamedElement getSemanticStart(Element element) {
        OccurrenceSpecification result = null;
        if (element instanceof ExecutionSpecification) {
            ExecutionSpecification executionSpecification = (ExecutionSpecification)element;
            result = executionSpecification.getStart();
        } else if (element instanceof Message) {
            Message message = (Message)element;
            result = message.getSendEvent();
        } else if (element instanceof InteractionFragment) {
            InteractionFragment fragment = (InteractionFragment)element;
            result = fragment;
        } else if (element instanceof Gate) {
            Gate gate = (Gate)element;
            result = gate;
        }
        return result;
    }

    public NamedElement getSemanticFinish(Element element) {
        OccurrenceSpecification result = null;
        if (element instanceof ExecutionSpecification) {
            ExecutionSpecification executionSpecification = (ExecutionSpecification)element;
            result = executionSpecification.getFinish();
        } else if (element instanceof Message) {
            Message message = (Message)element;
            result = message.getReceiveEvent();
        } else if (element instanceof InteractionFragment) {
            InteractionFragment fragment = (InteractionFragment)element;
            result = fragment;
        } else if (element instanceof Gate) {
            Gate gate = (Gate)element;
            result = gate;
        }
        return result;
    }

    public static List<PackageableElement> getTemporalElementsFromEvent(NamedElement event) {
        ECrossReferenceAdapter crossReferencer = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)event);
        return UMLTemporalHelper.getTemporalElements((NamedElement)event, (ECrossReferenceAdapter)crossReferencer);
    }

    public static List<PackageableElement> getTimeElementsFromEvent(NamedElement event) {
        ECrossReferenceAdapter crossReferencer = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)event);
        return UMLTemporalHelper.getTimeElements((NamedElement)event, (ECrossReferenceAdapter)crossReferencer);
    }

    public static Optional<PackageableElement> getTimeElementFromEnd(EAnnotation end) {
        NamedElement fragment = new SequenceDiagramOrderServices().getEndFragment(end);
        if (fragment == null) {
            return Optional.empty();
        }
        return SequenceDiagramUMLHelper.getTimeElementsFromEvent(fragment).stream().findFirst();
    }

    public Lifeline getCoveredLifeline(InteractionFragment element) {
        if (!element.getCovereds().isEmpty()) {
            return (Lifeline)element.getCovereds().get(0);
        }
        return null;
    }

    public Lifeline getCoveredLifeline(NamedElement element) {
        Lifeline result = null;
        if (element instanceof Lifeline) {
            Lifeline lifeline;
            result = lifeline = (Lifeline)element;
        } else if (element instanceof InteractionFragment) {
            InteractionFragment fragment = (InteractionFragment)element;
            result = this.getCoveredLifeline(fragment);
        }
        return result;
    }

    public static ExecutionSpecification getAssociatedExecution(OccurrenceSpecification occurrence) {
        if (occurrence instanceof ExecutionOccurrenceSpecification) {
            ExecutionOccurrenceSpecification eos = (ExecutionOccurrenceSpecification)occurrence;
            return eos.getExecution();
        }
        return OccurrenceSpecificationHelper.getExecutionFromStartOccurrence((OccurrenceSpecification)occurrence).or(() -> OccurrenceSpecificationHelper.getExecutionFromFinishOccurrence((OccurrenceSpecification)occurrence)).orElse(null);
    }
}

