/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.widgets.celleditors.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.AbstractRegistry;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.Activator;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.DefaultCommandFactory;

public class CommandFactoriesRegistry
extends AbstractRegistry
implements ICommandFactoriesRegistry {
    private static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.papyrus.emf.facet.widgets.celleditors";
    private static final String EXTENSION_POINT_NAME = "commandFactories";
    private static final String COMMAND_FACTORY_ELEMENT = "commandFactory";
    private static final String CLASS_ATTRIBUTE = "class";
    private final List<ICommandFactory> commandFactories = new ArrayList<ICommandFactory>();
    private final ICommandFactory defaultCommandFactory = new DefaultCommandFactory();

    public CommandFactoriesRegistry() {
        this.initialize();
    }

    @Override
    public List<ICommandFactory> getCommandFactories() {
        return this.commandFactories;
    }

    @Override
    public ICommandFactory getCommandFactoryFor(EditingDomain editingDomain) {
        for (ICommandFactory commandFactory : this.commandFactories) {
            if (!commandFactory.handles(editingDomain)) continue;
            return commandFactory;
        }
        return this.defaultCommandFactory;
    }

    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    protected String getExtensionPointNamespace() {
        return EXTENSION_POINT_NAMESPACE;
    }

    protected void handleRootElement(IConfigurationElement configurationElement) {
        String name = configurationElement.getName();
        if (name.equalsIgnoreCase(COMMAND_FACTORY_ELEMENT)) {
            this.readModelElement(configurationElement);
        } else {
            CommandFactoriesRegistry.logUnknownElement((IConfigurationElement)configurationElement);
        }
    }

    private void readModelElement(IConfigurationElement configurationElement) {
        Object object;
        try {
            object = configurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return;
        }
        if (object == null) {
            CommandFactoriesRegistry.logMissingAttribute((IConfigurationElement)configurationElement, (String)CLASS_ATTRIBUTE);
            return;
        }
        if (object instanceof ICommandFactory) {
            ICommandFactory commandFactory = (ICommandFactory)object;
            this.commandFactories.add(commandFactory);
        } else {
            CommandFactoriesRegistry.logError((IConfigurationElement)configurationElement, (String)("class must implement " + ICommandFactory.class.getSimpleName()));
        }
    }
}

