/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.IColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.HideColumnByIndexCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllColumnsCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralChangeEventHelper;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class ColumnHideShowLayer
extends AbstractColumnHideShowLayer
implements IColumnHideShowLayer {
    public static final String PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES = ".hiddenColumnIndexes";
    private MutableIntSet hiddenColumnIndexes = IntSets.mutable.empty();

    public ColumnHideShowLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
        this.registerCommandHandler(new MultiColumnHideCommandHandler(this));
        this.registerCommandHandler(new ColumnHideCommandHandler(this));
        this.registerCommandHandler(new ShowAllColumnsCommandHandler(this));
        this.registerCommandHandler(new MultiColumnShowCommandHandler(this));
        this.registerCommandHandler(new ColumnShowCommandHandler(this));
        this.registerCommandHandler(new HideColumnByIndexCommandHandler(this));
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        Collection<StructuralDiff> columnDiffs;
        IStructuralChangeEvent structuralChangeEvent;
        if (event instanceof IStructuralChangeEvent && (structuralChangeEvent = (IStructuralChangeEvent)event).isHorizontalStructureChanged() && (columnDiffs = structuralChangeEvent.getColumnDiffs()) != null && !columnDiffs.isEmpty() && !StructuralChangeEventHelper.isReorder(columnDiffs)) {
            StructuralChangeEventHelper.handleColumnDelete(columnDiffs, this.underlyingLayer, (MutableIntCollection)this.hiddenColumnIndexes, false);
            StructuralChangeEventHelper.handleColumnInsert(columnDiffs, this.underlyingLayer, (MutableIntCollection)this.hiddenColumnIndexes, false);
        }
        super.handleLayerEvent(event);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        if (this.hiddenColumnIndexes.size() > 0) {
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES, this.hiddenColumnIndexes.toSortedList().makeString(","));
        } else {
            properties.remove(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES);
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.hiddenColumnIndexes = IntSets.mutable.empty();
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken();
                this.hiddenColumnIndexes.add(Integer.parseInt(index));
            }
        }
        super.loadState(prefix, properties);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int rightColumnIndex;
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        int underlyingPosition = this.localToUnderlyingColumnPosition(columnPosition);
        int leftColumnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingPosition - 1);
        if (this.isColumnIndexHidden(leftColumnIndex)) {
            configLabels.addLabel("COLUMN_LEFT_HIDDEN");
        }
        if (this.isColumnIndexHidden(rightColumnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingPosition + 1))) {
            configLabels.addLabel("COLUMN_RIGHT_HIDDEN");
        }
        return configLabels;
    }

    @Override
    public boolean isColumnIndexHidden(int columnIndex) {
        return this.hiddenColumnIndexes.contains(columnIndex);
    }

    @Override
    public Collection<Integer> getHiddenColumnIndexes() {
        return ArrayUtil.asIntegerList(this.hiddenColumnIndexes.toSortedArray());
    }

    @Override
    public int[] getHiddenColumnIndexesArray() {
        return this.hiddenColumnIndexes.toSortedArray();
    }

    @Override
    public boolean hasHiddenColumns() {
        return !this.hiddenColumnIndexes.isEmpty();
    }

    @Override
    public void hideColumnPositions(int ... columnPositions) {
        int[] columnIndexes = Arrays.stream(columnPositions).map(this::getColumnIndexByPosition).sorted().toArray();
        this.hiddenColumnIndexes.addAll(columnIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new HideColumnPositionsEvent((ILayer)this, columnPositions, columnIndexes));
    }

    @Override
    public void hideColumnPositions(Collection<Integer> columnPositions) {
        this.hideColumnPositions(columnPositions.stream().mapToInt(Integer::intValue).toArray());
    }

    @Override
    public void hideColumnIndexes(int ... columnIndexes) {
        int[] filteredIndexes = Arrays.stream(columnIndexes).filter(index -> !this.hiddenColumnIndexes.contains(index)).toArray();
        if (filteredIndexes.length > 0) {
            int[] columnPositions = Arrays.stream(filteredIndexes).filter(index -> !this.hiddenColumnIndexes.contains(index)).map(this::getColumnPositionByIndex).sorted().toArray();
            this.hiddenColumnIndexes.addAll(filteredIndexes);
            this.invalidateCache();
            this.fireLayerEvent(new HideColumnPositionsEvent((ILayer)this, columnPositions, filteredIndexes));
        }
    }

    @Override
    public void hideColumnIndexes(Collection<Integer> columnIndexes) {
        this.hideColumnIndexes(columnIndexes.stream().mapToInt(Integer::intValue).toArray());
    }

    @Override
    public void showColumnIndexes(int ... columnIndexes) {
        MutableIntList toProcess = IntLists.mutable.of(columnIndexes);
        toProcess.retainAll((IntIterable)this.hiddenColumnIndexes);
        this.hiddenColumnIndexes.removeAll((IntIterable)toProcess);
        this.invalidateCache();
        int[] positions = this.getColumnPositionsByIndexes(toProcess.toArray());
        this.fireLayerEvent(new ShowColumnPositionsEvent((ILayer)this, positions));
    }

    @Override
    public void showColumnIndexes(Collection<Integer> columnIndexes) {
        this.showColumnIndexes(columnIndexes.stream().mapToInt(Integer::intValue).toArray());
    }

    @Override
    public void showColumnPosition(int columnPosition, boolean showToLeft, boolean showAll) {
        MutableIntSet columnIndexes = IntSets.mutable.empty();
        int underlyingPosition = this.localToUnderlyingColumnPosition(columnPosition);
        if (showToLeft) {
            int leftColumnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingPosition - 1);
            if (showAll) {
                int move = 1;
                while (this.isColumnIndexHidden(leftColumnIndex)) {
                    columnIndexes.add(leftColumnIndex);
                    leftColumnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingPosition - ++move);
                }
            } else if (this.isColumnIndexHidden(leftColumnIndex)) {
                columnIndexes.add(leftColumnIndex);
            }
        } else {
            int rightColumnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingPosition + 1);
            if (showAll) {
                int move = 1;
                while (this.isColumnIndexHidden(rightColumnIndex)) {
                    columnIndexes.add(rightColumnIndex);
                    rightColumnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingPosition + ++move);
                }
            } else if (this.isColumnIndexHidden(rightColumnIndex)) {
                columnIndexes.add(rightColumnIndex);
            }
        }
        if (!columnIndexes.isEmpty()) {
            this.showColumnIndexes(columnIndexes.toArray());
        }
    }

    @Override
    public void showAllColumns() {
        int[] hidden = this.hiddenColumnIndexes.toSortedArray();
        this.hiddenColumnIndexes = IntSets.mutable.empty();
        this.invalidateCache();
        this.fireLayerEvent(new ShowColumnPositionsEvent((ILayer)this, this.getColumnPositionsByIndexes(hidden)));
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> result = super.getProvidedLabels();
        result.add("COLUMN_LEFT_HIDDEN");
        result.add("COLUMN_RIGHT_HIDDEN");
        return result;
    }
}

