/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.services.spi.IContextualServiceRegistryTracker;
import org.eclipse.papyrus.infra.core.utils.IPapyrusCallable;
import org.eclipse.papyrus.infra.core.utils.IPapyrusRunnable;
import org.eclipse.papyrus.infra.tools.util.IProgressCallable;
import org.eclipse.papyrus.infra.tools.util.IProgressRunnable;

public abstract class AbstractServiceUtils<T> {
    public abstract ServicesRegistry getServiceRegistry(T var1) throws ServiceException;

    protected ServicesRegistry getContextualServiceRegistry() {
        IContextualServiceRegistryTracker tracker = Activator.getDefault().getContextualServiceRegistryTracker();
        return tracker == null ? null : tracker.getServiceRegistry();
    }

    public TransactionalEditingDomain getTransactionalEditingDomain(T from) throws ServiceException {
        return this.getServiceRegistry(from).getService(TransactionalEditingDomain.class);
    }

    public IPageManager getIPageManager(T from) throws ServiceException {
        return this.getServiceRegistry(from).getService(IPageManager.class);
    }

    public ModelSet getModelSet(T from) throws ServiceException {
        return this.getServiceRegistry(from).getService(ModelSet.class);
    }

    public <S> S getService(Class<S> service, T from) throws ServiceException {
        return this.getServiceRegistry(from).getService(service);
    }

    public Object getService(Object service, T from) throws ServiceException {
        return this.getServiceRegistry(from).getService(service);
    }

    public <S> S getService(Class<S> service, T from, S defaultImpl) {
        try {
            return from == null ? defaultImpl : this.getServiceRegistry(from).getService(service);
        }
        catch (ServiceException e) {
            return defaultImpl;
        }
    }

    public <V> IPapyrusCallable<V> callable(final IProgressCallable<V> callable, final T from) {
        return new IPapyrusCallable<V>(){

            public V call(IProgressMonitor monitor) throws Exception {
                return callable.call(monitor);
            }

            @Override
            public ServicesRegistry getServiceRegistry() {
                ServicesRegistry result = null;
                try {
                    result = AbstractServiceUtils.this.getServiceRegistry(from);
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
                return result;
            }
        };
    }

    public IPapyrusRunnable runnable(final IProgressRunnable runnable, final T from) {
        return new IPapyrusRunnable(){

            public void run(IProgressMonitor monitor) {
                runnable.run(monitor);
            }

            @Override
            public ServicesRegistry getServiceRegistry() {
                ServicesRegistry result = null;
                try {
                    result = AbstractServiceUtils.this.getServiceRegistry(from);
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
                return result;
            }
        };
    }

    protected Optional<ServicesRegistry> tryServiceRegistry(T from) {
        try {
            return Optional.ofNullable(this.getServiceRegistry(from));
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return Optional.empty();
        }
    }

    public <S> Optional<S> tryService(T from, Class<S> serviceType) {
        return this.tryServiceRegistry(from).map(services -> {
            try {
                return services.getService(serviceType);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        });
    }
}

