/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.helper.tests;

import java.util.List;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.uml.helper.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Package;

public class RegressionTest
extends AbstractTestSuite {
    public void test_completionOfRightmostSubexpression_RATLC00537918() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Property")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.opposite = self.");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "opposite");
    }

    public void test_completionOfRightmost_parentheses_RATLC00537918() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Property")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "(self.opposite = self).");
        this.assertNotChoice(choices, ChoiceKind.PROPERTY, "opposite");
        this.assertChoice(choices, ChoiceKind.OPERATION, "oclIsUndefined");
    }

    public void test_completionOnLetVariable_RATLC00537918() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Class")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "let p : Package = self.getNearestPackage() in 'foo_'.concat(p.");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "ownedType");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "nestedPackage");
    }

    public void test_completionOnLetExpression_RATLC00537918() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Class")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "(let p : Package = self.getNearestPackage() in p.name).");
        this.assertChoice(choices, ChoiceKind.OPERATION, "toLower");
    }

    public void test_completionOnIteratorVariable_RATLC00537918() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Class")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.superClass->collect(i : Class | i.");
        this.assertChoice(choices, ChoiceKind.OPERATION, "getNearestPackage");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "package");
    }

    public void test_completionOnAccumulator_RATLC00537918() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Class")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.superClass->iterate(i : Class; a : String = '' | a.");
        this.assertChoice(choices, ChoiceKind.OPERATION, "concat");
        choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.superClass->iterate(i : Class; a : String = '' | a.concat(i.");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "name");
    }

    public void test_completionOnIterate_RATLC00537918() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Class")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.superClass->iterate(i : Class; a : String = '' | a.concat(i.name)).");
        this.assertChoice(choices, ChoiceKind.OPERATION, "concat");
    }

    public void test_completionOnIterator_sequence_RATLC00537918() {
        this.helper.setContext((Object)((Classifier)((Package)this.getUMLMetamodel()).getOwnedType("Class")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Sequence{'abc', 'a', 'ab'}->");
        this.assertChoice(choices, ChoiceKind.OPERATION, "subSequence");
    }

    public void test_completionOnIterator_orderedSet_RATLC00537918() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Class")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.ownedAttribute->select(i : Property | i.redefinedProperty->isEmpty())->");
        this.assertChoice(choices, ChoiceKind.OPERATION, "subOrderedSet");
    }

    public void test_completionOnIterator_bag_RATLC00537918() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Class")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Set{'abc', 'a', 'ab'}->collect(i : String | i.size())->");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "symmetricDifference");
    }

    public void test_completionOnIfExpression_RATLC00537918() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Class")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "(if true then 'a' else 'b' endif).");
        this.assertChoice(choices, ChoiceKind.OPERATION, "concat");
        choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "if true then 'a' else 'b' endif.");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "concat");
    }

    public void test_variables_RATLC00535552() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Class")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "let pkgName : String = getNearestPackage().name in");
        this.assertChoice(choices, ChoiceKind.VARIABLE, "pkgName");
        this.assertChoice(choices, ChoiceKind.VARIABLE, "self");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "superClass");
        this.assertChoice(choices, ChoiceKind.OPERATION, "allParents");
        this.assertChoice(choices, ChoiceKind.OPERATION, "oclAsType");
        choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "superClass->collect(sc : Class | ");
        this.assertChoice(choices, ChoiceKind.VARIABLE, "sc");
    }

    public void test_parameters_RATLC00535552() {
        this.helper.setOperationContext((Object)this.apple, (Object)this.apple_labelOper);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "'' <> ");
        this.assertChoice(choices, ChoiceKind.VARIABLE, "text");
    }

    public void test_partial_property_RATLC00535552() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.gen");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "general");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "generalization");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "getNearestPackage");
    }

    public void test_partial_operation_RATLC00535552() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Class")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.allP");
        this.assertChoice(choices, ChoiceKind.OPERATION, "allParents");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "allFeatures");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "oclAsType");
    }

    public void test_partial_type_RATLC00535552() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Classifier")));
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "if self.oclIsKindOf(UML::Cl");
        this.assertChoice(choices, ChoiceKind.TYPE, "Class");
        this.assertNotChoice(choices, ChoiceKind.TYPE, "Enumeration");
    }

    public void test_partial_enumLiteral_RATLC00535552() {
        this.helper.setContext((Object)this.apple);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "if color <> Color::bl");
        this.assertChoice(choices, ChoiceKind.ENUMERATION_LITERAL, "black");
        this.assertNotChoice(choices, ChoiceKind.ENUMERATION_LITERAL, "red");
    }

    public void test_partial_collectionOperation_RATLC00535552() {
        this.helper.setContext((Object)this.apple);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Apple.allInstances()->symm");
        this.assertChoice(choices, ChoiceKind.OPERATION, "symmetricDifference");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "collect");
    }

    public void test_emptyExpression_RATLC00535552() {
        this.helper.setContext((Object)this.apple);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "");
        this.assertChoice(choices, ChoiceKind.VARIABLE, "self");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "tree");
        this.assertChoice(choices, ChoiceKind.ASSOCIATION_CLASS, "stem");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "color");
    }

    public void test_garbageExpression_RATLC00535552() {
        this.helper.setContext((Object)this.apple);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "{@grr!");
        this.assertChoice(choices, ChoiceKind.VARIABLE, "self");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "tree");
        this.assertChoice(choices, ChoiceKind.ASSOCIATION_CLASS, "stem");
        this.assertChoice(choices, ChoiceKind.PROPERTY, "color");
    }

    public void test_oclIsInvalidOnInvalidLetVariable_342644() {
        this.helper.setContext((Object)this.apple);
        this.assertQueryTrue(null, "let a:Integer = '123a'.toInteger() in a.oclIsInvalid()");
    }

    public void test_oclIsInvalidOnInvalidOperationCallResult_342561() {
        this.helper.setContext((Object)this.apple);
        this.assertQueryTrue(null, "'123a'.toInteger().oclIsInvalid()");
    }

    public void test_oclIsNewOnlyInPostconditions_116664() {
        this.helper.setContext((Object)this.apple);
        List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.ocl");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "oclIsNew");
        this.helper.setOperationContext((Object)this.apple, (Object)this.apple_newApple);
        choices = this.helper.getSyntaxHelp(ConstraintKind.PRECONDITION, "self.ocl");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "oclIsNew");
        choices = this.helper.getSyntaxHelp(ConstraintKind.BODYCONDITION, "self.ocl");
        this.assertNotChoice(choices, ChoiceKind.OPERATION, "oclIsNew");
        choices = this.helper.getSyntaxHelp(ConstraintKind.POSTCONDITION, "self.ocl");
        this.assertChoice(choices, ChoiceKind.OPERATION, "oclIsNew");
    }
}

