/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.tests;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.resource.ProjectManager;

public class TestProjectManager
extends BasicProjectManager {
    private final @NonNull URI platformResourceURI;
    private final @NonNull URI platformPluginURI;
    private final @NonNull URI fileURI;

    public TestProjectManager(@NonNull TestProject testProject) {
        String projectName = testProject.getURI().lastSegment();
        assert (projectName != null);
        String pathName = "/" + projectName + "/";
        this.platformResourceURI = URI.createPlatformResourceURI((String)pathName, (boolean)true);
        this.platformPluginURI = URI.createPlatformPluginURI((String)pathName, (boolean)true);
        String fileString = testProject.getFile().toString();
        if (!fileString.endsWith("/")) {
            fileString = String.valueOf(fileString) + "/";
        }
        this.fileURI = URI.createFileURI((String)fileString);
    }

    public ProjectManager.IPackageDescriptor getPackageDescriptor(@NonNull URI ecoreURI) {
        return CLASS_PATH.getPackageDescriptor(ecoreURI);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ProjectManager.IResourceDescriptor getResourceDescriptor(@NonNull URI uri) {
        return CLASS_PATH.getResourceDescriptor(uri);
    }

    public void initializeResourceSet(@Nullable ResourceSet resourceSet) {
        if (resourceSet != null) {
            Map uriMap = resourceSet.getURIConverter().getURIMap();
            uriMap.put(this.platformResourceURI, this.fileURI);
            uriMap.put(this.platformPluginURI, this.fileURI);
        }
        CLASS_PATH.initializeResourceSet(resourceSet);
        if (resourceSet != null) {
            EList eAdapters = resourceSet.eAdapters();
            if (eAdapters.contains(CLASS_PATH)) {
                eAdapters.remove((Object)this);
            }
            if (!eAdapters.contains((Object)this)) {
                eAdapters.add(this);
            }
        }
    }
}

