/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.test.xtext.AbstractConsoleTests;

public class EcoreConsoleTests
extends AbstractConsoleTests {
    public static final @NonNull String ORG_ECLIPSE_OCL_EXAMPLES_XTEXT_TESTRESULTS = "org.eclipse.ocl.examples.xtext.tests";

    @Override
    protected void setUp() throws Exception {
        String testProjectPath = ORG_ECLIPSE_OCL_EXAMPLES_XTEXT_TESTRESULTS;
        this.doDelete(testProjectPath);
        super.setUp();
    }

    public void testConsole_Ecore() throws Exception {
        EcoreConsoleTests.assertConsoleResult(this.consolePage, (EObject)EcorePackage.Literals.ECLASS, "self.name", "'EClass'\n");
    }

    public void testConsole_OCLinEcoreTutorial() throws Exception {
        this.doDelete(ORG_ECLIPSE_OCL_EXAMPLES_XTEXT_TESTRESULTS);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI testModelURI = EcoreConsoleTests.getTestModelURI("models/documentation/OCLinEcoreTutorialForPivot.xmi");
        Resource xmiResource = resourceSet.getResource(testModelURI, true);
        EObject xmiLibrary = (EObject)xmiResource.getContents().get(0);
        EClass ecoreLibrary = xmiLibrary.eClass();
        EStructuralFeature ecoreBooks = ecoreLibrary.getEStructuralFeature("books");
        EStructuralFeature ecoreLoans = ecoreLibrary.getEStructuralFeature("loans");
        EClass ecoreBook = (EClass)ecoreBooks.getEType();
        EClass ecoreLoan = (EClass)ecoreLoans.getEType();
        EStructuralFeature bookName = ecoreBook.getEStructuralFeature("name");
        EStructuralFeature loanBook = ecoreLoan.getEStructuralFeature("book");
        EStructuralFeature bookCopies = ecoreBook.getEStructuralFeature("copies");
        List xmiBooks = (List)xmiLibrary.eGet(ecoreBooks);
        EObject b1Book = null;
        EObject b2Book = null;
        for (EObject xmiBook : xmiBooks) {
            if (xmiBook.eGet(bookName).equals("b1")) {
                b1Book = xmiBook;
                continue;
            }
            if (!xmiBook.eGet(bookName).equals("b2")) continue;
            b2Book = xmiBook;
        }
        if (b2Book == null) {
            EcoreConsoleTests.fail();
            return;
        }
        EcoreConsoleTests.assertConsoleResult(this.consolePage, b1Book, "hasSpareCopies(0)", "true\n");
        EcoreConsoleTests.assertConsoleResult(this.consolePage, b1Book, "hasSpareCopies(5)", "false\n");
        EObject aLoan = (EObject)((List)xmiLibrary.eGet(ecoreLoans)).get(0);
        EcoreConsoleTests.assertConsoleResult(this.consolePage, xmiLibrary, "books->sortedBy(name)", "Library lib::Book b1\nLibrary lib::Book b2\n");
        EcoreConsoleTests.assertConsoleResult(this.consolePage, xmiLibrary, "isAvailable()", "<b><error>Parsing failure\n</error></b><error>\n1:1: Unresolved Operation '::isAvailable()'\n</error>");
        EcoreConsoleTests.assertConsoleResult(this.consolePage, b2Book, "isAvailable()", "false\n");
        EcoreConsoleTests.assertConsoleResult(this.consolePage, b1Book, "isAvailable()", "true\n");
        aLoan.eSet(loanBook, (Object)b1Book);
        EcoreConsoleTests.assertConsoleResult(this.consolePage, b2Book, "isAvailable()", "false\n");
        EcoreConsoleTests.assertConsoleResult(this.consolePage, b1Book, "isAvailable()", "false\n");
        b2Book.eSet(bookCopies, (Object)BigInteger.valueOf(3L));
        EcoreConsoleTests.assertConsoleResult(this.consolePage, b2Book, "isAvailable()", "true\n");
        EcoreConsoleTests.assertConsoleResult(this.consolePage, b1Book, "isAvailable()", "false\n");
        EcoreConsoleTests.assertConsoleResult(this.consolePage, b1Book, "hasSpareCopies(5)", "false\n");
        EcoreConsoleTests.assertConsoleResult(this.consolePage, (EObject)ecoreBook, "name", "'Book'\n");
        EcoreConsoleTests.assertConsoleResult(this.consolePage, (EObject)ecoreBook, "copies", "<b><error>Parsing failure\n</error></b><error>\n1:1: Unresolved Element '::copies'\n</error>");
        EcoreConsoleTests.assertConsoleResult(this.consolePage, (EObject)ecoreBook, "oclType().ownedProperties->sortedBy(name)", "ecore::EClass::EClass\necore::EClass::EClass\necore::EClass::EReference\necore::EClass::abstract\necore::EClass::eAllAttributes\necore::EClass::eAllContainments\necore::EClass::eAllGenericSuperTypes\necore::EClass::eAllOperations\necore::EClass::eAllReferences\necore::EClass::eAllStructuralFeatures\necore::EClass::eAllSuperTypes\necore::EClass::eAttributes\necore::EClass::eGenericSuperTypes\necore::EClass::eIDAttribute\necore::EClass::eOperations\necore::EClass::eReferences\necore::EClass::eStructuralFeatures\necore::EClass::eSuperTypes\necore::EClass::interface\n");
    }
}

