/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.SpecializedId;
import org.eclipse.ocl.pivot.ids.TemplateableId;
import org.eclipse.ocl.pivot.internal.ids.AbstractTemplateableIdImpl;

public abstract class AbstractSpecializedIdImpl<T extends TemplateableId>
extends AbstractTemplateableIdImpl<T>
implements SpecializedId {
    protected final @NonNull T generalizedId;
    protected final @NonNull BindingsId templateBindings;

    public AbstractSpecializedIdImpl(@NonNull T generalizedId, @NonNull BindingsId templateBindings) {
        super(generalizedId.hashCode() + templateBindings.hashCode(), generalizedId.getTemplateParameters());
        int generalizedTemplateParameters;
        this.generalizedId = generalizedId;
        this.templateBindings = templateBindings;
        int templateParameterCount = generalizedTemplateParameters = generalizedId.getTemplateParameters();
        assert (templateParameterCount > 0);
        assert (templateBindings.size() == templateParameterCount);
    }

    @Override
    public @NonNull String getDisplayName() {
        StringBuilder s = new StringBuilder();
        s.append(this.generalizedId.getDisplayName());
        s.append("<");
        int i = 0;
        while (i < this.templateParameters) {
            if (i > 0) {
                s.append(",");
            }
            s.append("$" + i + ":");
            s.append(this.templateBindings.get(i));
            ++i;
        }
        s.append(">");
        return s.toString();
    }

    public @NonNull T getGeneralizedId() {
        return this.generalizedId;
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return this.generalizedId.getMetaTypeName();
    }

    @Override
    public @NonNull String getName() {
        return this.generalizedId.getName();
    }

    @Override
    public @NonNull BindingsId getTemplateBindings() {
        return this.templateBindings;
    }
}

