/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.prefuse;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.eclipse.modisco.infra.prefuse.Messages;
import org.eclipse.modisco.infra.prefuse.examples.graphview.GraphMenuAction;
import org.eclipse.modisco.infra.prefuse.examples.graphview.GraphView;
import org.eclipse.modisco.infra.prefuse.examples.graphview.OpenGraphAction;
import org.eclipse.modisco.infra.prefuse.examples.radialgraphview.RadialGraphView;
import org.eclipse.modisco.infra.prefuse.examples.treeview.TreeView;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import prefuse.Visualization;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.query.SearchQueryBinding;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.FontLib;
import prefuse.util.GraphLib;
import prefuse.util.ui.JFastLabel;
import prefuse.util.ui.JSearchPanel;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class PrefuseGraphContainer {
    private static PrefuseGraphContainer instance = new PrefuseGraphContainer();

    protected PrefuseGraphContainer() {
    }

    public static PrefuseGraphContainer getInstance() {
        return instance;
    }

    public JPanel initializeTreeViewContainer(Graph graph, String label, String image) {
        JPanel result = this.initializeTreeViewContainer(graph, label, image, null);
        return result;
    }

    public JPanel initializeTreeViewContainer(Graph graph, final String label, String image, Control controlAdapter) {
        Color BACKGROUND = Color.WHITE;
        Color FOREGROUND = Color.BLACK;
        TreeView tview = new TreeView(graph, label, image);
        tview.setBackground(BACKGROUND);
        tview.setForeground(FOREGROUND);
        JSearchPanel search = new JSearchPanel(tview.getVisualization(), "tree.nodes", Visualization.SEARCH_ITEMS, label, true, true);
        search.setShowResultCount(true);
        search.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        search.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)11));
        search.setBackground(BACKGROUND);
        search.setForeground(FOREGROUND);
        final JFastLabel title = new JFastLabel("                 ");
        title.setPreferredSize(new Dimension(350, 20));
        title.setVerticalAlignment(3);
        title.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        title.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)16));
        title.setBackground(BACKGROUND);
        title.setForeground(FOREGROUND);
        tview.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent e) {
                if (item.canGetString(label)) {
                    title.setText(item.getString(label));
                }
            }

            public void itemExited(VisualItem item, MouseEvent e) {
                title.setText(null);
            }
        });
        if (controlAdapter != null) {
            tview.addControlListener(controlAdapter);
        }
        Box box = new Box(0);
        box.add(Box.createHorizontalStrut(10));
        box.add((Component)title);
        box.add(Box.createHorizontalGlue());
        box.add((Component)search);
        box.add(Box.createHorizontalStrut(3));
        box.setBackground(BACKGROUND);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(BACKGROUND);
        panel.setForeground(FOREGROUND);
        panel.add((Component)((Object)tview), "Center");
        panel.add((Component)box, "South");
        return panel;
    }

    public JPanel initializeRadialGraphViewContainer(Graph graph, String label) {
        JPanel result = this.initializeRadialGraphViewContainer(graph, label, null);
        return result;
    }

    public JPanel initializeRadialGraphViewContainer(Graph graph, final String label, Control controlAdapter) {
        RadialGraphView gview = new RadialGraphView(graph, label);
        Visualization vis = gview.getVisualization();
        SearchQueryBinding sq = new SearchQueryBinding((TupleSet)((Table)vis.getGroup("tree.nodes")), label, (SearchTupleSet)vis.getGroup(Visualization.SEARCH_ITEMS));
        JSearchPanel search = sq.createSearchPanel();
        search.setShowResultCount(true);
        search.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        search.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)11));
        final JFastLabel title = new JFastLabel("                 ");
        title.setPreferredSize(new Dimension(350, 20));
        title.setVerticalAlignment(3);
        title.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        title.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)16));
        gview.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent e) {
                if (item.canGetString(label)) {
                    title.setText(item.getString(label));
                }
            }

            public void itemExited(VisualItem item, MouseEvent e) {
                title.setText(null);
            }
        });
        if (controlAdapter != null) {
            gview.addControlListener(controlAdapter);
        }
        Box box = new Box(0);
        box.add(Box.createHorizontalStrut(10));
        box.add((Component)title);
        box.add(Box.createHorizontalGlue());
        box.add((Component)search);
        box.add(Box.createHorizontalStrut(3));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)gview), "Center");
        panel.add((Component)box, "South");
        Color BACKGROUND = Color.WHITE;
        Color FOREGROUND = Color.DARK_GRAY;
        UILib.setColor((Component)panel, (Color)BACKGROUND, (Color)FOREGROUND);
        return panel;
    }

    public JPanel initializeGraphViewContainer(Graph graph, String label) {
        JPanel result = this.initializeGraphViewContainer(graph, label, null);
        return result;
    }

    public JPanel initializeGraphViewContainer(Graph graph, String label, Control controlAdapter) {
        GraphView view = new GraphView(graph, label);
        if (controlAdapter != null) {
            view.addControlListener(controlAdapter);
        }
        JMenu dataMenu = new JMenu(Messages.PrefuseGraphContainer_Data);
        dataMenu.add(new OpenGraphAction(view));
        dataMenu.add(new GraphMenuAction(Messages.PrefuseGraphContainer_Grid, "ctrl 1", view){

            @Override
            protected Graph getGraph() {
                return GraphLib.getGrid((int)15, (int)15);
            }
        });
        dataMenu.add(new GraphMenuAction(Messages.PrefuseGraphContainer_Clique, "ctrl 2", view){

            @Override
            protected Graph getGraph() {
                return GraphLib.getClique((int)10);
            }
        });
        dataMenu.add(new GraphMenuAction(Messages.PrefuseGraphContainer_Honeycomb, "ctrl 3", view){

            @Override
            protected Graph getGraph() {
                return GraphLib.getHoneycomb((int)5);
            }
        });
        dataMenu.add(new GraphMenuAction(Messages.PrefuseGraphContainer_BalancedTree, "ctrl 4", view){

            @Override
            protected Graph getGraph() {
                return GraphLib.getBalancedTree((int)3, (int)5);
            }
        });
        dataMenu.add(new GraphMenuAction(Messages.PrefuseGraphContainer_DiamondTree, "ctrl 5", view){

            @Override
            protected Graph getGraph() {
                return GraphLib.getDiamondTree((int)3, (int)3, (int)3);
            }
        });
        JMenuBar menubar = new JMenuBar();
        menubar.add(dataMenu);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)view), "Center");
        return panel;
    }

    public void createPartControl(Composite parent, JPanel treeview) {
        Composite composite = new Composite(parent, 0x1040000);
        Frame frame = SWT_AWT.new_Frame((Composite)composite);
        frame.add(treeview);
    }
}

