/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.common.Property;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.common.StaticProperty;
import org.eclipse.xtend.backend.types.builtin.ObjectType;
import org.eclipse.xtend.backend.types.builtin.VoidType;
import org.eclipse.xtend.backend.types.internal.SyntheticPropertyExtracter;
import org.eclipse.xtend.backend.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractType
implements BackendType {
    private final String _name;
    private final String _uniqueRepresentation;
    private final List<BackendType> _superTypes;
    private final Map<String, Property> _properties = new HashMap<String, Property>();
    private final Map<String, StaticProperty> _staticProperties = new HashMap<String, StaticProperty>();
    private final Collection<NamedFunction> _builtinOperations = new HashSet<NamedFunction>();

    public AbstractType(String name, String uniqueRepresentation, BackendType ... superTypes) {
        this._name = name;
        this._uniqueRepresentation = uniqueRepresentation;
        this._superTypes = superTypes.length == 0 ? Collections.singletonList(ObjectType.INSTANCE) : Arrays.asList(superTypes);
        BackendType[] backendTypeArray = superTypes;
        int n = superTypes.length;
        int n2 = 0;
        while (n2 < n) {
            BackendType superType = backendTypeArray[n2];
            this._builtinOperations.addAll(superType.getBuiltinOperations());
            this._staticProperties.putAll(superType.getStaticProperties());
            ++n2;
        }
    }

    public AbstractType(String name, String uniqueRepresentation, Collection<? extends BackendType> superTypes) {
        this._name = name;
        this._uniqueRepresentation = uniqueRepresentation;
        this._superTypes = new ArrayList<BackendType>(superTypes);
    }

    protected void register(Property p, BackendType type) {
        this._properties.put(p.getName(), p);
        this.register(new QualifiedName("get" + StringHelper.firstUpper(p.getName())), new GetterOperation(p));
        if (p.isWritable()) {
            this.register(new QualifiedName("set" + StringHelper.firstUpper(p.getName())), new SetterOperation(p, type));
        }
    }

    protected void register(StaticProperty p) {
        this._staticProperties.put(p.getName(), p);
    }

    protected void register(QualifiedName name, Function f) {
        this._builtinOperations.add(new NamedFunction(name, f));
    }

    @Override
    public final Collection<? extends NamedFunction> getBuiltinOperations() {
        ArrayList<? extends NamedFunction> result = new ArrayList<NamedFunction>();
        for (BackendType t : this._superTypes) {
            result.addAll(t.getBuiltinOperations());
        }
        result.addAll(this._builtinOperations);
        return result;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public final Object getProperty(ExecutionContext ctx, Object o, String name) {
        Property p = this.getProperties(ctx).get(name);
        if (p == null) {
            throw new IllegalArgumentException("no property " + name + " in type " + this.getName());
        }
        return p.get(ctx, o);
    }

    @Override
    public final void setProperty(ExecutionContext ctx, Object o, String name, Object value) {
        Property p = this.getProperties(ctx).get(name);
        if (p == null) {
            throw new IllegalArgumentException("no property " + name + " in type " + this.getName());
        }
        p.set(ctx, o, value);
    }

    @Override
    public final Collection<? extends BackendType> getSuperTypes() {
        return this._superTypes;
    }

    @Override
    public Object create() {
        throw new UnsupportedOperationException("Type " + this.getName() + " can not be instantiated reflectively.");
    }

    @Override
    public final Map<String, ? extends Property> getProperties(ExecutionContext ctx) {
        HashMap<String, ? extends Property> result = new HashMap<String, Property>();
        for (BackendType t : this._superTypes) {
            result.putAll(t.getProperties(ctx));
        }
        result.putAll(new SyntheticPropertyExtracter(ctx, this).getProperties());
        result.putAll(this._properties);
        return result;
    }

    @Override
    public final Map<String, ? extends StaticProperty> getStaticProperties() {
        return this._staticProperties;
    }

    @Override
    public String getUniqueRepresentation() {
        return this._uniqueRepresentation;
    }

    @Override
    public boolean isAssignableFrom(BackendType other) {
        if (other == VoidType.INSTANCE) {
            return true;
        }
        if (other.equals(this)) {
            return true;
        }
        for (BackendType backendType : other.getSuperTypes()) {
            if (!this.isAssignableFrom(backendType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this._name;
    }

    public abstract boolean equals(Object var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetterOperation
    implements Function {
        private final List<BackendType> _paramTypes = new ArrayList<BackendType>();
        private final Property _property;

        public GetterOperation(Property property) {
            this._property = property;
            this._paramTypes.add(AbstractType.this);
        }

        @Override
        public ExpressionBase getGuard() {
            return null;
        }

        @Override
        public List<? extends BackendType> getParameterTypes() {
            return this._paramTypes;
        }

        @Override
        public Object invoke(ExecutionContext ctx, Object[] params) {
            return this._property.get(ctx, params[0]);
        }

        @Override
        public boolean isCached() {
            return false;
        }

        @Override
        public FunctionDefContext getFunctionDefContext() {
            return null;
        }

        @Override
        public void setFunctionDefContext(FunctionDefContext fdc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BackendType getReturnType() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetterOperation
    implements Function {
        private final List<BackendType> _paramTypes = new ArrayList<BackendType>();
        private final Property _property;

        public SetterOperation(Property property, BackendType type) {
            this._property = property;
            this._paramTypes.add(AbstractType.this);
            this._paramTypes.add(type);
        }

        @Override
        public ExpressionBase getGuard() {
            return null;
        }

        @Override
        public List<? extends BackendType> getParameterTypes() {
            return this._paramTypes;
        }

        @Override
        public Object invoke(ExecutionContext ctx, Object[] params) {
            this._property.set(ctx, params[0], params[1]);
            return null;
        }

        @Override
        public boolean isCached() {
            return false;
        }

        @Override
        public FunctionDefContext getFunctionDefContext() {
            return null;
        }

        @Override
        public void setFunctionDefContext(FunctionDefContext fdc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BackendType getReturnType() {
            throw new UnsupportedOperationException();
        }
    }
}

