/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.compiler;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.compiler.BackendCompilerFacade;
import org.eclipse.xtend.backend.compiler.model.NamedParsedResource;
import org.eclipse.xtend.middleend.MiddleEnd;
import org.eclipse.xtend.middleend.MiddleEndFactory;
import org.eclipse.xtend.middleend.NoMiddleEndForResourceException;
import org.eclipse.xtend.middleend.plugins.ImportedResource;
import org.eclipse.xtend.middleend.plugins.LanguageSpecificMiddleEnd;
import org.eclipse.xtend.middleend.plugins.ParsedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBackendResourceCompilerFacade
implements BackendCompilerFacade {
    private static final Log _log = LogFactory.getLog(AbstractBackendResourceCompilerFacade.class);
    protected BackendTypesystem _typeSystem;
    protected List<LanguageSpecificMiddleEnd> _languageHandlers;
    private MiddleEnd _middleEnd;
    private boolean _initialized;

    public boolean isInitialized() {
        return this._initialized;
    }

    public void setInitialized(boolean initialized) {
        this._initialized = initialized;
    }

    public AbstractBackendResourceCompilerFacade(BackendTypesystem ts) {
        this._typeSystem = ts;
    }

    @Override
    public void compile(Collection<String> resources, String contributorNamespace, String contributorName, String outputDir, Map<Class<?>, Object> specificParams, String fileEncoding) {
        HashMap<String, Set<NamedParsedResource>> imports = new HashMap<String, Set<NamedParsedResource>>();
        this._middleEnd = this.createMiddleEnd(specificParams);
        Map parsedResources = null;
        for (String res : resources) {
            try {
                this._middleEnd.getFunctions(res);
                parsedResources = this._middleEnd.getParsedResources();
                HashSet<NamedParsedResource> resImports = new HashSet<NamedParsedResource>();
                for (ImportedResource impRes : ((ParsedResource)parsedResources.get(res)).getImports()) {
                    ParsedResource curImport = (ParsedResource)parsedResources.get(impRes.getResourceName());
                    if (curImport == null) continue;
                    resImports.add(new NamedParsedResource(impRes.getResourceName(), curImport));
                }
                this.collectReexportedResources(resImports, new HashSet<String>(), res);
                imports.put(res, resImports);
                this.compileInternal(res, (ParsedResource)parsedResources.get(res), imports, this._middleEnd, this._typeSystem, outputDir, fileEncoding);
            }
            catch (NoMiddleEndForResourceException noMiddleEndForResourceException) {
                // empty catch block
            }
        }
    }

    protected abstract void compileInternal(String var1, ParsedResource var2, Map<String, Set<NamedParsedResource>> var3, MiddleEnd var4, BackendTypesystem var5, String var6, String var7);

    protected MiddleEnd createMiddleEnd(Map<Class<?>, Object> specificParams) {
        this._middleEnd = MiddleEndFactory.canCreateFromExtentions() ? MiddleEndFactory.createFromExtensions((BackendTypesystem)this._typeSystem, specificParams) : MiddleEndFactory.create((BackendTypesystem)this._typeSystem, this._languageHandlers);
        if (this._middleEnd != null) {
            this._initialized = true;
        }
        return this._middleEnd;
    }

    public void collectReexportedResources(Set<NamedParsedResource> result, Set<String> visited, String curResource) {
        if (this._initialized) {
            ParsedResource parsedRes = (ParsedResource)this._middleEnd.getParsedResources().get(curResource);
            if (visited.contains(curResource)) {
                return;
            }
            visited.add(curResource);
            for (ImportedResource candidate : parsedRes.getImports()) {
                String candidateName = candidate.getResourceName();
                if (visited.contains(candidateName)) continue;
                if (candidate.isReexported() && parsedRes != null) {
                    result.add(new NamedParsedResource(candidateName, (ParsedResource)this._middleEnd.getParsedResources().get(candidateName)));
                }
                this.collectReexportedResources(result, visited, candidateName);
            }
        }
    }

    public BackendTypesystem getTypeSystem() {
        return this._typeSystem;
    }

    public void setTypeSystem(BackendTypesystem typeSystem) {
        this._typeSystem = typeSystem;
    }

    public List<LanguageSpecificMiddleEnd> getLanguageHandlers() {
        return this._languageHandlers;
    }

    public void setLanguageHandlers(List<LanguageSpecificMiddleEnd> languageHandlers) {
        this._languageHandlers = languageHandlers;
    }

    public MiddleEnd getMiddleEnd() {
        return this._middleEnd;
    }

    public void setMiddleEnd(MiddleEnd middleEnd) {
        this._middleEnd = middleEnd;
    }
}

