/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.internal.xtend.expression.ast.BooleanLiteral;
import org.eclipse.internal.xtend.expression.ast.BooleanOperation;
import org.eclipse.internal.xtend.expression.ast.Case;
import org.eclipse.internal.xtend.expression.ast.Cast;
import org.eclipse.internal.xtend.expression.ast.ChainExpression;
import org.eclipse.internal.xtend.expression.ast.CollectionExpression;
import org.eclipse.internal.xtend.expression.ast.ConstructorCallExpression;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.FeatureCall;
import org.eclipse.internal.xtend.expression.ast.GlobalVarExpression;
import org.eclipse.internal.xtend.expression.ast.IfExpression;
import org.eclipse.internal.xtend.expression.ast.IntegerLiteral;
import org.eclipse.internal.xtend.expression.ast.LetExpression;
import org.eclipse.internal.xtend.expression.ast.ListLiteral;
import org.eclipse.internal.xtend.expression.ast.NullLiteral;
import org.eclipse.internal.xtend.expression.ast.OperationCall;
import org.eclipse.internal.xtend.expression.ast.RealLiteral;
import org.eclipse.internal.xtend.expression.ast.StringLiteral;
import org.eclipse.internal.xtend.expression.ast.SwitchExpression;
import org.eclipse.internal.xtend.expression.ast.TypeSelectExpression;
import org.eclipse.internal.xtend.xtend.ast.CreateExtensionStatement;
import org.eclipse.internal.xtend.xtend.ast.ExpressionExtensionStatement;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.JavaExtensionStatement;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Property;
import org.eclipse.xtend.typesystem.StaticProperty;
import org.eclipse.xtend.typesystem.Type;

public final class OldTypeAnalyzer {
    public Type analyze(ExecutionContext ctx, Extension ext, Type[] paramTypes) {
        if (ext instanceof JavaExtensionStatement) {
            return this.analyzeJavaExtension(ctx, (JavaExtensionStatement)ext);
        }
        if (ext instanceof ExpressionExtensionStatement) {
            return this.analyzeExpressionExtension(ctx, (ExpressionExtensionStatement)ext, paramTypes);
        }
        if (ext instanceof CreateExtensionStatement) {
            return ctx.getTypeForName(((CreateExtensionStatement)ext).getReturnTypeIdentifier().toString());
        }
        throw new IllegalArgumentException("unknown extension type " + ext.getClass().getName());
    }

    private Type analyzeExpressionExtension(ExecutionContext ctx, ExpressionExtensionStatement ext, Type[] paramTypes) {
        ctx = ctx.cloneWithoutVariables();
        int i = 0;
        while (i < ext.getParameterNames().size()) {
            String name = (String)ext.getParameterNames().get(i);
            Type value = paramTypes[i];
            ctx = ctx.cloneWithVariable(new Variable(name, (Object)value));
            ++i;
        }
        return this.analyze(ctx, ext.getExpression());
    }

    private Type analyzeJavaExtension(ExecutionContext ctx, JavaExtensionStatement ext) {
        if (ext.getReturnTypeIdentifier() != null) {
            return ctx.getTypeForName(ext.getReturnTypeIdentifier().toString());
        }
        return ctx.getObjectType();
    }

    public Type analyze(ExecutionContext ctx, Expression expr) {
        if (expr instanceof BooleanLiteral) {
            return ctx.getBooleanType();
        }
        if (expr instanceof IntegerLiteral) {
            return ctx.getIntegerType();
        }
        if (expr instanceof NullLiteral) {
            return ctx.getVoidType();
        }
        if (expr instanceof RealLiteral) {
            return ctx.getRealType();
        }
        if (expr instanceof StringLiteral) {
            return ctx.getStringType();
        }
        if (expr instanceof ListLiteral) {
            return this.analyzeListLiteral(ctx, (ListLiteral)expr);
        }
        if (expr instanceof OperationCall) {
            return this.analyzeOperationCall(ctx, (OperationCall)expr);
        }
        if (expr instanceof CollectionExpression) {
            return this.analyzeCollectionExpression(ctx, (CollectionExpression)expr);
        }
        if (expr instanceof TypeSelectExpression) {
            return this.analyzeTypeSelect(ctx, (TypeSelectExpression)expr);
        }
        if (expr instanceof FeatureCall) {
            return this.analyzeFeatureCall(ctx, (FeatureCall)expr);
        }
        if (expr instanceof BooleanOperation) {
            return ctx.getBooleanType();
        }
        if (expr instanceof GlobalVarExpression) {
            return this.analyzeGlobalVar(ctx, (GlobalVarExpression)expr);
        }
        if (expr instanceof LetExpression) {
            return this.analyzeLet(ctx, (LetExpression)expr);
        }
        if (expr instanceof ChainExpression) {
            return this.analyzeChain(ctx, (ChainExpression)expr);
        }
        if (expr instanceof ConstructorCallExpression) {
            return this.analyzeConstructorCall(ctx, (ConstructorCallExpression)expr);
        }
        if (expr instanceof IfExpression) {
            return this.analyzeIf(ctx, (IfExpression)expr);
        }
        if (expr instanceof SwitchExpression) {
            return this.analyzeSwitch(ctx, (SwitchExpression)expr);
        }
        if (expr instanceof Cast) {
            return this.analyzeCast(ctx, (Cast)expr);
        }
        throw new IllegalArgumentException("unknown expression kind " + expr.getClass().getName());
    }

    private Type analyzeListLiteral(ExecutionContext ctx, ListLiteral expr) {
        Type innerType = null;
        Expression[] expressionArray = expr.getElements();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression ele = expressionArray[n2];
            innerType = innerType == null ? this.analyze(ctx, ele) : this.getCommonSupertype(innerType, this.analyze(ctx, ele));
            ++n2;
        }
        if (innerType == null) {
            innerType = ctx.getObjectType();
        }
        return ctx.getListType(innerType);
    }

    private Type analyzeOperationCall(ExecutionContext ctx, OperationCall expr) {
        return ctx.getObjectType();
    }

    private Type analyzeCollectionExpression(ExecutionContext ctx, CollectionExpression expr) {
        if (Arrays.asList("collect", "select", "reject", "sortBy").contains(expr.getName().toString())) {
            if (expr.getTarget() != null) {
                return this.analyze(ctx, expr.getTarget());
            }
            return ctx.getObjectType();
        }
        if (expr.getName().toString().equals("selectFirst")) {
            if (expr.getTarget() != null) {
                return ((ParameterizedType)this.analyze(ctx, expr.getTarget())).getInnerType();
            }
            return ctx.getObjectType();
        }
        if (Arrays.asList("exists", "notExists", "forAll").contains(expr.getName().toString())) {
            return ctx.getBooleanType();
        }
        throw new IllegalArgumentException("unknown collection operation " + expr.getName().toString());
    }

    private Type analyzeTypeSelect(ExecutionContext ctx, TypeSelectExpression expr) {
        Type innerType = ctx.getTypeForName(expr.getTypeName());
        return ctx.getCollectionType(innerType);
    }

    private Type analyzeFeatureCall(ExecutionContext ctx, FeatureCall expr) {
        Type type;
        Type targetType = null;
        if (expr.getTarget() == null) {
            StaticProperty staticProp = expr.getEnumLiteral(ctx);
            if (staticProp != null) {
                return staticProp.getReturnType();
            }
            Variable var = ctx.getVariable(expr.getName().toString());
            if (var != null) {
                return (Type)var.getValue();
            }
            var = ctx.getVariable("this");
            if (var != null) {
                targetType = (Type)var.getValue();
            }
        } else {
            targetType = this.analyze(ctx, expr.getTarget());
        }
        if (targetType != null) {
            Type innerType;
            Property p = targetType.getProperty(expr.getName().toString());
            if (p != null) {
                return p.getReturnType();
            }
            if (targetType instanceof ParameterizedType && (p = (innerType = ((ParameterizedType)targetType).getInnerType()).getProperty(expr.getName().toString())) != null) {
                Type rt = p.getReturnType();
                if (rt instanceof ParameterizedType) {
                    rt = ((ParameterizedType)rt).getInnerType();
                }
                return ctx.getListType(rt);
            }
            return ctx.getObjectType();
        }
        if (expr.getTarget() == null && (type = ctx.getTypeForName(expr.getName().toString())) != null) {
            return ctx.getTypeType();
        }
        return ctx.getObjectType();
    }

    private Type analyzeGlobalVar(ExecutionContext ctx, GlobalVarExpression expr) {
        return ctx.getObjectType();
    }

    private Type analyzeLet(ExecutionContext ctx, LetExpression expr) {
        Type t = this.analyze(ctx, expr.getVarExpression());
        ctx = ctx.cloneWithVariable(new Variable(expr.getName(), (Object)t));
        return this.analyze(ctx, expr.getTargetExpression());
    }

    private Type analyzeChain(ExecutionContext ctx, ChainExpression expr) {
        return this.analyze(ctx, expr.getNext());
    }

    private Type analyzeConstructorCall(ExecutionContext ctx, ConstructorCallExpression expr) {
        return ctx.getTypeForName(expr.getTypeName());
    }

    private Type analyzeIf(ExecutionContext ctx, IfExpression expr) {
        if (expr.getElsePart() == null) {
            return this.analyze(ctx, expr.getThenPart());
        }
        return this.getCommonSupertype(this.analyze(ctx, expr.getThenPart()), this.analyze(ctx, expr.getElsePart()));
    }

    private Type analyzeSwitch(ExecutionContext ctx, SwitchExpression expr) {
        Type result = this.analyze(ctx, expr.getDefaultExpr());
        for (Case curCase : expr.getCases()) {
            result = this.getCommonSupertype(result, this.analyze(ctx, curCase.getThenPart()));
        }
        return result;
    }

    private Type analyzeCast(ExecutionContext ctx, Cast expr) {
        return this.analyze(ctx, expr.getTarget());
    }

    private Type getCommonSupertype(Type t1, Type t2) {
        if (t1.isAssignableFrom(t2)) {
            return t1;
        }
        if (t2.isAssignableFrom(t1)) {
            return t2;
        }
        HashSet<Type> commonSupertypes = new HashSet<Type>();
        for (Type parent1 : t1.getSuperTypes()) {
            for (Type parent2 : t2.getSuperTypes()) {
                commonSupertypes.add(this.getCommonSupertype(parent1, parent2));
            }
        }
        Iterator iter = commonSupertypes.iterator();
        Type result = (Type)iter.next();
        while (iter.hasNext()) {
            Type candidate = (Type)iter.next();
            if (!candidate.isAssignableFrom(result)) continue;
            result = candidate;
        }
        return result;
    }
}

