/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend.internal.types;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.types.CompositeTypesystem;
import org.eclipse.xtend.backend.types.xsd.XsdTypesystem;
import org.eclipse.xtend.middleend.xtend.internal.types.TypeToBackendTypeMapper;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.xsd.type.EFeatureMapEntryTypeImpl;
import org.eclipse.xtend.typesystem.xsd.type.EFeatureMapTypeImpl;
import org.eclipse.xtend.typesystem.xsd.type.EFeatureType;
import org.eclipse.xtend.typesystem.xsd.type.EMapEntryType;
import org.eclipse.xtend.typesystem.xsd.type.EMapType;
import org.eclipse.xtend.typesystem.xsd.type.QNameType;
import org.eclipse.xtend.typesystem.xsd.type.XMLEClassType;

public class XsdTypeToBackendTypeMapper
extends TypeToBackendTypeMapper {
    private static final Log _log = LogFactory.getLog(XsdTypeToBackendTypeMapper.class);
    private XsdTypesystem _xsdTypes = null;

    public XsdTypeToBackendTypeMapper(BackendTypesystem ts) {
        try {
            if (ts instanceof XsdTypesystem) {
                this._xsdTypes = (XsdTypesystem)ts;
            } else if (ts instanceof CompositeTypesystem) {
                for (BackendTypesystem bts : ((CompositeTypesystem)ts).getInner()) {
                    if (!(bts instanceof XsdTypesystem)) continue;
                    this._xsdTypes = (XsdTypesystem)bts;
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)"Check project setup for typesystems", (Throwable)e);
        }
    }

    public BackendType convertToBackendType(Type t) {
        if (t instanceof QNameType) {
            return this._xsdTypes.getQNameType();
        }
        if (t instanceof XMLEClassType) {
            return this.convertXMLEClassType(t);
        }
        if (t instanceof EFeatureMapTypeImpl) {
            return this.convertEFeatureMapType(t);
        }
        if (t instanceof EFeatureMapEntryTypeImpl) {
            return this._xsdTypes.getEFeatureMapEntryType();
        }
        if (t instanceof EFeatureType) {
            return this._xsdTypes.getEFeatureType();
        }
        if (t instanceof EMapType) {
            return this.convertEMapType(t);
        }
        if (t instanceof EMapEntryType) {
            return this.convertEMapEntryType(t);
        }
        return null;
    }

    private BackendType convertXMLEClassType(Type t) {
        EClass eClass = (EClass)this.getField(t, "clazz");
        return this._xsdTypes.getTypeForEClassifier((EClassifier)eClass);
    }

    private BackendType convertEFeatureMapType(Type t) {
        if (t instanceof EFeatureMapTypeImpl) {
            EClass eClass = ((EFeatureMapTypeImpl)t).getOwner();
            return this._xsdTypes.getEFeatureMapType(eClass);
        }
        return null;
    }

    private BackendType convertEMapType(Type t) {
        if (t instanceof EMapType) {
            EClassifier innerType = ((EMapType)t).getInnerType();
            return this._xsdTypes.getEMapType(innerType);
        }
        return null;
    }

    private BackendType convertEMapEntryType(Type t) {
        if (t instanceof EMapEntryType) {
            EClassifier emfType = ((EMapEntryType)t).getEmfType();
            return this._xsdTypes.getEMapEntryType(emfType);
        }
        return null;
    }
}

