/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xtend.expression.ast.BooleanLiteral;
import org.eclipse.internal.xtend.expression.ast.BooleanOperation;
import org.eclipse.internal.xtend.expression.ast.Case;
import org.eclipse.internal.xtend.expression.ast.Cast;
import org.eclipse.internal.xtend.expression.ast.ChainExpression;
import org.eclipse.internal.xtend.expression.ast.CollectionExpression;
import org.eclipse.internal.xtend.expression.ast.ConstructorCallExpression;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.FeatureCall;
import org.eclipse.internal.xtend.expression.ast.GlobalVarExpression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.IfExpression;
import org.eclipse.internal.xtend.expression.ast.IntegerLiteral;
import org.eclipse.internal.xtend.expression.ast.LetExpression;
import org.eclipse.internal.xtend.expression.ast.ListLiteral;
import org.eclipse.internal.xtend.expression.ast.Literal;
import org.eclipse.internal.xtend.expression.ast.NullLiteral;
import org.eclipse.internal.xtend.expression.ast.OperationCall;
import org.eclipse.internal.xtend.expression.ast.RealLiteral;
import org.eclipse.internal.xtend.expression.ast.StringLiteral;
import org.eclipse.internal.xtend.expression.ast.SwitchExpression;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.expression.ast.TypeSelectExpression;
import org.eclipse.internal.xtend.type.baseimpl.types.CollectionTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.ListTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.ObjectTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.SetTypeImpl;
import org.eclipse.xtend.backend.aop.AdviceParamType;
import org.eclipse.xtend.backend.aop.AroundAdvice;
import org.eclipse.xtend.backend.aop.ExecutionPointcut;
import org.eclipse.xtend.backend.aop.Pointcut;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.expr.AndExpression;
import org.eclipse.xtend.backend.expr.CreateUncachedExpression;
import org.eclipse.xtend.backend.expr.HidingLocalVarDefExpression;
import org.eclipse.xtend.backend.expr.InitClosureExpression;
import org.eclipse.xtend.backend.expr.InvocationOnCollectionExpression;
import org.eclipse.xtend.backend.expr.InvocationOnObjectExpression;
import org.eclipse.xtend.backend.expr.InvocationOnWhateverExpression;
import org.eclipse.xtend.backend.expr.ListLiteralExpression;
import org.eclipse.xtend.backend.expr.LiteralExpression;
import org.eclipse.xtend.backend.expr.LocalVarEvalExpression;
import org.eclipse.xtend.backend.expr.NewLocalVarDefExpression;
import org.eclipse.xtend.backend.expr.OrExpression;
import org.eclipse.xtend.backend.expr.PropertyOnWhateverExpression;
import org.eclipse.xtend.backend.expr.SequenceExpression;
import org.eclipse.xtend.backend.syslib.SysLibNames;
import org.eclipse.xtend.backend.types.builtin.ObjectType;
import org.eclipse.xtend.backend.util.CollectionHelper;
import org.eclipse.xtend.backend.util.Pair;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.middleend.xtend.internal.OldTypeAnalyzer;
import org.eclipse.xtend.middleend.xtend.internal.TypeToBackendType;
import org.eclipse.xtend.typesystem.Operation;
import org.eclipse.xtend.typesystem.StaticProperty;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OldExpressionConverter {
    private static final Log _log = LogFactory.getLog(OldExpressionConverter.class);
    private static final String AROUND_PROCEED = "proceed";
    private static final String XPAND_AROUND_DEF = "targetDef";
    private final TypeToBackendType _typeConverter;
    private ExecutionContext _ctx;
    private final String _extensionName;
    private static final List<String> _adviceLocalVarNames = Arrays.asList("ctx", "thisJoinPointStaticPart");
    private static final AdviceParamType _wildCardParamType = new AdviceParamType((BackendType)ObjectType.INSTANCE, true);

    public OldExpressionConverter(ExecutionContext ctx, TypeToBackendType typeConverter, String extensionName) {
        this._typeConverter = typeConverter;
        this._ctx = ctx;
        this._extensionName = extensionName;
    }

    public List<String> getAdviceLocalVarNames() {
        return _adviceLocalVarNames;
    }

    public List<Type> getAdviceLocalVarTypes(TypeSystem ts) {
        return Arrays.asList(ts.getStringType(), ts.getStringType());
    }

    public AroundAdvice convertAdvice(ExpressionBase body, String namePattern, List<DeclaredParameter> params, boolean hasVarArgs) {
        ArrayList<Pair> paramTypes = new ArrayList<Pair>();
        for (DeclaredParameter dp : params) {
            paramTypes.add(new Pair((Object)dp.getName().getValue(), (Object)new AdviceParamType(this._typeConverter.convertToBackendType(dp.getType()), true)));
        }
        ExecutionPointcut pointcut = new ExecutionPointcut(namePattern, paramTypes, hasVarArgs, _wildCardParamType);
        return new AroundAdvice(body, (Pointcut)pointcut, false);
    }

    public AroundAdvice convertAdvice(ExpressionBase body, String namePattern, Identifier targetType, List<DeclaredParameter> params, boolean hasVarArgs) {
        ArrayList<Pair> paramTypes = new ArrayList<Pair>();
        if (targetType != null) {
            paramTypes.add(new Pair((Object)"this", (Object)new AdviceParamType(this._typeConverter.convertToBackendType(this._ctx.getTypeForName(targetType.getValue())), true)));
        }
        for (DeclaredParameter dp : params) {
            paramTypes.add(new Pair((Object)dp.getName().getValue(), (Object)new AdviceParamType(this._typeConverter.convertToBackendType(dp.getType()), true)));
        }
        ExecutionPointcut pointcut = new ExecutionPointcut(namePattern, paramTypes, hasVarArgs, _wildCardParamType);
        return new AroundAdvice(body, (Pointcut)pointcut, false);
    }

    public ExpressionBase convert(Expression expr) {
        if (expr instanceof BooleanLiteral) {
            return new LiteralExpression((Object)"true".equals(((Literal)expr).getLiteralValue().getValue()), this.getSourcePos((SyntaxElement)expr));
        }
        if (expr instanceof IntegerLiteral) {
            return new LiteralExpression((Object)new Long(((Literal)expr).getLiteralValue().getValue()), this.getSourcePos((SyntaxElement)expr));
        }
        if (expr instanceof NullLiteral) {
            return new LiteralExpression(null, this.getSourcePos((SyntaxElement)expr));
        }
        if (expr instanceof RealLiteral) {
            return new LiteralExpression((Object)new Double(((Literal)expr).getLiteralValue().getValue()), this.getSourcePos((SyntaxElement)expr));
        }
        if (expr instanceof StringLiteral) {
            return new LiteralExpression((Object)((StringLiteral)expr).getValue(), this.getSourcePos((SyntaxElement)expr));
        }
        if (expr instanceof ListLiteral) {
            return this.convertListLiteral((ListLiteral)expr);
        }
        if (expr instanceof OperationCall) {
            return this.convertOperationCall((OperationCall)expr);
        }
        if (expr instanceof CollectionExpression) {
            return this.convertCollectionExpression((CollectionExpression)expr);
        }
        if (expr instanceof TypeSelectExpression) {
            return this.convertTypeSelectExpression((TypeSelectExpression)expr);
        }
        if (expr instanceof FeatureCall) {
            return this.convertFeatureCallExpression((FeatureCall)expr);
        }
        if (expr instanceof BooleanOperation) {
            return this.convertBooleanOperation((BooleanOperation)expr);
        }
        if (expr instanceof GlobalVarExpression) {
            return this.convertGlobalVarExpression((GlobalVarExpression)expr);
        }
        if (expr instanceof LetExpression) {
            return this.convertLetExpression((LetExpression)expr);
        }
        if (expr instanceof ChainExpression) {
            return this.convertChainExpression((ChainExpression)expr);
        }
        if (expr instanceof ConstructorCallExpression) {
            return this.convertConstructorCallExpression((ConstructorCallExpression)expr);
        }
        if (expr instanceof IfExpression) {
            return this.convertIfExpression((IfExpression)expr);
        }
        if (expr instanceof SwitchExpression) {
            return this.convertSwitchExpression((SwitchExpression)expr);
        }
        if (expr instanceof Cast) {
            return this.convertCast((Cast)expr);
        }
        throw new IllegalArgumentException("unsupported expression type: " + expr.getClass().getName());
    }

    private ExpressionBase convertOperationCall(OperationCall expr) {
        int n;
        SourcePos sourcePos = this.getSourcePos((SyntaxElement)expr);
        String functionName = this.transformFunctionName(expr);
        ArrayList<ExpressionBase> params = new ArrayList<ExpressionBase>();
        if (!this.isAdviceProceedCall(expr)) {
            Expression[] expressionArray = expr.getParams();
            n = expressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Expression e = expressionArray[n2];
                params.add(this.convert(e));
                ++n2;
            }
        }
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        Expression[] expressionArray = expr.getParams();
        int n3 = expressionArray.length;
        n = 0;
        while (n < n3) {
            Expression e = expressionArray[n];
            paramTypes.add(new OldTypeAnalyzer().analyze(this._ctx, e));
            ++n;
        }
        if (expr.getTarget() == null) {
            if (this.hasThis()) {
                if (this.hasMatchingOperationCall(expr.getName().getValue(), paramTypes.toArray(new Type[0]))) {
                    return new InvocationOnObjectExpression(new QualifiedName(functionName), params, false, sourcePos);
                }
                LocalVarEvalExpression thisExpression = new LocalVarEvalExpression("this", sourcePos);
                Type thisType = (Type)this._ctx.getVariable("this").getValue();
                return this.createInvocationOnTargetExpression(functionName, expr.getName().getValue(), (ExpressionBase)thisExpression, thisType, params, paramTypes, true, sourcePos);
            }
            return new InvocationOnObjectExpression(new QualifiedName(functionName), params, false, sourcePos);
        }
        if (this.isAdviceProceedCall(expr)) {
            if (expr.getParams().length > 0) {
                expressionArray = expr.getParams();
                n3 = expressionArray.length;
                n = 0;
                while (n < n3) {
                    Expression e = expressionArray[n];
                    if (e instanceof ListLiteral) {
                        Expression[] expressionArray2 = ((ListLiteral)e).getElements();
                        int n4 = expressionArray2.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            Expression innerExpr = expressionArray2[n5];
                            params.add(this.convert(innerExpr));
                            ++n5;
                        }
                    } else {
                        params.add(this.convert(e));
                    }
                    ++n;
                }
                if (((FeatureCall)expr.getTarget()).getName().getValue().equals("ctx")) {
                    params.add(0, (ExpressionBase)new LocalVarEvalExpression("thisJoinPoint", sourcePos));
                    return new InvocationOnObjectExpression(new QualifiedName(AROUND_PROCEED), params, true, sourcePos);
                }
                return new InvocationOnObjectExpression(new QualifiedName(AROUND_PROCEED), Arrays.asList(new LocalVarEvalExpression("thisJoinPoint", sourcePos), new ListLiteralExpression(params, sourcePos)), true, sourcePos);
            }
            return new InvocationOnObjectExpression(new QualifiedName(AROUND_PROCEED), Arrays.asList(new LocalVarEvalExpression("thisJoinPoint", sourcePos)), true, sourcePos);
        }
        if (this.isAdviceCtxLiteral((FeatureCall)expr)) {
            return new InvocationOnObjectExpression(new QualifiedName(functionName), Arrays.asList(new LocalVarEvalExpression("thisJoinPoint", sourcePos)), true, sourcePos);
        }
        return this.createInvocationOnTargetExpression(functionName, expr.getName().getValue(), this.convert(expr.getTarget()), new OldTypeAnalyzer().analyze(this._ctx, expr.getTarget()), params, paramTypes, true, sourcePos);
    }

    private boolean isAdviceProceedCall(OperationCall expr) {
        return expr.getName().getValue().equals(AROUND_PROCEED) && expr.getTarget() instanceof FeatureCall && this.isAdviceCtxLiteral((FeatureCall)expr);
    }

    private boolean isAdviceCtxLiteral(FeatureCall expr) {
        if (expr.getTarget() instanceof FeatureCall) {
            return ((FeatureCall)expr.getTarget()).getName().getValue().equals("ctx") || ((FeatureCall)expr.getTarget()).getName().getValue().equals(XPAND_AROUND_DEF);
        }
        return false;
    }

    private boolean hasMatchingOperationCall(String functionName, Type[] paramTypes) {
        if (this._ctx.getExtensionForTypes(functionName, paramTypes) != null) {
            return true;
        }
        if (paramTypes.length == 0) {
            return false;
        }
        Type target = paramTypes[0];
        return target.getOperation(functionName, (Type[])CollectionHelper.withoutFirst((Object[])paramTypes)) != null;
    }

    private boolean hasPotentiallyMatchingOperationCall(String functionName, Type[] paramTypes) {
        Set operations = paramTypes[0].getAllOperations();
        Type[] typeArray = paramTypes;
        int n = paramTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type paramType = typeArray[n2];
            if (this.isObjectType(paramType)) {
                for (Operation operation : operations) {
                    if (!operation.getName().equals(functionName)) continue;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private String transformFunctionName(OperationCall expr) {
        String functionName = expr.getName().getValue();
        Type targetType = expr.analyze(this._ctx, new HashSet());
        if ("+".equals(functionName)) {
            return "operatorPlus";
        }
        if ("-".equals(functionName)) {
            return "operatorMinus";
        }
        if ("*".equals(functionName)) {
            return "operatorMult";
        }
        if ("/".equals(functionName)) {
            return "operatorDiv";
        }
        if ("%".equals(functionName)) {
            return "operatorMod";
        }
        if ("==".equals(functionName)) {
            return SysLibNames.OPERATOR_EQUALS;
        }
        if ("!=".equals(functionName)) {
            return "operatorNotEquals";
        }
        if ("<".equals(functionName)) {
            return "operatorLess";
        }
        if ("<=".equals(functionName)) {
            return "operatorLessOrEquals";
        }
        if (">=".equals(functionName)) {
            return "operatorGreaterOrEquals";
        }
        if (">".equals(functionName)) {
            return "operatorGreater";
        }
        if ("!".equals(functionName)) {
            return "operatorNot";
        }
        if ("subString".equals(functionName)) {
            return "substring";
        }
        if ("replaceAll".equals(functionName)) {
            return "replaceAllUsingRegex";
        }
        if ("add".equals(functionName)) {
            return "XtendAdd";
        }
        if ("addAll".equals(functionName)) {
            return "XtendAddAll";
        }
        if ("remove".equals(functionName)) {
            return "XtendRemove";
        }
        if ("removeAll".equals(functionName)) {
            return "XtendRemoveAll";
        }
        if ("replaceFirst".equals(functionName)) {
            return "XtendStringReplaceFirst";
        }
        if ("upTo".equals(functionName)) {
            return "XtendUpto";
        }
        if ("getFeature".equals(functionName) && (targetType.isAssignableFrom(this._ctx.getFeatureType()) || targetType.isAssignableFrom(this._ctx.getTypeType()))) {
            return "XtendTypeGetFeature";
        }
        if ("getProperty".equals(functionName) && targetType.isAssignableFrom(this._ctx.getTypeType())) {
            return "XtendTypeGetProperty";
        }
        if ("getOperation".equals(functionName) && (targetType.isAssignableFrom(this._ctx.getOperationType()) || targetType.isAssignableFrom(this._ctx.getTypeType()))) {
            return "XtendTypeGetOperation";
        }
        if ("getParameterTypes".equals(functionName)) {
            return "XtendOperationGetParameterTypes";
        }
        if ("evaluate".equals(functionName)) {
            return "XtendOperationEvaluate";
        }
        if ("compareTo".equals(functionName)) {
            return "xtendCompareTo";
        }
        if ("toString".equals(functionName) && expr.getTarget() instanceof FeatureCall && ((FeatureCall)expr.getTarget()).getName().getValue().equals(XPAND_AROUND_DEF)) {
            return "xtendDefinitionToString";
        }
        return functionName;
    }

    private ExpressionBase createInvocationOnTargetExpression(String functionName, String oldFunctionName, ExpressionBase targetExpression, Type targetType, List<ExpressionBase> params, List<Type> paramTypes, boolean isMethodStyle, SourcePos sourcePos) {
        List<ExpressionBase> paramsWithoutFirst = params;
        ArrayList<ExpressionBase> allParams = new ArrayList<ExpressionBase>();
        allParams.add(targetExpression);
        allParams.addAll(params);
        if (this.isCollectionType(targetType)) {
            paramTypes.add(0, targetType);
            Type[] paramTypeArray = paramTypes.toArray(new Type[0]);
            if (this.hasMatchingOperationCall(oldFunctionName, paramTypeArray)) {
                return new InvocationOnObjectExpression(new QualifiedName(functionName), allParams, true, sourcePos);
            }
            if (this.hasPotentiallyMatchingOperationCall(oldFunctionName, paramTypeArray)) {
                return new InvocationOnWhateverExpression(new QualifiedName(functionName), allParams, isMethodStyle, sourcePos);
            }
            return new InvocationOnCollectionExpression(targetExpression, new QualifiedName(functionName), paramsWithoutFirst, sourcePos);
        }
        if (this.isObjectType(targetType)) {
            return new InvocationOnWhateverExpression(new QualifiedName(functionName), allParams, isMethodStyle, sourcePos);
        }
        return new InvocationOnObjectExpression(new QualifiedName(functionName), allParams, this.isNullIfNullParam(functionName), sourcePos);
    }

    private ExpressionBase convertTypeSelectExpression(TypeSelectExpression expr) {
        SourcePos sourcePos = this.getSourcePos((SyntaxElement)expr);
        Type t = this._ctx.getTypeForName(expr.getTypeName());
        LiteralExpression typeExpr = new LiteralExpression((Object)this._typeConverter.convertToBackendType(t), sourcePos);
        if (expr.getTarget() == null) {
            if (!this.hasThis()) {
                throw new IllegalStateException("typeSelect with neither a target nor an implicit 'this'");
            }
            LocalVarEvalExpression thisExpr = new LocalVarEvalExpression("this", sourcePos);
            return new InvocationOnObjectExpression(new QualifiedName("typeSelect"), Arrays.asList(thisExpr, typeExpr), true, sourcePos);
        }
        return new InvocationOnObjectExpression(new QualifiedName("typeSelect"), Arrays.asList(this.convert(expr.getTarget()), typeExpr), false, sourcePos);
    }

    private ExpressionBase convertSwitchExpression(SwitchExpression expr) {
        ArrayList<Pair> cases = new ArrayList<Pair>();
        for (Case c : expr.getCases()) {
            cases.add(new Pair((Object)this.convert(c.getCondition()), (Object)this.convert(c.getThenPart())));
        }
        Expression switchExpr = expr.getSwitchExpr();
        ExpressionBase convertedSwitchExpr = null;
        if (switchExpr != null) {
            convertedSwitchExpr = this.convert(switchExpr);
        }
        return new org.eclipse.xtend.backend.expr.SwitchExpression(convertedSwitchExpr, cases, this.convert(expr.getDefaultExpr()), this.getSourcePos((SyntaxElement)expr));
    }

    private ExpressionBase convertCast(Cast expr) {
        return this.convert(expr.getTarget());
    }

    private ExpressionBase convertListLiteral(ListLiteral expr) {
        ArrayList<ExpressionBase> inner = new ArrayList<ExpressionBase>();
        Expression[] expressionArray = expr.getElements();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            inner.add(this.convert(e));
            ++n2;
        }
        return new ListLiteralExpression(inner, this.getSourcePos((SyntaxElement)expr));
    }

    private ExpressionBase convertLetExpression(LetExpression expr) {
        ExpressionBase varExpr = this.convert(expr.getVarExpression());
        Type varType = new OldTypeAnalyzer().analyze(this._ctx, expr.getVarExpression());
        ExecutionContext oldCtx = this._ctx;
        this._ctx = this._ctx.cloneWithVariable(new Variable(expr.getName(), (Object)varType));
        try {
            if (oldCtx.getVisibleVariables().containsKey(expr.getName())) {
                HidingLocalVarDefExpression hidingLocalVarDefExpression = new HidingLocalVarDefExpression(expr.getName(), varExpr, this.convert(expr.getTargetExpression()), this.getSourcePos((SyntaxElement)expr));
                return hidingLocalVarDefExpression;
            }
            NewLocalVarDefExpression newLocalVarDefExpression = new NewLocalVarDefExpression(expr.getName(), varExpr, this.convert(expr.getTargetExpression()), this.getSourcePos((SyntaxElement)expr));
            return newLocalVarDefExpression;
        }
        finally {
            this._ctx = oldCtx;
        }
    }

    private ExpressionBase convertIfExpression(IfExpression expr) {
        LiteralExpression elseExpr = expr.getElsePart() != null ? this.convert(expr.getElsePart()) : new LiteralExpression(null, this.getSourcePos((SyntaxElement)expr));
        return new org.eclipse.xtend.backend.expr.IfExpression(this.convert(expr.getCondition()), this.convert(expr.getThenPart()), (ExpressionBase)elseExpr, this.getSourcePos((SyntaxElement)expr));
    }

    private ExpressionBase convertFeatureCallExpression(FeatureCall expr) {
        SourcePos sourcePos = this.getSourcePos((SyntaxElement)expr);
        if (expr.getTarget() == null) {
            StaticProperty staticProp = expr.getEnumLiteral(this._ctx);
            if (staticProp != null) {
                return new LiteralExpression(staticProp.get(), sourcePos);
            }
            if (this._ctx.getVisibleVariables().containsKey(expr.getName().getValue())) {
                return new LocalVarEvalExpression(expr.getName().getValue(), sourcePos);
            }
            try {
                return new LiteralExpression((Object)this._typeConverter.convertToBackendType(expr.getName()), sourcePos);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.hasThis()) {
                    LocalVarEvalExpression thisExpr = new LocalVarEvalExpression("this", sourcePos);
                    return this.createPropertyExpression((ExpressionBase)thisExpr, (Type)((Variable)this._ctx.getVisibleVariables().get("this")).getValue(), expr.getName().getValue(), sourcePos);
                }
                if (expr instanceof FeatureCall && expr.getName().getValue().equals("this")) {
                    LocalVarEvalExpression thisExpr = new LocalVarEvalExpression("this", sourcePos);
                    return thisExpr;
                }
                throw new IllegalArgumentException("feature call " + expr.toString() + " does not match any feature: " + sourcePos);
            }
        }
        if (this.isAdviceCtxLiteral(expr)) {
            Type t = new OldTypeAnalyzer().analyze(this._ctx, expr.getTarget());
            return this.createAdvCtxPropertyExpression((ExpressionBase)new LocalVarEvalExpression("thisJoinPoint", sourcePos), t, expr, sourcePos);
        }
        Type t = new OldTypeAnalyzer().analyze(this._ctx, expr.getTarget());
        return this.createPropertyExpression(this.convert(expr.getTarget()), t, expr.getName().getValue(), sourcePos);
    }

    private ExpressionBase createPropertyExpression(ExpressionBase target, Type type, String varName, SourcePos sourcePos) {
        String builtinPropName = this.transformPropertyName(target, type, varName);
        if (builtinPropName != null) {
            return new InvocationOnWhateverExpression(new QualifiedName(builtinPropName), Arrays.asList(target), true, sourcePos);
        }
        return new PropertyOnWhateverExpression(target, varName, sourcePos);
    }

    private ExpressionBase createAdvCtxPropertyExpression(ExpressionBase target, Type type, FeatureCall expr, SourcePos sourcePos) {
        String builtinPropName = this.transformAdvCtxPropertyName(expr);
        if (builtinPropName != null) {
            return new InvocationOnWhateverExpression(new QualifiedName(builtinPropName), Arrays.asList(target), true, sourcePos);
        }
        return new PropertyOnWhateverExpression(target, expr.getName().getValue(), sourcePos);
    }

    private String transformPropertyName(ExpressionBase target, Type type, String varName) {
        if (varName.equals("metaType")) {
            return "XtendMetaType";
        }
        if (varName.equals("elements") && type.isAssignableFrom(this._ctx.getTypeForName("xpand2::Iterator"))) {
            return "XpandIteratorElements";
        }
        if (varName.equals("allStaticProperties") && type.isAssignableFrom(this._ctx.getTypeType())) {
            return "XtendTypeAllStaticProperties";
        }
        if (varName.equals("allFeatures") && type.isAssignableFrom(this._ctx.getTypeType())) {
            return "XtendTypeAllFeatures";
        }
        if (varName.equals("allOperations") && type.isAssignableFrom(this._ctx.getTypeType())) {
            return "XtendTypeAllOperations";
        }
        if (varName.equals("allProperties") && type.isAssignableFrom(this._ctx.getTypeType())) {
            return "XtendTypeAllProperties";
        }
        if (varName.equals("superTypes") && type.isAssignableFrom(this._ctx.getTypeType())) {
            return "XtendTypeSuperTypes";
        }
        if (varName.equals("documentation") && type.isAssignableFrom(this._ctx.getTypeType())) {
            return "XtendTypeDocumentation";
        }
        if (varName.equals("returnType") && type.isAssignableFrom(this._ctx.getFeatureType())) {
            return "XtendFeatureReturnType";
        }
        if (varName.equals("owner") && type.isAssignableFrom(this._ctx.getFeatureType())) {
            return "XtendFeatureOwner";
        }
        if (varName.equals("name")) {
            return "XtendName";
        }
        return null;
    }

    private String transformAdvCtxPropertyName(FeatureCall expr) {
        String varName = expr.getName().getValue();
        Expression target = expr.getTarget();
        if ("paramTypes".equals(varName) && target instanceof FeatureCall && ((FeatureCall)target).getName().getValue().equals(XPAND_AROUND_DEF)) {
            return "xtendDefinitionParamTypes";
        }
        if ("paramNames".equals(varName) && target instanceof FeatureCall && ((FeatureCall)target).getName().getValue().equals(XPAND_AROUND_DEF)) {
            return "xtendDefinitionParamNames";
        }
        if ("name".equals(varName) && target instanceof FeatureCall && ((FeatureCall)target).getName().getValue().equals(XPAND_AROUND_DEF)) {
            return "xtendDefinitionName";
        }
        if ("paramTypes".equals(varName)) {
            return "adviceCtxParamTypes";
        }
        if ("targetType".equals(varName)) {
            return "adviceCtxTargetType";
        }
        if ("paramNames".equals(varName)) {
            return "adviceCtxParamNames";
        }
        if ("paramValues".equals(varName)) {
            return "adviceCtxParamValues";
        }
        if ("name".equals(varName)) {
            return "adviceCtxName";
        }
        return null;
    }

    private ExpressionBase convertConstructorCallExpression(ConstructorCallExpression expr) {
        BackendType t = this._typeConverter.convertToBackendType(expr.getType());
        return new CreateUncachedExpression(t, this.getSourcePos((SyntaxElement)expr));
    }

    private ExpressionBase convertCollectionExpression(CollectionExpression expr) {
        SourcePos sourcePos = this.getSourcePos((SyntaxElement)expr);
        String functionName = expr.getName().getValue();
        ExecutionContext oldCtx = this._ctx;
        this._ctx = this._ctx.cloneWithVariable(new Variable(expr.getElementName(), (Object)new ObjectTypeImpl((TypeSystem)this._ctx, "Object")));
        ExpressionBase bodyExpr = this.convert(expr.getClosure());
        this._ctx = oldCtx;
        InitClosureExpression closureExpr = new InitClosureExpression(Arrays.asList(expr.getElementName()), Arrays.asList(ObjectType.INSTANCE), bodyExpr, sourcePos);
        if (expr.getTarget() == null) {
            if (!this.hasThis()) {
                throw new IllegalStateException(String.valueOf(functionName) + " with neither a target nor an implicit 'this'");
            }
            LocalVarEvalExpression thisExpr = new LocalVarEvalExpression("this", sourcePos);
            return new InvocationOnObjectExpression(new QualifiedName(functionName), Arrays.asList(thisExpr, closureExpr), true, sourcePos);
        }
        return new InvocationOnObjectExpression(new QualifiedName(functionName), Arrays.asList(this.convert(expr.getTarget()), closureExpr), true, sourcePos);
    }

    private ExpressionBase convertChainExpression(ChainExpression expr) {
        return new SequenceExpression(this.getInner(expr), this.getSourcePos((SyntaxElement)expr));
    }

    private List<ExpressionBase> getInner(ChainExpression expr) {
        ArrayList<ExpressionBase> result = new ArrayList<ExpressionBase>();
        if (expr.getFirst() instanceof ChainExpression) {
            result.addAll(this.getInner((ChainExpression)expr.getFirst()));
        } else {
            result.add(this.convert(expr.getFirst()));
        }
        if (expr.getNext() instanceof ChainExpression) {
            result.addAll(this.getInner((ChainExpression)expr.getNext()));
        } else {
            result.add(this.convert(expr.getNext()));
        }
        return result;
    }

    private ExpressionBase convertGlobalVarExpression(GlobalVarExpression expr) {
        return new InvocationOnObjectExpression(new QualifiedName("XtendGlobalVar"), Arrays.asList(new LiteralExpression((Object)expr.getVarName(), this.getSourcePos((SyntaxElement)expr))), true, this.getSourcePos((SyntaxElement)expr));
    }

    private ExpressionBase convertBooleanOperation(BooleanOperation expr) {
        ExpressionBase left = this.convert(expr.getLeft());
        ExpressionBase right = this.convert(expr.getRight());
        if ("&&".equals(expr.getOperator().getValue())) {
            return new AndExpression(left, right, this.getSourcePos((SyntaxElement)expr));
        }
        if ("||".equals(expr.getOperator().getValue())) {
            return new OrExpression(left, right, this.getSourcePos((SyntaxElement)expr));
        }
        if ("implies".equals(expr.getOperator().getValue())) {
            return new InvocationOnObjectExpression(new QualifiedName("implies"), Arrays.asList(left, right), true, this.getSourcePos((SyntaxElement)expr));
        }
        throw new IllegalArgumentException("unknown boolean operator " + expr.getOperator().getValue());
    }

    public SourcePos getSourcePos(SyntaxElement se) {
        return OldExpressionConverter.getSourcePos(se, this._extensionName);
    }

    public static SourcePos getSourcePos(SyntaxElement se, String extensionName) {
        return new SourcePos(se.getFileName(), extensionName, se.getLine());
    }

    private boolean isObjectType(Type t) {
        return t instanceof ObjectTypeImpl;
    }

    private boolean isCollectionType(Type t) {
        return t instanceof CollectionTypeImpl || t instanceof ListTypeImpl || t instanceof SetTypeImpl;
    }

    public boolean hasThis() {
        return this._ctx.getVisibleVariables().containsKey("this");
    }

    private boolean hasThisJoinPoint() {
        return this._ctx.getVisibleVariables().containsKey("ctx");
    }

    private boolean isNullIfNullParam(String functionName) {
        return !functionName.equals(SysLibNames.OPERATOR_EQUALS) && !functionName.equals("operatorNotEquals");
    }

    public ExecutionContext getExecutionContext() {
        return this._ctx;
    }

    public void setExecutionContext(ExecutionContext ctx) {
        this._ctx = ctx;
    }
}

