/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.ast;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.internal.xpand2.XpandUtil;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.util.ProfileCollector;
import org.eclipse.xpand2.XpandCompilerIssue;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.output.InsertionPointSupport;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandStatement
extends Statement {
    private boolean foreach = false;
    private Expression[] parameters = new Expression[0];
    private Expression separator = null;
    private Expression target = null;
    private Identifier definition;
    private boolean onFileClose = false;
    private boolean deferredToFileClose = false;
    private String targetNamespace;

    public ExpandStatement(Identifier definition, Expression target, Expression separator, Expression[] parameters, boolean foreach, boolean onFileClose) {
        this.definition = definition;
        this.target = target;
        this.separator = separator;
        this.parameters = parameters != null ? parameters : new Expression[]{};
        this.foreach = foreach;
        this.onFileClose = onFileClose;
    }

    public Identifier getDefinition() {
        return this.definition;
    }

    public boolean isForeach() {
        return this.foreach;
    }

    public Expression[] getParameters() {
        return this.parameters;
    }

    public List<Expression> getParametersAsList() {
        return Arrays.asList(this.parameters);
    }

    public Expression getSeparator() {
        return this.separator;
    }

    public Expression getTarget() {
        return this.target;
    }

    public boolean isOnFileClose() {
        return this.onFileClose;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void analyzeInternal(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type[] paramTypes = new Type[this.getParameters().length];
        int i = 0;
        while (i < this.getParameters().length) {
            paramTypes[i] = this.getParameters()[i].analyze((ExecutionContext)ctx, issues);
            ++i;
        }
        Type targetType = null;
        if (this.isForeach()) {
            targetType = this.target.analyze((ExecutionContext)ctx, issues);
            if (!ctx.getCollectionType(ctx.getObjectType()).isAssignableFrom(targetType)) {
                issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "Collection type expected!", (SyntaxElement)this.target));
                return;
            }
            targetType = targetType instanceof ParameterizedType ? ((ParameterizedType)targetType).getInnerType() : ctx.getObjectType();
        } else {
            Variable var = ctx.getVariable("this");
            if (var == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "No implicit variable 'this' could be found!", (SyntaxElement)this.target));
                return;
            }
            targetType = (Type)var.getValue();
            if (this.target != null) {
                targetType = this.target.analyze((ExecutionContext)ctx, issues);
            }
        }
        if (targetType == null) return;
        if (Arrays.asList(paramTypes).contains(null)) {
            return;
        }
        XpandDefinition def = ctx.findDefinition(this.getDefinition().getValue(), targetType, paramTypes);
        if (def == null) {
            issues.add(new AnalysationIssue(XpandCompilerIssue.DEFINITION_NOT_FOUND, "Couldn't find definition " + this.getDefinition().getValue() + this.getParamTypeString(paramTypes) + " for type " + targetType.getName(), (SyntaxElement)this));
            return;
        }
        this.targetNamespace = XpandUtil.withoutLastSegment(def.getOwner().getFullyQualifiedName());
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        String defName = this.getDefinition().getValue();
        String sep = (String)(this.separator != null ? this.separator.evaluate((ExecutionContext)ctx) : null);
        if (this.onFileClose && !this.deferredToFileClose) {
            if (!(ctx.getOutput() instanceof InsertionPointSupport)) {
                throw new EvaluationException("Output implementation must implement InsertionPointSupport when using ONFILECLOSE", (SyntaxElement)this, (ExecutionContext)ctx);
            }
            ctx = ((XpandExecutionContextImpl)ctx).cloneWithStatement(this);
            ((InsertionPointSupport)((Object)ctx.getOutput())).registerInsertionPoint(this);
            this.deferredToFileClose = true;
            return;
        }
        this.deferredToFileClose = false;
        Object targetObject = null;
        if (this.isForeach()) {
            targetObject = this.target.evaluate((ExecutionContext)ctx);
            if (targetObject != null) {
                if (!(targetObject instanceof Collection)) {
                    throw new EvaluationException("Collection expected!", (SyntaxElement)this.target, (ExecutionContext)ctx);
                }
                Collection col = (Collection)targetObject;
                Iterator iter = col.iterator();
                while (iter.hasNext()) {
                    Object targetObj = iter.next();
                    Object[] params = new Object[this.getParameters().length];
                    int i = 0;
                    while (i < this.getParameters().length) {
                        params[i] = this.getParameters()[i].evaluate((ExecutionContext)ctx);
                        ++i;
                    }
                    Type[] paramTypes = new Type[params.length];
                    int i2 = 0;
                    while (i2 < params.length) {
                        paramTypes[i2] = ctx.getType(params[i2]);
                        ++i2;
                    }
                    ctx.preTask(this);
                    this.invokeDefinition(defName, targetObj, params, paramTypes, ctx);
                    ctx.postTask(this);
                    if (sep == null || !iter.hasNext()) continue;
                    if (this.onFileClose && ctx.getOutput() instanceof InsertionPointSupport) {
                        ((InsertionPointSupport)((Object)ctx.getOutput())).activateInsertionPoint(this);
                    }
                    try {
                        ctx.getOutput().write(sep);
                    }
                    finally {
                        if (this.onFileClose && ctx.getOutput() instanceof InsertionPointSupport) {
                            ((InsertionPointSupport)((Object)ctx.getOutput())).deactivateInsertionPoint(this);
                        }
                    }
                }
            }
        } else {
            Object[] params = new Object[this.getParameters().length];
            int i = 0;
            while (i < this.getParameters().length) {
                params[i] = this.getParameters()[i].evaluate((ExecutionContext)ctx);
                ++i;
            }
            Type[] paramTypes = new Type[params.length];
            int i3 = 0;
            while (i3 < params.length) {
                paramTypes[i3] = ctx.getType(params[i3]);
                ++i3;
            }
            if (this.target != null) {
                targetObject = this.target.evaluate((ExecutionContext)ctx);
            } else {
                Variable var = ctx.getVariable("this");
                targetObject = var.getValue();
            }
            if (targetObject != null) {
                this.invokeDefinition(defName, targetObject, params, paramTypes, ctx);
            }
        }
    }

    private void invokeDefinition(String defName, Object targetObj, Object[] params, Type[] paramTypes, XpandExecutionContext ctx) {
        Type t = ctx.getType(targetObj);
        XpandDefinition def = ctx.findDefinition(defName, t, paramTypes);
        if (def == null) {
            String errorMsg = "No Definition '" + defName + this.getParamTypeString(paramTypes) + " for " + t.getName() + "' found!";
            if (t.getTypeSystem().getObjectType().equals(t)) {
                errorMsg = String.valueOf(errorMsg) + " Maybe your forgot to configure the correct meta model in the workflow?";
            }
            throw new EvaluationException(errorMsg, (SyntaxElement)this, (ExecutionContext)ctx);
        }
        this.targetNamespace = XpandUtil.withoutLastSegment(def.getOwner().getFullyQualifiedName());
        try {
            try {
                ProfileCollector.getInstance().enter(def.toString());
                def.evaluate((XpandExecutionContext)ctx.cloneWithoutVariables(), targetObj, params);
            }
            catch (EvaluationException e) {
                e.addStackElement((SyntaxElement)this, (ExecutionContext)ctx);
                throw e;
            }
        }
        finally {
            ProfileCollector.getInstance().leave();
        }
    }

    private String getParamTypeString(Type[] paramTypes) {
        if (paramTypes.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < paramTypes.length) {
            Type type = paramTypes[i];
            buff.append(type.getName());
            if (i + 1 < paramTypes.length) {
                buff.append(", ");
            }
            ++i;
        }
        return buff.append(")").toString();
    }

    private String getParamString(Expression[] paramTypes) {
        if (paramTypes.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < paramTypes.length) {
            Expression type = paramTypes[i];
            buff.append(type);
            if (i + 1 < paramTypes.length) {
                buff.append(", ");
            }
            ++i;
        }
        return buff.append(")").toString();
    }

    public String toString() {
        return "EXPAND " + this.definition + this.getParamString(this.getParameters()) + (this.target != null ? String.valueOf(this.isForeach() ? " FOREACH " : " FOR ") + this.target : "") + (this.separator != null ? " SEPARATOR " + this.separator : "") + (this.onFileClose ? " ONFILECLOSE " : "");
    }

    public String getNameString(ExecutionContext context) {
        return "EXPAND";
    }
}

