/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.xtend.backend.BackendFacade;
import org.eclipse.xtend.backend.aop.AroundAdvice;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.functions.FunctionDefContextInternal;
import org.eclipse.xtend.backend.functions.internal.FunctionDefContextImpl;
import org.eclipse.xtend.backend.syslib.SyslibContributor;
import org.eclipse.xtend.middleend.MiddleEnd;
import org.eclipse.xtend.middleend.javaannotations.JavaFunctionClassContributor;
import org.eclipse.xtend.middleend.plugins.FunctionDefContextProvider;
import org.eclipse.xtend.middleend.plugins.ImportedResource;
import org.eclipse.xtend.middleend.plugins.LanguageSpecificMiddleEnd;
import org.eclipse.xtend.middleend.plugins.ParsedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MiddleEndImpl
implements MiddleEnd {
    private static final Log _log = LogFactory.getLog(MiddleEndImpl.class);
    private final Map<String, ParsedResource> _parsedResources = new HashMap<String, ParsedResource>();
    private final Map<String, FunctionDefContext> _fdcs = new HashMap<String, FunctionDefContext>();
    private final List<LanguageSpecificMiddleEnd> _languageHandlers;
    private final List<FunctionDefContextProvider> _fdcProviders = new ArrayList<FunctionDefContextProvider>();
    private final ExecutionContext _ctx;
    private final BackendTypesystem _ts;
    private boolean _isInitializingSyslib = false;

    public MiddleEndImpl(BackendTypesystem ts, List<LanguageSpecificMiddleEnd> languageHandlers) {
        if (languageHandlers == null) {
            languageHandlers = new ArrayList<LanguageSpecificMiddleEnd>();
        }
        languageHandlers.add(new JavaFunctionClassContributor());
        this._ts = ts;
        this._languageHandlers = languageHandlers;
        for (LanguageSpecificMiddleEnd handler : languageHandlers) {
            handler.setMiddleEnd(this);
        }
        this._ctx = BackendFacade.createExecutionContext(this.createEmptyFdc(), ts, false);
    }

    private LanguageSpecificMiddleEnd findHandler(String resourceName) {
        for (LanguageSpecificMiddleEnd candidate : this._languageHandlers) {
            if (!candidate.canHandle(resourceName)) continue;
            _log.debug((Object)("middle end " + candidate.getName() + " handles resource " + resourceName));
            return candidate;
        }
        _log.warn((Object)("no middle end for  resource " + resourceName));
        throw new IllegalArgumentException("no middle end for resource " + resourceName);
    }

    private ParsedResource parseResource(String resourceName) {
        if (this._parsedResources.containsKey(resourceName)) {
            return this._parsedResources.get(resourceName);
        }
        ParsedResource result = this.findHandler(resourceName).parseResource(resourceName);
        this._parsedResources.put(resourceName, result);
        FunctionDefContext fdc = this.getFdc(resourceName);
        for (NamedFunction f : result.getPrivateFunctions()) {
            f.getFunction().setFunctionDefContext(fdc);
        }
        for (NamedFunction f : result.getPublicFunctions()) {
            f.getFunction().setFunctionDefContext(fdc);
        }
        for (AroundAdvice advice : result.getAdvice()) {
            advice.setFunctionDefContext(fdc);
        }
        return result;
    }

    private FunctionDefContext getFdc(String resourceName) {
        if (this._fdcs.containsKey(resourceName)) {
            return this._fdcs.get(resourceName);
        }
        for (FunctionDefContextProvider fdcProv : this._fdcProviders) {
            if (!fdcProv.canHandle(resourceName)) continue;
            this._fdcs.put(resourceName, fdcProv.getFdc(resourceName));
            return this._fdcs.get(resourceName);
        }
        FunctionDefContextInternal result = this.createEmptyFdc();
        this._fdcs.put(resourceName, result);
        HashSet<String> reexported = new HashSet<String>();
        this.collectReexportedResources(reexported, new HashSet<String>(), resourceName);
        for (String importedReexp : reexported) {
            for (NamedFunction f : this.parseResource(importedReexp).getPublicFunctions()) {
                result.register(f, true);
            }
        }
        for (ImportedResource ir : this.parseResource(resourceName).getImports()) {
            if (ir.isReexported()) continue;
            for (NamedFunction f : this.parseResource(ir.getResourceName()).getPublicFunctions()) {
                result.register(f, false);
            }
        }
        for (NamedFunction f : this.parseResource(resourceName).getPrivateFunctions()) {
            result.register(f, false);
        }
        for (NamedFunction f : this.parseResource(resourceName).getPublicFunctions()) {
            result.register(f, true);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("fdc for " + resourceName + ": "));
            _log.debug((Object)("    reexported: " + reexported));
            _log.debug((Object)("    public functions: " + result.getPublicFunctions()));
        }
        return result;
    }

    @Override
    public void applyAdvice(String resourceName) {
        for (AroundAdvice advice : this.parseResource(resourceName).getAdvice()) {
            this._ctx.setAdviceContext(this._ctx.getAdviceContext().copyWithAdvice(advice));
        }
    }

    @Override
    public FunctionDefContext getFunctions(String resourceName) {
        return this.getFdc(resourceName);
    }

    private void collectReexportedResources(Set<String> result, Set<String> visited, String curResource) {
        if (visited.contains(curResource)) {
            return;
        }
        visited.add(curResource);
        for (ImportedResource candidate : this.parseResource(curResource).getImports()) {
            String candidateName = candidate.getResourceName();
            if (visited.contains(candidateName)) continue;
            if (candidate.isReexported()) {
                result.add(candidateName);
            }
            this.collectReexportedResources(result, visited, candidateName);
        }
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this._ctx;
    }

    @Override
    public BackendTypesystem getTypesystem() {
        return this._ts;
    }

    @Override
    public FunctionDefContextInternal createEmptyFdc() {
        FunctionDefContextImpl result = new FunctionDefContextImpl();
        if (this._isInitializingSyslib) {
            return result;
        }
        this._isInitializingSyslib = true;
        try {
            String[] stringArray = SyslibContributor.getSysLibResources();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String resourceName = stringArray[n2];
                for (NamedFunction f : this.getFunctions(resourceName).getPublicFunctions()) {
                    result.register(f, true);
                }
                ++n2;
            }
            FunctionDefContextImpl functionDefContextImpl = result;
            return functionDefContextImpl;
        }
        finally {
            this._isInitializingSyslib = false;
        }
    }
}

