/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.builders.runner.CreateRunnableAcceleoOperation;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.parser.AcceleoParser;
import org.eclipse.acceleo.parser.AcceleoParserProblem;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class AcceleoCompileOperation
implements IWorkspaceRunnable {
    private IProject project;
    private IFile[] files;
    private boolean isClean;

    public AcceleoCompileOperation(IProject project, IFile[] files, boolean isClean) throws CoreException {
        this.project = project;
        this.files = files;
        this.isClean = isClean;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(AcceleoUIMessages.getString("AcceleoCompileOperation.Task.Compile"), this.files.length);
        AcceleoProject acceleoProject = new AcceleoProject(this.project);
        int i = 0;
        while (i < this.files.length) {
            IFile outputFile;
            monitor.subTask(AcceleoUIMessages.getString("AcceleoCompileOperation.Task.Clean", this.files[0].getFullPath().toString()));
            this.files[i].deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            IPath outputPath = acceleoProject.getOutputFilePath(this.files[i]);
            if (outputPath != null && (outputFile = this.project.getFile(outputPath.removeFirstSegments(1))) != null && outputFile.exists()) {
                outputFile.delete(true, monitor);
            }
            ++i;
        }
        if (!this.isClean) {
            this.doCompileResources(monitor);
        }
        monitor.done();
    }

    private void doCompileResources(IProgressMonitor monitor) throws CoreException {
        IFile workspaceFile;
        ArrayList<String> conflicts = new ArrayList<String>();
        AcceleoProject acceleoProject = new AcceleoProject(this.project);
        List<URI> dependenciesURIs = acceleoProject.getAccessibleOutputFiles();
        for (URI uri : dependenciesURIs) {
            conflicts.add(new Path(uri.toString()).removeFileExtension().addFileExtension("mtl").lastSegment());
        }
        AcceleoParser parser = new AcceleoParser();
        ArrayList<File> iFiles = new ArrayList<File>();
        ArrayList<URI> oURIs = new ArrayList<URI>();
        int i = 0;
        while (i < this.files.length) {
            if (acceleoProject.getOutputFilePath(this.files[i]) != null) {
                if (conflicts.contains(this.files[i].getName())) {
                    this.reportError(this.files[i], 0, 0, 0, AcceleoUIMessages.getString("AcceleoCompileOperation.NameConflict", this.files[i].getName()));
                } else {
                    conflicts.add(this.files[i].getName());
                }
                IPath outputPath = acceleoProject.getOutputFilePath(this.files[i]);
                if (outputPath != null) {
                    iFiles.add(this.files[i].getLocation().toFile());
                    oURIs.add(URI.createPlatformResourceURI((String)outputPath.toString(), (boolean)false));
                }
            }
            ++i;
        }
        parser.parse(iFiles, oURIs, dependenciesURIs);
        for (File iFile : iFiles) {
            AcceleoParserProblems problems = parser.getProblems(iFile);
            if (problems == null || (workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(iFile.getAbsolutePath()))) == null || !workspaceFile.isAccessible()) continue;
            List list = problems.getList();
            for (AcceleoParserProblem problem : list) {
                this.reportError(workspaceFile, problem.getLine(), problem.getPosBegin(), problem.getPosEnd(), problem.getMessage());
            }
        }
        ArrayList<IFile> filesWithMainTag = new ArrayList<IFile>();
        for (File iFile : iFiles) {
            workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(iFile.getAbsolutePath()));
            if (workspaceFile == null || !workspaceFile.isAccessible() || !this.hasMainTag(workspaceFile)) continue;
            filesWithMainTag.add(workspaceFile);
        }
        CreateRunnableAcceleoOperation createRunnableAcceleoOperation = new CreateRunnableAcceleoOperation(acceleoProject, filesWithMainTag);
        createRunnableAcceleoOperation.run(monitor);
    }

    private boolean hasMainTag(IFile file) {
        Sequence pattern = new Sequence("@main");
        try {
            InputStream inputStream = file.getContents();
            int available = inputStream.available();
            byte[] bytes = new byte[available];
            inputStream.read(bytes);
            StringBuffer contents = FileContent.getFileContent((File)file.getLocation().toFile());
            if (pattern.search(contents).b() > -1) {
                return true;
            }
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
        catch (IOException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
        return false;
    }

    private void reportError(IFile file, int line, int posBegin, int posEnd, String message) throws CoreException {
        IMarker m = file.createMarker("org.eclipse.acceleo.ide.ui.problem");
        m.setAttribute("lineNumber", line);
        m.setAttribute("charStart", posBegin);
        m.setAttribute("charEnd", posEnd);
        m.setAttribute("message", (Object)message);
        m.setAttribute("priority", 2);
        m.setAttribute("severity", 2);
    }
}

