/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;

abstract class WriteCommand
extends AbstractTransactionalCommand
implements ICompositeOperation {
    private final CompositeTransactionalCommand compositeDelegate;
    private final Runnable runnable;
    private final IOperationHistory history;

    public WriteCommand(TransactionalEditingDomain domain, String label, IOperationHistory history, Runnable runnable) {
        super(domain, label, null);
        this.compositeDelegate = new CompositeTransactionalCommand(domain, label);
        this.runnable = runnable;
        this.history = history;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.runnable != null) {
            this.history.openOperation((ICompositeOperation)this, 1);
            try {
                this.runnable.run();
                this.history.closeOperation(this.getStatus().isOK(), false, 1);
            }
            catch (RuntimeException e) {
                this.history.closeOperation(false, false, 1);
                throw e;
            }
        }
        return this.computeResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.compositeDelegate.redo(progressMonitor, info);
        return this.compositeDelegate.getCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.compositeDelegate.undo(progressMonitor, info);
        return this.compositeDelegate.getCommandResult();
    }

    public void add(IUndoableOperation operation) {
        this.compositeDelegate.add(operation);
        this.refreshContexts();
    }

    public void remove(IUndoableOperation operation) {
        this.compositeDelegate.remove(operation);
        this.refreshContexts();
    }

    private void refreshContexts() {
        IUndoContext[] currentContexts = this.getContexts();
        int i = 0;
        while (i < currentContexts.length) {
            if (!this.compositeDelegate.hasContext(currentContexts[i])) {
                this.removeContext(currentContexts[i]);
            }
            ++i;
        }
        IUndoContext[] newContexts = this.compositeDelegate.getContexts();
        int i2 = 0;
        while (i2 < newContexts.length) {
            if (!this.hasContext(newContexts[i2])) {
                this.addContext(newContexts[i2]);
            }
            ++i2;
        }
    }

    public List getAffectedFiles() {
        return this.compositeDelegate.getAffectedFiles();
    }

    private CommandResult computeResult() {
        if (this.compositeDelegate.size() == 0) {
            return null;
        }
        if (this.compositeDelegate.size() == 1) {
            IUndoableOperation operation = (IUndoableOperation)this.compositeDelegate.iterator().next();
            if (operation instanceof ICommand) {
                return ((ICommand)operation).getCommandResult();
            }
            return new CommandResult(Status.OK_STATUS);
        }
        IStatus worst = Status.OK_STATUS;
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        ArrayList<Object> returnValues = new ArrayList<Object>();
        for (IUndoableOperation operation : this.compositeDelegate) {
            ICommand command;
            CommandResult result;
            if (!(operation instanceof ICommand) || (result = (command = (ICommand)operation).getCommandResult()) == null) continue;
            IStatus nextStatus = result.getStatus();
            if (nextStatus.getSeverity() > worst.getSeverity()) {
                worst = nextStatus;
            }
            statuses.add(nextStatus);
            Object nextValue = result.getReturnValue();
            if (nextValue == null) continue;
            if (((Object)((Object)this)).getClass().isInstance(command)) {
                if (nextValue != null && nextValue instanceof Collection) {
                    returnValues.addAll((Collection)nextValue);
                    continue;
                }
                returnValues.add(nextValue);
                continue;
            }
            returnValues.add(nextValue);
        }
        MultiStatus status = new MultiStatus(worst.getPlugin(), worst.getCode(), statuses.toArray(new IStatus[statuses.size()]), worst.getMessage(), null);
        return new CommandResult((IStatus)status, returnValues);
    }

    public abstract IStatus getStatus();
}

