/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.ActionManagerChangeEvent;
import org.eclipse.gmf.runtime.common.ui.action.IActionManagerChangeListener;
import org.eclipse.gmf.runtime.common.ui.action.IActionWithProgress;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;

public class ActionManager {
    protected static final String EMPTY_STRING = "";
    protected static final String SPACE = " ";
    private static ActionManager actionManager = null;
    private final IOperationHistory operationHistory;
    private IActionWithProgress action = null;
    private final List listeners = Collections.synchronizedList(new ArrayList());

    public ActionManager(IOperationHistory operationHistory) {
        assert (operationHistory != null);
        this.operationHistory = operationHistory;
    }

    public static ActionManager getDefault() {
        if (actionManager == null) {
            actionManager = new ActionManager(OperationHistoryFactory.getOperationHistory());
        }
        return actionManager;
    }

    public final IOperationHistory getOperationHistory() {
        return this.operationHistory;
    }

    protected final IActionWithProgress getAction() {
        return this.action;
    }

    protected final void setAction(IActionWithProgress action) {
        this.action = action;
    }

    protected final List getListeners() {
        return this.listeners;
    }

    public void addActionManagerChangeListener(IActionManagerChangeListener listener) {
        assert (listener != null);
        this.getListeners().add(listener);
    }

    public void removeActionManagerChangeListener(IActionManagerChangeListener listener) {
        assert (listener != null);
        this.getListeners().remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireActionManagerChange(ActionManagerChangeEvent event) {
        assert (event != null);
        ArrayList targets = null;
        List list = this.getListeners();
        synchronized (list) {
            targets = new ArrayList(this.getListeners());
        }
        Iterator i = targets.iterator();
        while (i.hasNext()) {
            ((IActionManagerChangeListener)i.next()).actionManagerChanged(event);
        }
    }

    public void clear() {
        this.setAction(null);
        this.fireActionManagerChange(new ActionManagerChangeEvent(this));
    }

    public void run(final IActionWithProgress theAction) {
        if (!theAction.isRunnable()) {
            UnsupportedOperationException uoe = new UnsupportedOperationException();
            Trace.throwing((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_THROWING, this.getClass(), (String)"run", (Throwable)uoe);
            throw uoe;
        }
        boolean setup = theAction.setup();
        if (!setup) {
            return;
        }
        IActionWithProgress.WorkIndicatorType type = theAction.getWorkIndicatorType();
        if (type == IActionWithProgress.WorkIndicatorType.PROGRESS_MONITOR) {
            this.runActionInProgressMonitorDialog(theAction, false);
        } else if (type == IActionWithProgress.WorkIndicatorType.CANCELABLE_PROGRESS_MONITOR) {
            this.runActionInProgressMonitorDialog(theAction, true);
        } else if (type == IActionWithProgress.WorkIndicatorType.BUSY) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    theAction.run((IProgressMonitor)new NullProgressMonitor());
                }
            });
        } else {
            theAction.run((IProgressMonitor)new NullProgressMonitor());
        }
        this.setAction(theAction);
        this.fireActionManagerChange(new ActionManagerChangeEvent(this, theAction));
        Trace.trace((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.ACTIONS_RUN, (String)("Action '" + String.valueOf(this.getAction()) + "' run."));
    }

    private void runInProgressMonitorDialog(IRunnableWithProgress runnable, boolean cancelable) {
        try {
            if (System.getProperty("RUN_PROGRESS_IN_UI_HACK") != null) {
                new ProgressMonitorDialog(null).run(false, cancelable, runnable);
            } else {
                new ProgressMonitorDialog(null).run(true, cancelable, runnable);
            }
        }
        catch (InvocationTargetException ite) {
            Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"run", (Throwable)ite);
            Log.error((Plugin)CommonUIPlugin.getDefault(), (int)4, (String)"run", (Throwable)ite);
            RuntimeException cre = new RuntimeException(ite.getTargetException());
            Trace.throwing((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_THROWING, this.getClass(), (String)"run", (Throwable)cre);
            throw cre;
        }
        catch (InterruptedException ie) {
            Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"run", (Throwable)ie);
        }
    }

    private void runActionInProgressMonitorDialog(final IActionWithProgress act, boolean cancelable) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                act.run(monitor);
            }
        };
        this.runInProgressMonitorDialog(runnable, cancelable);
    }
}

