/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContainer;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRoot;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.gmf.internal.bridge.genmodel.BasicDiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramGenModelTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediator;
import org.eclipse.gmf.mappings.AuditContainer;
import org.eclipse.gmf.mappings.AuditRule;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.Severity;

public class AuditRootTest
extends TestCase {
    private AuditContainer topCat;
    private GenAuditRoot genRoot;

    protected void setUp() throws Exception {
        super.setUp();
        this.topCat = AuditRootTest.createAuditContainer("ac1");
        AuditContainer containerChild1 = AuditRootTest.createAuditContainer("ac2");
        containerChild1.setParentContainer(this.topCat);
        AuditContainer containerChild1bis = AuditRootTest.createAuditContainer("ac2-bis");
        containerChild1bis.setParentContainer(this.topCat);
        AuditContainer containerChild2 = AuditRootTest.createAuditContainer("ac3");
        containerChild2.setParentContainer(containerChild1);
        this.topCat.getAudits().add((Object)AuditRootTest.createAuditRule("r1"));
        containerChild1.getAudits().add((Object)AuditRootTest.createAuditRule("r2"));
        containerChild2.getAudits().add((Object)AuditRootTest.createAuditRule("r3"));
        containerChild1bis.getAudits().add((Object)AuditRootTest.createAuditRule("r4"));
        class DiagramGenModelTransformerX
        extends DiagramGenModelTransformer {
            DiagramGenModelTransformerX() {
                super((DiagramRunTimeModelHelper)new BasicDiagramRunTimeModelHelper(), (GenModelNamingMediator)new GenModelNamingMediator.Empty());
            }

            public GenAuditRoot go(AuditContainer audits) {
                super.process(audits);
                return this.getResult().getAudits();
            }
        }
        this.genRoot = new DiagramGenModelTransformerX().go(this.topCat);
        AuditRootTest.assertNotNull((Object)this.genRoot);
    }

    private static AuditContainer createAuditContainer(String id) {
        AuditContainer container = GMFMapFactory.eINSTANCE.createAuditContainer();
        container.setId(id);
        container.setName("Name of \"" + id + "\"");
        container.setDescription("Description of \"" + id + "\"");
        return container;
    }

    private static AuditRule createAuditRule(String token) {
        AuditRule r = GMFMapFactory.eINSTANCE.createAuditRule();
        r.setId(token);
        r.setMessage("Message for " + token);
        r.setDescription("Description for " + token);
        r.setSeverity(Severity.get((int)(token.hashCode() % 3)));
        r.setUseInLiveMode(token.hashCode() % 2 == 0);
        return r;
    }

    public void testStructure() {
        AuditRootTest.assertEquals((int)4, (int)this.genRoot.getCategories().size());
        AuditRootTest.assertEquals((int)4, (int)this.genRoot.getRules().size());
        HashSet c = new HashSet(this.genRoot.getCategories());
        for (GenAuditRule r : this.genRoot.getRules()) {
            AuditRootTest.assertNotNull((Object)r.getCategory());
            AuditRootTest.assertTrue((String)"each rule belongs to sole category", (boolean)c.remove(r.getCategory()));
            AuditRootTest.assertEquals((Object)this.genRoot, (Object)r.getCategory().getRoot());
            AuditRootTest.assertEquals((Object)this.genRoot, (Object)r.getRoot());
        }
    }

    public void testPath() {
        GenAuditContainer c1 = this.findGenCategory(this.topCat);
        AuditRootTest.assertEquals((int)1, (int)c1.getPath().size());
        AuditRootTest.assertEquals((Object)c1, (Object)c1.getPath().get(0));
        AuditContainer ac2 = (AuditContainer)this.topCat.getChildContainers().get(0);
        GenAuditContainer c2 = this.findGenCategory(ac2);
        AuditRootTest.assertEquals((int)2, (int)c2.getPath().size());
        AuditRootTest.assertEquals((Object)c1, (Object)c2.getPath().get(0));
        AuditRootTest.assertEquals((Object)c2, (Object)c2.getPath().get(1));
        GenAuditContainer c2bis = this.findGenCategory((AuditContainer)this.topCat.getChildContainers().get(1));
        AuditRootTest.assertEquals((int)2, (int)c2bis.getPath().size());
        AuditRootTest.assertEquals((Object)c1, (Object)c2bis.getPath().get(0));
        AuditRootTest.assertEquals((Object)c2bis, (Object)c2bis.getPath().get(1));
        GenAuditContainer c3 = this.findGenCategory((AuditContainer)ac2.getChildContainers().get(0));
        AuditRootTest.assertEquals((int)3, (int)c3.getPath().size());
        AuditRootTest.assertEquals((Object)c1, (Object)c3.getPath().get(0));
        AuditRootTest.assertEquals((Object)c2, (Object)c3.getPath().get(1));
        AuditRootTest.assertEquals((Object)c3, (Object)c3.getPath().get(2));
    }

    public void testCategoryAttributes() {
        AuditContainer ci = (AuditContainer)this.topCat.getChildContainers().get(1);
        GenAuditContainer co = this.findGenCategory(ci);
        AuditRootTest.assertNotNull((Object)co);
        AuditRootTest.assertEquals((String)ci.getDescription(), (String)co.getDescription());
        AuditRootTest.assertEquals((String)ci.getName(), (String)co.getName());
    }

    public void testRuleAttributes() {
        AuditRule ri = (AuditRule)((AuditContainer)this.topCat.getChildContainers().get(1)).getAudits().get(0);
        GenAuditRule ro = this.findGenRule(ri);
        AuditRootTest.assertNotNull((Object)ro);
        AuditRootTest.assertEquals((String)ri.getName(), (String)ro.getName());
        AuditRootTest.assertEquals((String)ri.getDescription(), (String)ro.getDescription());
        AuditRootTest.assertEquals((String)ri.getMessage(), (String)ro.getMessage());
        AuditRootTest.assertEquals((boolean)ri.isUseInLiveMode(), (boolean)ro.isUseInLiveMode());
        AuditRootTest.assertEquals((String)ri.getSeverity().getLiteral(), (String)ro.getSeverity().getLiteral());
        AuditRootTest.assertEquals((String)ri.getContainer().getId(), (String)ro.getCategory().getId());
    }

    private GenAuditContainer findGenCategory(AuditContainer ac) {
        for (Object o : this.genRoot.getCategories()) {
            if (!ac.getId().equals(((GenAuditContainer)o).getId())) continue;
            return (GenAuditContainer)o;
        }
        return null;
    }

    private GenAuditRule findGenRule(AuditRule r) {
        for (Object o : this.genRoot.getRules()) {
            if (!r.getId().equals(((GenAuditRule)o).getId())) continue;
            return (GenAuditRule)o;
        }
        return null;
    }
}

