/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.internal.editpolicies;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.BendpointLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.BendpointMoveHandle;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.FeedbackConnection;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouterUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.LineMode;
import org.eclipse.gmf.runtime.gef.ui.internal.handles.BendpointCreationInvisibleHandle;
import org.eclipse.gmf.runtime.gef.ui.internal.handles.LineSegMoveInvisibleHandle;
import org.eclipse.jface.util.Assert;

public abstract class ConnectionBendpointEditPolicy
extends SelectionHandlesEditPolicy
implements PropertyChangeListener {
    private static List NULL_CONSTRAINT = new ArrayList();
    private static final int STICKY_TOLERANCE_DP = 6;
    private LineMode lineSegMode = LineMode.OBLIQUE;
    private FeedbackState feedbackState = null;
    static /* synthetic */ Class class$0;

    private FeedbackState getFeedbackState() {
        if (this.feedbackState == null) {
            this.feedbackState = new FeedbackState();
        }
        return this.feedbackState;
    }

    private boolean useRealtimeFeedback() {
        return false;
    }

    public ConnectionBendpointEditPolicy(LineMode lineSegMode) {
        this.lineSegMode = lineSegMode;
    }

    public LineMode getLineSegMode() {
        return this.lineSegMode;
    }

    public void activate() {
        super.activate();
        this.getConnection().addPropertyChangeListener("points", (PropertyChangeListener)this);
    }

    protected Connection createDragSourceFeedbackConnection() {
        if (this.useRealtimeFeedback()) {
            return this.getConnection();
        }
        FeedbackConnection r = new FeedbackConnection(this.getConnection());
        this.addFeedback((IFigure)r);
        return r;
    }

    protected void addSelectionHandles() {
        if (this.handles == null) {
            super.addSelectionHandles();
        } else {
            int points;
            int count = this.handles.size();
            if (count != (points = this.getConnection().getPoints().size()) * 2 - 3) {
                super.addSelectionHandles();
            }
        }
    }

    protected List createManualHandles() {
        ArrayList<BendpointMoveHandle> list = new ArrayList<BendpointMoveHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        int i = 1;
        while (i < points.size() - 1) {
            this.addInvisibleCreationHandle(list, connEP, i - 1);
            list.add(new BendpointMoveHandle(connEP, i, (Locator)new BendpointLocator(this.getConnection(), i)));
            ++i;
        }
        this.addInvisibleCreationHandle(list, connEP, points.size() - 2);
        return list;
    }

    protected void addInvisibleCreationHandle(List list, ConnectionEditPart connEP, int i) {
        if (this.getLineSegMode() != LineMode.OBLIQUE) {
            list.add(new LineSegMoveInvisibleHandle(connEP, i));
        } else {
            list.add(new BendpointCreationInvisibleHandle(connEP, i));
        }
    }

    protected List createSelectionHandles() {
        List list = new ArrayList();
        list = this.createManualHandles();
        return list;
    }

    public void deactivate() {
        this.getConnection().removePropertyChangeListener("points", (PropertyChangeListener)this);
        super.deactivate();
    }

    protected void eraseConnectionFeedback(BendpointRequest request, boolean removeFeedbackFigure) {
        this.restoreOriginalConstraint();
        this.getFeedbackState().originalConstraint = null;
        if (removeFeedbackFigure) {
            this.feedbackState = null;
        }
    }

    public void eraseSourceFeedback(Request request) {
        if ("move bendpoint".equals(request.getType()) || "create bendpoint".equals(request.getType())) {
            this.eraseConnectionFeedback((BendpointRequest)request, true);
        }
    }

    public Command getCommand(Request request) {
        if ("move bendpoint".equals(request.getType())) {
            if (this.getLineSegMode() != LineMode.OBLIQUE) {
                return this.getMoveLineSegCommand((BendpointRequest)request);
            }
            if (this.getFeedbackState().isDeleting) {
                return this.getDeleteBendpointCommand((BendpointRequest)request);
            }
            return this.getMoveBendpointCommand((BendpointRequest)request);
        }
        if ("create bendpoint".equals(request.getType())) {
            return this.getCreateBendpointCommand((BendpointRequest)request);
        }
        return null;
    }

    protected Connection getConnection() {
        return (Connection)((ConnectionEditPart)this.getHost()).getFigure();
    }

    private Point getFirstReferencePoint() {
        return this.getFeedbackState().ref1;
    }

    private Point getSecondReferencePoint() {
        return this.getFeedbackState().ref2;
    }

    private boolean lineContainsPoint(Point p1, Point p2, Point p) {
        LineSeg line = new LineSeg(p1, p2);
        return line.containsPoint(p, this.getStickyTolerance() / 3);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getHost().getSelected() != 0) {
            this.addSelectionHandles();
        }
    }

    protected void restoreOriginalConstraint() {
        if (this.getFeedbackState().originalConstraint != null) {
            Assert.isTrue((this.getFeedbackState().originalConstraint.size() >= 2 ? 1 : 0) != 0);
            this.getConnection().setRoutingConstraint((Object)this.getFeedbackState().originalConstraint);
        }
    }

    protected void saveOriginalConstraint() {
        this.getFeedbackState().originalConstraint = (List)this.getConnection().getRoutingConstraint();
        if (this.getFeedbackState().originalConstraint == null) {
            this.getFeedbackState().originalConstraint = NULL_CONSTRAINT;
        }
        if (this.getLineSegMode() != LineMode.OBLIQUE && !this.getFeedbackState().init) {
            ArrayList<AbsoluteBendpoint> newConstraint = new ArrayList<AbsoluteBendpoint>(this.getFeedbackState().originalConstraint.size());
            PointList pts = PointListUtilities.copyPoints((PointList)this.getConnection().getPoints());
            OrthogonalRouterUtilities.resetEndPointsToCenter((Connection)this.getConnection(), (PointList)pts);
            int i = 0;
            while (i < pts.size()) {
                AbsoluteBendpoint abp = new AbsoluteBendpoint(pts.getPoint(i));
                newConstraint.add(abp);
                ++i;
            }
            Assert.isTrue((this.getFeedbackState().originalConstraint.size() >= 2 ? 1 : 0) != 0);
            this.getConnection().setRoutingConstraint(newConstraint);
            this.getFeedbackState().isOutsideSource = false;
            this.getFeedbackState().isOutsideTarget = false;
        } else {
            int nConstraintSize = this.getFeedbackState().originalConstraint.size();
            PointList pts = this.getConnection().getPoints();
            int nPointSize = pts.size();
            if (!this.getFeedbackState().init && nConstraintSize != nPointSize) {
                while (this.getFeedbackState().originalConstraint.size() > 0) {
                    this.getFeedbackState().originalConstraint.remove(0);
                }
                int i = 0;
                while (i < pts.size()) {
                    AbsoluteBendpoint bpNew = new AbsoluteBendpoint(pts.getPoint(i));
                    this.getFeedbackState().originalConstraint.add(i, bpNew);
                    ++i;
                }
            }
            Assert.isTrue((this.getFeedbackState().originalConstraint.size() >= 2 ? 1 : 0) != 0);
            this.getConnection().setRoutingConstraint(new ArrayList(this.getFeedbackState().originalConstraint));
        }
        this.getFeedbackState().init = true;
    }

    private void setReferencePoints(BendpointRequest request) {
        if (this.getFeedbackState().originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        List constraint = (List)this.getConnection().getRoutingConstraint();
        Bendpoint bp = (Bendpoint)constraint.get(Math.max(0, request.getIndex() - 1));
        this.getFeedbackState().ref1 = bp.getLocation();
        bp = (Bendpoint)constraint.get(Math.min(request.getIndex() + 1, constraint.size() - 1));
        this.getFeedbackState().ref2 = bp.getLocation();
    }

    private void setNewFeedbackConstraint(List constraint) {
        Assert.isTrue((constraint.size() >= 2 ? 1 : 0) != 0);
        this.getConnection().setRoutingConstraint((Object)constraint);
    }

    protected void showCreateBendpointFeedback(BendpointRequest request) {
        List constraint;
        Point p = new Point(request.getLocation());
        this.getConnection().translateToRelative((Translatable)p);
        AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
        if (this.getFeedbackState().originalConstraint == null) {
            this.saveOriginalConstraint();
            constraint = (List)this.getConnection().getRoutingConstraint();
            constraint.add(request.getIndex() + 1, bp);
        } else {
            constraint = (List)this.getConnection().getRoutingConstraint();
        }
        this.stickyStraightLineFeedback(constraint, request.getIndex() + 1, (Bendpoint)bp);
        this.setNewFeedbackConstraint(constraint);
    }

    protected void showDeleteBendpointFeedback(BendpointRequest request) {
        if (this.getFeedbackState().originalConstraint == null) {
            this.saveOriginalConstraint();
            List constraint = (List)this.getConnection().getRoutingConstraint();
            constraint.remove(request.getIndex());
            this.setNewFeedbackConstraint(constraint);
        }
    }

    protected void showMoveBendpointFeedback(BendpointRequest request) {
        Point p = new Point(request.getLocation());
        if (!this.getFeedbackState().isDeleting) {
            this.setReferencePoints(request);
        }
        this.getConnection().translateToRelative((Translatable)p);
        AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
        if (this.getFeedbackState().originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        if (this.lineContainsPoint(this.getFirstReferencePoint(), this.getSecondReferencePoint(), p)) {
            if (!this.getFeedbackState().isDeleting) {
                this.getFeedbackState().isDeleting = true;
                this.eraseConnectionFeedback(request, false);
                this.showDeleteBendpointFeedback(request);
            }
            return;
        }
        if (this.getFeedbackState().isDeleting) {
            this.getFeedbackState().isDeleting = false;
            this.eraseConnectionFeedback(request, false);
        }
        List constraint = (List)this.getConnection().getRoutingConstraint();
        this.stickyStraightLineFeedback(constraint, request.getIndex(), (Bendpoint)bp);
        this.setNewFeedbackConstraint(constraint);
    }

    protected void stickyStraightLineFeedback(List constraint, int nIndex, Bendpoint bp) {
        Point ptLoc = new Point(bp.getLocation());
        int sticky_tolerance = this.getStickyTolerance();
        if (nIndex > 0) {
            Point ptPrev;
            if (nIndex - 1 == 0) {
                ptPrev = this.getConnection().getSourceAnchor().getReferencePoint();
                this.getConnection().translateToRelative((Translatable)ptPrev);
            } else {
                ptPrev = ((Bendpoint)constraint.get(nIndex - 1)).getLocation();
            }
            if (Math.abs(ptPrev.x - ptLoc.x) < sticky_tolerance) {
                ptLoc.x = ptPrev.x;
            }
            if (Math.abs(ptPrev.y - ptLoc.y) < sticky_tolerance) {
                ptLoc.y = ptPrev.y;
            }
        }
        if (nIndex < constraint.size() - 1) {
            Point ptNext;
            if (nIndex + 1 == constraint.size() - 1) {
                ptNext = this.getConnection().getTargetAnchor().getReferencePoint();
                this.getConnection().translateToRelative((Translatable)ptNext);
            } else {
                ptNext = ((Bendpoint)constraint.get(nIndex + 1)).getLocation();
            }
            if (Math.abs(ptNext.x - ptLoc.x) < sticky_tolerance) {
                ptLoc.x = ptNext.x;
            }
            if (Math.abs(ptNext.y - ptLoc.y) < sticky_tolerance) {
                ptLoc.y = ptNext.y;
            }
        }
        if (!ptLoc.equals((Object)bp.getLocation())) {
            AbsoluteBendpoint bpNew = new AbsoluteBendpoint(ptLoc);
            constraint.set(nIndex, bpNew);
        } else {
            constraint.set(nIndex, bp);
        }
    }

    private int getStickyTolerance() {
        int sticky_tolerance = MapModeUtil.getMapMode((IFigure)this.getConnection()).DPtoLP(6);
        return sticky_tolerance;
    }

    public void showSourceFeedback(Request request) {
        if (this.getLineSegMode() != LineMode.OBLIQUE) {
            if ("create bendpoint".equals(request.getType()) || "move bendpoint".equals(request.getType())) {
                this.showMoveLineSegFeedback((BendpointRequest)request);
            }
        } else if ("move bendpoint".equals(request.getType())) {
            this.showMoveBendpointFeedback((BendpointRequest)request);
        } else if ("create bendpoint".equals(request.getType())) {
            this.showCreateBendpointFeedback((BendpointRequest)request);
        }
        super.showSourceFeedback(request);
    }

    protected abstract Command getBendpointsChangedCommand(BendpointRequest var1);

    protected Command getCreateBendpointCommand(BendpointRequest request) {
        return this.getBendpointsChangedCommand(request);
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        return this.getBendpointsChangedCommand(request);
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        return this.getBendpointsChangedCommand(request);
    }

    protected final LineSeg getLineSeg(List bendPoints, int nIndex) {
        Point pt1 = new Point(((Bendpoint)bendPoints.get(nIndex - 1)).getLocation());
        Point pt2 = new Point(((Bendpoint)bendPoints.get(nIndex)).getLocation());
        return new LineSeg(pt1, pt2);
    }

    protected void setLineSeg(List bendPoints, int nIndex, LineSeg newLine) {
        AbsoluteBendpoint bp1 = new AbsoluteBendpoint(newLine.getOrigin());
        AbsoluteBendpoint bp2 = new AbsoluteBendpoint(newLine.getTerminus());
        bendPoints.set(nIndex - 1, bp1);
        bendPoints.set(nIndex, bp2);
    }

    protected Command getMoveLineSegCommand(BendpointRequest request) {
        return this.getBendpointsChangedCommand(request);
    }

    protected boolean lineOutsideSource(LineSeg line) {
        Rectangle startRect = new Rectangle(this.getConnection().getSourceAnchor().getOwner().getBounds());
        this.getConnection().getSourceAnchor().getOwner().translateToAbsolute((Translatable)startRect);
        this.getConnection().translateToRelative((Translatable)startRect);
        if (this.getLineSegMode().equals((Object)LineMode.ORTHOGONAL_CONSTRAINED)) {
            startRect.expand(MapModeUtil.getMapMode((IFigure)this.getConnection()).DPtoLP(-2), MapModeUtil.getMapMode((IFigure)this.getConnection()).DPtoLP(-2));
        }
        return !startRect.contains(line.getOrigin());
    }

    protected boolean lineOutsideTarget(LineSeg line) {
        Rectangle endRect = new Rectangle(this.getConnection().getTargetAnchor().getOwner().getBounds());
        this.getConnection().getTargetAnchor().getOwner().translateToAbsolute((Translatable)endRect);
        this.getConnection().translateToRelative((Translatable)endRect);
        if (this.getLineSegMode().equals((Object)LineMode.ORTHOGONAL_CONSTRAINED)) {
            endRect.expand(MapModeUtil.getMapMode((IFigure)this.getConnection()).DPtoLP(-2), MapModeUtil.getMapMode((IFigure)this.getConnection()).DPtoLP(-2));
        }
        return !endRect.contains(line.getTerminus());
    }

    protected void removeOutsideSourceFeedback(List constraint) {
        constraint.remove(0);
    }

    protected void removeOutsideTargetFeedback(List constraint) {
        constraint.remove(constraint.size() - 1);
    }

    protected void showOutsideSourceFeedback(List constraint) {
        Point ptAdd = ((Bendpoint)constraint.get(0)).getLocation();
        AbsoluteBendpoint bp = new AbsoluteBendpoint(ptAdd);
        constraint.add(0, bp);
    }

    protected void showOutsideTargetFeedback(List constraint) {
        Point ptAdd = ((Bendpoint)constraint.get(constraint.size() - 1)).getLocation();
        AbsoluteBendpoint bp = new AbsoluteBendpoint(ptAdd);
        constraint.add(constraint.size() - 1, bp);
    }

    protected void showMoveLineSegFeedback(BendpointRequest request) {
        if (this.getFeedbackState().originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        Point ptLoc = new Point(request.getLocation());
        List constraint = (List)this.getConnection().getRoutingConstraint();
        this.getConnection().translateToRelative((Translatable)ptLoc);
        int index = this.getFeedbackState().isOutsideSource ? request.getIndex() + 1 : request.getIndex();
        LineSeg moveLine = this.getLineSeg(constraint, index + 1);
        LineSeg newLine = moveLine.getParallelLineSegThroughPoint(ptLoc);
        if (!newLine.isHorizontal() && !newLine.isVertical()) {
            if (Math.abs(newLine.getOrigin().x - newLine.getTerminus().x) < Math.abs(newLine.getOrigin().y - newLine.getTerminus().y)) {
                newLine.setTerminus(new Point(newLine.getOrigin().x, newLine.getTerminus().y));
            } else {
                newLine.setTerminus(new Point(newLine.getTerminus().x, newLine.getOrigin().y));
            }
        }
        index = this.adjustOutsideBoundsLineFeedback(request, constraint, index, newLine);
        this.setLineSeg(constraint, index + 1, newLine);
        this.getConnection().setRoutingConstraint((Object)constraint);
    }

    protected int adjustOutsideBoundsLineFeedback(BendpointRequest request, List constraint, int index, LineSeg newLine) {
        int checkTargetIndex;
        if (this.getLineSegMode().equals((Object)LineMode.ORTHOGONAL_CONSTRAINED)) {
            if (index == 0 && this.lineOutsideSource(newLine) || index + 1 == constraint.size() - 1 && this.lineOutsideTarget(newLine)) {
                LineSeg moveLine = this.getLineSeg(constraint, index + 1);
                newLine.setOrigin(moveLine.getOrigin());
                newLine.setTerminus(moveLine.getTerminus());
            }
            return index;
        }
        boolean bRemoveSource = false;
        boolean bRemoveTarget = false;
        boolean bSetNewSource = false;
        boolean bSetNewTarget = false;
        if (request.getIndex() == 0 && this.lineOutsideSource(newLine)) {
            if (!this.getFeedbackState().isOutsideSource) {
                this.getFeedbackState().isOutsideSource = true;
                bSetNewSource = true;
            }
        } else if (this.getFeedbackState().isOutsideSource) {
            this.getFeedbackState().isOutsideSource = false;
            bRemoveSource = true;
        }
        if ((checkTargetIndex = index + 1 + (this.getFeedbackState().isOutsideTarget ? 1 : 0)) == constraint.size() - 1 && this.lineOutsideTarget(newLine)) {
            if (!this.getFeedbackState().isOutsideTarget) {
                this.getFeedbackState().isOutsideTarget = true;
                bSetNewTarget = true;
            }
        } else if (this.getFeedbackState().isOutsideTarget) {
            this.getFeedbackState().isOutsideTarget = false;
            bRemoveTarget = true;
        }
        if (bRemoveSource) {
            this.removeOutsideSourceFeedback(constraint);
            index = request.getIndex();
        }
        if (bRemoveTarget) {
            this.removeOutsideTargetFeedback(constraint);
        }
        if (bSetNewSource) {
            this.showOutsideSourceFeedback(constraint);
            index = request.getIndex() + 1;
        }
        if (bSetNewTarget) {
            this.showOutsideTargetFeedback(constraint);
        }
        return index;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.AccessibleHandleProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz && this.handles == null) {
            return null;
        }
        return super.getAdapter(key);
    }

    private static class FeedbackState {
        public List originalConstraint;
        public Point ref1 = new Point();
        public Point ref2 = new Point();
        public boolean isDeleting = false;
        public boolean isOutsideSource = false;
        public boolean isOutsideTarget = false;
        public boolean init = false;

        private FeedbackState() {
        }
    }
}

