/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.view.factories;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.view.factories.AbstractViewFactory;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;

public class BasicNodeViewFactory
extends AbstractViewFactory {
    private static final Map options = new HashMap();

    static {
        options.put("unprotected", Boolean.TRUE);
        options.put("silent", Boolean.TRUE);
        options.put("no_triggers", Boolean.TRUE);
    }

    public View createView(final IAdaptable semanticAdapter, final View containerView, final String semanticHint, final int index, boolean persisted, PreferencesHint preferencesHint) {
        EObject semanticEl;
        LayoutConstraint layoutConstraint;
        this.setPreferencesHint(preferencesHint);
        final Node node = this.createNode();
        List styles = this.createStyles((View)node);
        if (styles.size() > 0) {
            node.getStyles().addAll((Collection)styles);
        }
        if ((layoutConstraint = this.createLayoutConstraint()) != null) {
            node.setLayoutConstraint(layoutConstraint);
        }
        node.setType(semanticHint);
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        EObject eObject = semanticEl = semanticAdapter == null ? null : (EObject)semanticAdapter.getAdapter(EObject.class);
        if (semanticEl == null) {
            node.setElement(null);
        } else if (this.requiresElement(semanticAdapter, containerView)) {
            node.setElement(semanticEl);
        }
        TransactionalEditingDomain domain = this.getEditingDomain(semanticEl, containerView);
        if (domain != null) {
            if (BasicNodeViewFactory.isUnProtectedSilentTransactionInProgress(domain)) {
                this.decorateView(containerView, (View)node, semanticAdapter, semanticHint, index, true);
            } else {
                AbstractEMFOperation operation = new AbstractEMFOperation(domain, "", options){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        BasicNodeViewFactory.this.decorateView(containerView, (View)node, semanticAdapter, semanticHint, index, true);
                        return Status.OK_STATUS;
                    }
                };
                try {
                    operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"createView", (Throwable)e);
                    Log.warning((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"createView", (Throwable)e);
                }
            }
        }
        return node;
    }

    protected void decorateView(View containerView, View view, IAdaptable semanticAdapter, String semanticHint, int index, boolean persisted) {
        this.initializeFromPreferences(view);
    }

    protected LayoutConstraint createLayoutConstraint() {
        return null;
    }

    protected Node createNode() {
        return NotationFactory.eINSTANCE.createNode();
    }

    protected static boolean isUnProtectedSilentTransactionInProgress(TransactionalEditingDomain domain) {
        Object unprotectedMode;
        InternalTransactionalEditingDomain internalEditingDomain;
        InternalTransaction transaction;
        if (domain instanceof InternalTransactionalEditingDomain && (transaction = (internalEditingDomain = (InternalTransactionalEditingDomain)domain).getActiveTransaction()) != null && !transaction.isReadOnly() && Boolean.TRUE.equals(unprotectedMode = transaction.getOptions().get("unprotected"))) {
            Object noNotificationMode = transaction.getOptions().get("silent");
            Object noTriggersMode = transaction.getOptions().get("no_triggers");
            if (Boolean.TRUE.equals(noNotificationMode) && Boolean.TRUE.equals(noTriggersMode)) {
                return true;
            }
        }
        return false;
    }
}

