/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.migrate;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class FeatureKey {
    private String namespaceURI;
    private String className;
    private String featureName;

    public static FeatureKey create(EStructuralFeature feature) {
        FeatureKey pair = new FeatureKey();
        pair.setFeature(feature);
        return pair;
    }

    public void setFeature(EStructuralFeature feature) {
        EClass eClass = feature.getEContainingClass();
        this.className = eClass != null ? eClass.getName() : null;
        this.namespaceURI = eClass != null && eClass.getEPackage() != null ? eClass.getEPackage().getNsURI() : null;
        this.featureName = feature.getName();
    }

    public boolean equals(Object that) {
        FeatureKey another = (FeatureKey)that;
        return (this.className != null ? this.className.equals(another.className) : another.className == null) && (this.featureName != null ? this.featureName.equals(another.featureName) : another.featureName == null) && (this.namespaceURI != null ? this.namespaceURI.equals(another.namespaceURI) : another.namespaceURI == null);
    }

    public int hashCode() {
        return (this.className == null ? 0 : this.className.hashCode()) ^ (this.featureName == null ? 0 : this.featureName.hashCode()) ^ (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(this.namespaceURI).append(']').append(':');
        buf.append(this.className).append(':').append(this.featureName);
        return buf.toString();
    }
}

