/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.StringTokenizer;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;

public class WrapLabel
extends WrappingLabel {
    private String subStringText;

    public WrapLabel() {
    }

    public WrapLabel(String s) {
        super(s);
        this.setTextWrapAlignment(2);
    }

    public WrapLabel(Image i) {
        super(i);
        this.setTextWrapAlignment(2);
    }

    public WrapLabel(String s, Image i) {
        super(s, i);
        this.setTextWrapAlignment(2);
    }

    protected Dimension calculateSubStringTextSize() {
        Font f = this.getFont();
        return this.getTextExtents(this.getSubStringText(), f, this.getFigureMapMode().DPtoLP(FigureUtilities.getFontMetrics((Font)f).getHeight()));
    }

    protected Dimension calculateTextSize(int wHint, int hHint) {
        return this.getTextFlow().getPreferredSize(wHint, hHint);
    }

    public Rectangle getIconBounds() {
        if (this.hasIcons()) {
            Point safeIconLocation = this.getIconLocation() != null ? this.getIconLocation() : new Point(0, 0);
            return new Rectangle(this.getBounds().getLocation().translate(safeIconLocation), this.getTotalIconSize());
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public String getSubStringText() {
        if (this.subStringText != null) {
            return this.subStringText;
        }
        String theText = this.getText();
        int textLen = theText.length();
        if (textLen == 0) {
            this.subStringText = "";
            return "";
        }
        Dimension size = this.getSize();
        Dimension shrink = this.getPreferredSize(size.width, size.height).getDifference(size);
        Dimension effectiveSize = this.getTextSize().getExpanded(-shrink.width, -shrink.height);
        if (effectiveSize.height == 0) {
            this.subStringText = "";
            return "";
        }
        Font f = this.getFont();
        FontMetrics metrics = FigureUtilities.getFontMetrics((Font)f);
        IMapMode mm = this.getFigureMapMode();
        int fontHeight = mm.DPtoLP(metrics.getHeight());
        int charAverageWidth = mm.DPtoLP(metrics.getAverageCharWidth());
        int maxLines = (int)((double)effectiveSize.height / (double)fontHeight);
        if (maxLines == 0) {
            this.subStringText = "";
            return "";
        }
        StringBuffer accumlatedText = new StringBuffer();
        StringBuffer remainingText = new StringBuffer(theText);
        int effectiveSizeWidth = effectiveSize.width;
        int widthHint = Math.max(effectiveSizeWidth - this.getTruncationStringSize().width, 0);
        int i = 0;
        int j = 0;
        while (remainingText.length() > 0 && j++ < maxLines) {
            i = this.getLineWrapPosition(remainingText.toString(), f, effectiveSizeWidth, fontHeight);
            if (accumlatedText.length() > 0) {
                accumlatedText.append('\n');
            }
            if (i == 0 || remainingText.length() > i && j == maxLines) {
                i = this.getLargestSubstringConfinedTo(remainingText.toString(), f, widthHint, fontHeight, charAverageWidth);
                accumlatedText.append(remainingText.substring(0, i));
                accumlatedText.append(this.getEllipse());
            } else {
                accumlatedText.append(remainingText.substring(0, i));
            }
            remainingText.delete(0, i);
        }
        this.subStringText = accumlatedText.toString();
        return this.subStringText;
    }

    protected Dimension getSubStringTextSize() {
        return this.calculateSubStringTextSize();
    }

    protected Point getTextLocation() {
        return this.getTextBounds().getLocation();
    }

    protected Dimension getTextSize(int wHint, int hHint) {
        return this.getTextFlow().getPreferredSize(wHint, hHint);
    }

    private final Dimension getTextSize() {
        Rectangle r = this.getBounds();
        return this.getTextSize(r.width, r.height);
    }

    @Override
    public void invalidate() {
        this.subStringText = null;
        super.invalidate();
    }

    @Override
    public boolean isTextTruncated() {
        return !this.getSubStringTextSize().equals((Object)this.getTextSize());
    }

    protected String getEllipse() {
        return "...";
    }

    @Override
    protected String getTruncationString() {
        if (this.getEllipse() != null) {
            return this.getEllipse();
        }
        return "...";
    }

    public boolean isTextWrapped() {
        return this.isTextWrapOn();
    }

    public void setTextWrapWidth(int i) {
    }

    public void setTextWrapAlignment(int i) {
        this.setTextJustification(i);
        switch (i) {
            case 1: {
                this.setAlignment(9);
                break;
            }
            case 2: {
                this.setAlignment(8);
                break;
            }
            case 4: {
                this.setAlignment(12);
                break;
            }
        }
    }

    public void setLabelAlignment(int alignment) {
    }

    public int getTextWrapAlignment() {
        return this.getTextJustification();
    }

    private int getLineWrapPosition(String s, Font f, int w, int fontHeight) {
        if (this.getTextExtents((String)s, (Font)f, (int)fontHeight).width <= w) {
            return s.length();
        }
        BreakIterator iter = BreakIterator.getLineInstance();
        iter.setText(s);
        int start = iter.first();
        int end = iter.next();
        if (this.getTextExtents((String)s.substring((int)start, (int)end), (Font)f, (int)fontHeight).width > w) {
            iter = BreakIterator.getCharacterInstance();
            iter.setText(s);
            start = iter.first();
        }
        while ((end = iter.next()) != -1 && this.getTextExtents((String)s.substring((int)start, (int)end), (Font)f, (int)fontHeight).width <= w) {
        }
        return end == -1 ? iter.last() : iter.previous();
    }

    private int getLargestSubstringConfinedTo(String s, Font f, int w, int fontHeight, int charAverageWidth) {
        float avg = charAverageWidth;
        int min = 0;
        int max = s.length() + 1;
        int guess = 0;
        int guessSize = 0;
        while (max - min > 1) {
            if ((guess += (int)((float)(w - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = this.getTextExtents((String)s.substring((int)0, (int)guess), (Font)f, (int)fontHeight).width) < w) {
                min = guess;
                continue;
            }
            max = guess;
        }
        return min;
    }

    private Dimension getTextExtents(String s, Font f, int fontHeight) {
        if (s.length() == 0) {
            return this.getMapModeConstants().dimension_nDPtoLP_0;
        }
        Dimension d = FigureUtilities.getTextExtents((String)s, (Font)f);
        IMapMode mapMode = this.getFigureMapMode();
        d.width = mapMode.DPtoLP(d.width);
        d.height = fontHeight * new StringTokenizer(s, "\n").countTokens();
        return d;
    }
}

