/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.graph;

import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gmf.runtime.draw2d.ui.graph.BorderNode;
import org.eclipse.gmf.runtime.draw2d.ui.graph.JointEdges;

public class JointOutgoingEdges
extends Edge
implements JointEdges {
    private BorderNode joint;
    EdgeList edges = new EdgeList();
    private Edge leadingEdge = null;
    private int leadingCost = Integer.MAX_VALUE;

    public JointOutgoingEdges(BorderNode joint) {
        super(new Node(), new Node());
        this.joint = joint;
        this.source = this.target = joint.borderNodeParent;
    }

    public Edge getLeadingEdge() {
        if (this.leadingEdge == null) {
            int i = 0;
            while (i < this.edges.size()) {
                Edge e = this.edges.getEdge(i);
                int cost = this.getBendpointX(e) - e.source.x - e.source.getOffsetOutgoing();
                if (Math.abs(cost) < Math.abs(this.leadingCost)) {
                    this.leadingCost = cost;
                    this.leadingEdge = e;
                }
                ++i;
            }
        }
        return this.leadingEdge;
    }

    public BorderNode getJoint() {
        return this.joint;
    }

    private int getBendpointX(Edge e) {
        Node node = e.vNodes == null ? e.target : e.vNodes.getNode(0);
        return node.x + node.getOffsetIncoming();
    }
}

