/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.graphics;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ColorRegistry {
    private static ColorRegistry singletonInstance = new ColorRegistry();
    private static final Map colorRegistry = new HashMap();

    public static ColorRegistry getInstance() {
        return singletonInstance;
    }

    private ColorRegistry() {
    }

    public Color getColor(Integer id) {
        Object value = colorRegistry.get(id);
        if (value != null) {
            return (Color)value;
        }
        Color newColor = FigureUtilities.integerToColor(id);
        colorRegistry.put(id, newColor);
        return newColor;
    }

    public Color getColor(RGB rgb) {
        Integer colorID = FigureUtilities.RGBToInteger(rgb);
        return this.getColor(colorID);
    }
}

