/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.internal.descriptors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeFactory;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePluginStatusCodes;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.ElementTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.MetamodelDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;

public class MetamodelTypeDescriptor
extends ElementTypeDescriptor
implements IMetamodelTypeDescriptor {
    private EClass eClass;
    private String eClassName;
    private boolean eClassNotFound = false;
    private final MetamodelDescriptor metamodelDescriptor;
    private IEditHelper editHelper;
    private IMetamodelType metamodelType;
    private String editHelperName;

    public MetamodelTypeDescriptor(IMetamodelType metamodelType) {
        super(metamodelType);
        this.eClass = metamodelType.getEClass();
        this.editHelper = metamodelType.getEditHelper();
        this.metamodelType = metamodelType;
        this.metamodelDescriptor = null;
    }

    public MetamodelTypeDescriptor(IConfigurationElement configElement, MetamodelDescriptor metamodelDescriptor) throws CoreException {
        super(configElement);
        this.metamodelDescriptor = metamodelDescriptor;
        this.eClassName = configElement.getAttribute("eclass");
        if (this.eClassName == null) {
            throw EMFTypePluginStatusCodes.getTypeInitException(this.getId(), EMFTypeCoreMessages.type_reason_no_eclass_WARN_, null);
        }
        this.editHelperName = this.getConfigElement().getAttribute("edithelper");
    }

    public IElementType getElementType() {
        IElementTypeFactory factory;
        if (this.metamodelType == null && this.getKindName() != null && this.getKindName().length() > 0 && (factory = ElementTypeRegistry.getInstance().getElementTypeFactory(this.getKindName())) != null) {
            this.metamodelType = factory.createMetamodelType(this);
        }
        return this.metamodelType;
    }

    public EClass getEClass() {
        if (this.eClass == null && !this.eClassNotFound && this.metamodelDescriptor != null) {
            EPackage ePackage = this.metamodelDescriptor.getEPackage();
            EClassifier namedElement = ePackage.getEClassifier(this.getEClassName());
            if (namedElement instanceof EClass) {
                this.eClass = (EClass)namedElement;
            }
            if (this.eClass == null) {
                this.eClassNotFound = true;
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)11, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.type_not_init_WARN_, (Object)this.getEClassName(), (Object)EMFTypeCoreMessages.type_reason_eclass_not_found_WARN_));
            }
        }
        return this.eClass;
    }

    public String getEClassName() {
        if (this.eClassName == null && this.eClass != null) {
            this.eClassName = this.eClass.getName();
        }
        return this.eClassName;
    }

    public String getNsURI() {
        if (this.metamodelDescriptor == null) {
            if (this.eClass != null) {
                return this.eClass.getEPackage().getNsURI();
            }
            return null;
        }
        return this.metamodelDescriptor.getNsURI();
    }

    public IEditHelper getEditHelper() {
        if (this.editHelper == null && this.editHelperName != null) {
            try {
                this.editHelper = (IEditHelper)this.getConfigElement().createExecutableExtension("edithelper");
            }
            catch (CoreException e) {
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)22, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.editHelper_class_not_found_ERROR_, (Object)this.editHelperName), (Throwable)e);
                this.editHelperName = null;
            }
        }
        return this.editHelper;
    }

    public String getName() {
        String name = super.getName();
        if ((name == null || name.length() < 1) && this.getEClass() != null) {
            name = this.getEClass().getName();
            this.setName(name);
        }
        return name;
    }

    public String toString() {
        return "MetamodelTypeDescriptor[" + this.getId() + "]";
    }
}

