/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.map.editor.navigator.GMFMapAbstractNavigatorItem;
import org.eclipse.gmf.map.editor.navigator.GMFMapNavigatorGroup;
import org.eclipse.gmf.map.editor.navigator.GMFMapNavigatorItem;
import org.eclipse.gmf.map.editor.part.GMFMapDiagramEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class GMFMapNavigatorLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        if (aSelection.getFirstElement() instanceof GMFMapAbstractNavigatorItem) {
            GMFMapAbstractNavigatorItem navigatorItem = (GMFMapAbstractNavigatorItem)aSelection.getFirstElement();
            if (!"GMFMap".equals(navigatorItem.getModelID())) {
                return;
            }
            Object parentFile = navigatorItem.getParent();
            while (parentFile instanceof GMFMapAbstractNavigatorItem) {
                parentFile = ((GMFMapAbstractNavigatorItem)parentFile).getParent();
            }
            if (!(parentFile instanceof IFile)) {
                return;
            }
            FileEditorInput fileInput = new FileEditorInput((IFile)parentFile);
            IEditorPart editor = aPage.findEditor((IEditorInput)fileInput);
            if (editor == null) {
                return;
            }
            aPage.bringToTop((IWorkbenchPart)editor);
            if (editor instanceof GMFMapDiagramEditor) {
                GMFMapNavigatorGroup group;
                GMFMapDiagramEditor diagramEditor = (GMFMapDiagramEditor)editor;
                Resource diagramResource = diagramEditor.getDiagram().eResource();
                View navigatorView = null;
                if (navigatorItem instanceof GMFMapNavigatorItem) {
                    navigatorView = ((GMFMapNavigatorItem)navigatorItem).getView();
                } else if (navigatorItem instanceof GMFMapNavigatorGroup && (group = (GMFMapNavigatorGroup)navigatorItem).getParent() instanceof GMFMapNavigatorItem) {
                    navigatorView = ((GMFMapNavigatorItem)group.getParent()).getView();
                }
                if (navigatorView == null) {
                    return;
                }
                EObject selectedView = diagramResource.getEObject(navigatorView.eResource().getURIFragment((EObject)navigatorView));
                if (selectedView == null) {
                    return;
                }
                EditPart selectedEditPart = (EditPart)diagramEditor.getDiagramGraphicalViewer().getEditPartRegistry().get(selectedView);
                if (selectedEditPart != null) {
                    diagramEditor.getDiagramGraphicalViewer().select(selectedEditPart);
                }
            }
        }
    }
}

