/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.ui.pde.util;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.examples.ui.pde.internal.GmfExamplesDebugOptions;
import org.eclipse.gmf.examples.ui.pde.internal.GmfExamplesPlugin;
import org.eclipse.gmf.examples.ui.pde.util.Trace;

public class Log {
    private static final ILog fLog = GmfExamplesPlugin.getDefault().getLog();

    protected Log() {
    }

    protected static ILog getDefault() {
        return fLog;
    }

    public static void log(Plugin plugin, IStatus status) {
        switch (status.getSeverity()) {
            case 2: 
            case 4: {
                Log.getDefault().log(status);
                break;
            }
        }
    }

    public static void log(Plugin plugin, int severity, int code, String message) {
        Log.log(plugin, severity, code, message, null);
    }

    public static void log(Plugin plugin, int severity, int code, String message, Throwable throwable) {
        String msg = message == null ? "" : message;
        try {
            Log.log(plugin, (IStatus)new Status(severity, plugin.getBundle().getSymbolicName(), code, msg, throwable));
        }
        catch (IllegalArgumentException iae) {
            Trace.catching((Plugin)GmfExamplesPlugin.getDefault(), GmfExamplesDebugOptions.EXCEPTIONS_CATCHING, Log.getDefault().getClass(), "log", iae);
            Log.error((Plugin)GmfExamplesPlugin.getDefault(), 5, "log", iae);
        }
    }

    public static void error(Plugin plugin, int code, String message) {
        Log.error(plugin, code, message, null);
    }

    public static void error(Plugin plugin, int code, String message, Throwable throwable) {
        Log.log(plugin, 4, code, message, throwable);
    }

    public static void warning(Plugin plugin, int code, String message) {
        Log.warning(plugin, code, message, null);
    }

    public static void warning(Plugin plugin, int code, String message, Throwable throwable) {
        Log.log(plugin, 2, code, message, throwable);
    }

    public static void info(Plugin plugin, int code, String message) {
        Log.info(plugin, code, message, null);
    }

    public static void info(Plugin plugin, int code, String message, Throwable throwable) {
        Log.log(plugin, 1, code, message, throwable);
    }
}

