/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.gmf.codegen.gmfgen.CreateShortcutAction;
import org.eclipse.gmf.codegen.gmfgen.CustomParser;
import org.eclipse.gmf.codegen.gmfgen.DynamicModelAccess;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenCommandAction;
import org.eclipse.gmf.codegen.gmfgen.GenContextMenu;
import org.eclipse.gmf.codegen.gmfgen.GenCustomAction;
import org.eclipse.gmf.codegen.gmfgen.GenCustomPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenGroupMarker;
import org.eclipse.gmf.codegen.gmfgen.GenMenuManager;
import org.eclipse.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.gmf.codegen.gmfgen.GenPreference;
import org.eclipse.gmf.codegen.gmfgen.GenPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.GenStandardPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.LoadResourceAction;
import org.eclipse.gmf.codegen.gmfgen.StandardPreferencePages;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.tests.gen.CompilationTest;
import org.eclipse.gmf.tests.gen.GenDiagramMutator;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.RuntimeBasedGeneratorConfiguration;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RuntimeCompilationTest
extends CompilationTest {
    public RuntimeCompilationTest(String name) {
        super(name, new RuntimeBasedGeneratorConfiguration(), (ViewmapProducer)new InnerClassViewmapProducer());
    }

    public void testCompilePureDesignDiagram() throws Exception {
        this.myMapSource.detachFromDomainModel();
        DiaGenSource gmfGenSource = this.createLibraryGen(false);
        gmfGenSource.getGenDiagram().getEditorGen().setPackageNamePrefix("org.eclipse.gmf.examples.library.diagram");
        this.generateAndCompile(gmfGenSource, new GenDiagramMutator[0]);
    }

    public void testCompileDynamicDomainModel() throws Exception {
        DiaGenSource s = this.createLibraryGen(false);
        GenEditorGenerator editorGen = s.getGenDiagram().getEditorGen();
        RuntimeCompilationTest.assertNull((String)"prereq", (Object)editorGen.getModelAccess());
        DynamicModelAccess dma = GMFGenFactory.eINSTANCE.createDynamicModelAccess();
        editorGen.setModelAccess(dma);
        this.generateAndCompile(s, new GenDiagramMutator("dynmodel"){

            public void doMutation(GenDiagram d) {
                DynamicModelAccess modelAccess = d.getEditorGen().getModelAccess();
                modelAccess.setClassName("NonDefaultDynamicAccessorName");
            }

            public void undoMutation(GenDiagram d) {
                DynamicModelAccess modelAccess = d.getEditorGen().getModelAccess();
                modelAccess.setClassName(null);
            }
        });
    }

    public void testPreferencePages() throws Exception {
        DiaGenSource s = this.createLibraryGen(false);
        GenDiagram gd = s.getGenDiagram();
        GenStandardPreferencePage[] p = new GenStandardPreferencePage[StandardPreferencePages.values().length];
        RuntimeCompilationTest.assertTrue((String)"sanity", (p.length > 5 ? 1 : 0) != 0);
        int i = 0;
        while (i < p.length) {
            p[i] = GMFGenFactory.eINSTANCE.createGenStandardPreferencePage();
            p[i].setClassName("Page" + i);
            p[i].setKind(StandardPreferencePages.values()[i]);
            if (i > 0) {
                p[i - 1].getChildren().add((Object)p[i]);
            }
            ++i;
        }
        gd.getPreferencePages().clear();
        gd.getPreferencePages().add((Object)p[0]);
        this.generateAndCompile(s, new GenDiagramMutator[0]);
        GenPlugin gp = gd.getEditorGen().getPlugin();
        IProject generatedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(gp.getID());
        IFile generatedManifest = generatedProject.getFile("plugin.xml");
        RuntimeCompilationTest.assertTrue((boolean)generatedManifest.exists());
        XPathFactory xf = XPathFactory.newInstance();
        XPathExpression xe = xf.newXPath().compile("/plugin/extension[@point = 'org.eclipse.ui.preferencePages']/page");
        NodeList result = (NodeList)xe.evaluate(new InputSource(generatedManifest.getContents()), XPathConstants.NODESET);
        RuntimeCompilationTest.assertEquals((int)p.length, (int)result.getLength());
        gp.setID(String.valueOf(gp.getID()) + ".boilerplateprefpage");
        gd.getPreferencePages().clear();
        GenCustomPreferencePage cp1 = GMFGenFactory.eINSTANCE.createGenCustomPreferencePage();
        cp1.setQualifiedClassName(String.valueOf(gd.getPreferencesPackageName()) + ".CustomPageNoCodeGenerated");
        cp1.setGenerateBoilerplate(false);
        GenCustomPreferencePage cp2 = GMFGenFactory.eINSTANCE.createGenCustomPreferencePage();
        cp2.setQualifiedClassName(String.valueOf(gd.getPreferencesPackageName()) + ".CustomPageWithBoilerplateCode");
        cp2.setGenerateBoilerplate(true);
        GenStandardPreferencePage onePage = GMFGenFactory.eINSTANCE.createGenStandardPreferencePage();
        onePage.setKind(StandardPreferencePages.CONNECTIONS_LITERAL);
        onePage.getChildren().add((Object)cp1);
        onePage.getChildren().add((Object)cp2);
        gd.getPreferencePages().add((Object)onePage);
        this.generateAndCompile(s, new GenDiagramMutator[0]);
        generatedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(gp.getID());
        generatedManifest = generatedProject.getFile("plugin.xml");
        RuntimeCompilationTest.assertTrue((boolean)generatedManifest.exists());
        result = (NodeList)xe.evaluate(new InputSource(generatedManifest.getContents()), XPathConstants.NODESET);
        RuntimeCompilationTest.assertEquals((int)3, (int)result.getLength());
        HashSet<String> names = new HashSet<String>();
        names.add(onePage.getQualifiedClassName());
        names.add(cp1.getQualifiedClassName());
        names.add(cp2.getQualifiedClassName());
        RuntimeCompilationTest.assertTrue((String)"sanity", (names.size() == 3 ? 1 : 0) != 0);
        int i2 = 0;
        while (i2 < result.getLength()) {
            String className = result.item(i2).getAttributes().getNamedItem("class").getNodeValue();
            RuntimeCompilationTest.assertTrue((String)className, (boolean)names.remove(className));
            ++i2;
        }
        RuntimeCompilationTest.assertTrue((boolean)names.isEmpty());
        IFile file_sp = generatedProject.getFile("/src/" + onePage.getQualifiedClassName().replace('.', '/') + ".java");
        IFile file_cp1 = generatedProject.getFile("/src/" + cp1.getQualifiedClassName().replace('.', '/') + ".java");
        IFile file_cp2 = generatedProject.getFile("/src/" + cp2.getQualifiedClassName().replace('.', '/') + ".java");
        RuntimeCompilationTest.assertTrue((boolean)file_sp.exists());
        RuntimeCompilationTest.assertTrue((boolean)file_cp2.exists());
        RuntimeCompilationTest.assertFalse((boolean)file_cp1.exists());
    }

    public void testCustomActions() throws Exception {
        DiaGenSource s = this.createLibraryGen(false);
        GenEditorGenerator editorGen = s.getGenDiagram().getEditorGen();
        GenContextMenu menu = GMFGenFactory.eINSTANCE.createGenContextMenu();
        GenCustomAction a1 = GMFGenFactory.eINSTANCE.createGenCustomAction();
        GenCustomAction a2 = GMFGenFactory.eINSTANCE.createGenCustomAction();
        GenCustomAction a3 = GMFGenFactory.eINSTANCE.createGenCustomAction();
        a1.setGenerateBoilerplate(false);
        a2.setGenerateBoilerplate(true);
        a3.setGenerateBoilerplate(true);
        a1.setQualifiedClassName("org.sample.actions.Action1");
        a2.setQualifiedClassName("org.sample.actions.Action2");
        a3.setQualifiedClassName("org.sample.actions.Action3");
        a1.setName("testaction-1");
        a2.setName("testaction-2");
        a3.setName("testaction-3");
        GenMenuManager subMenu = GMFGenFactory.eINSTANCE.createGenMenuManager();
        subMenu.setID("org.sample.submenu");
        GenGroupMarker gm = GMFGenFactory.eINSTANCE.createGenGroupMarker();
        gm.setGroupName("group.name");
        GenCommandAction cmdAction = GMFGenFactory.eINSTANCE.createGenCommandAction();
        cmdAction.setCommandIdentifier("org.sample.command");
        subMenu.getItems().add((Object)a3);
        subMenu.getItems().add((Object)gm);
        subMenu.getItems().add((Object)cmdAction);
        menu.getItems().add((Object)a1);
        menu.getItems().add((Object)GMFGenFactory.eINSTANCE.createGenSeparator());
        menu.getItems().add((Object)a2);
        menu.getItems().add((Object)subMenu);
        editorGen.getContextMenus().clear();
        editorGen.getContextMenus().add((Object)menu);
        this.generateAndCompile(s, new GenDiagramMutator[0]);
        IProject generatedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(editorGen.getPlugin().getID());
        IFile generatedManifest = generatedProject.getFile("plugin.xml");
        RuntimeCompilationTest.assertTrue((boolean)generatedManifest.exists());
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document parsedManifest = db.parse(new InputSource(generatedManifest.getContents()));
        XPath xf = XPathFactory.newInstance().newXPath();
        XPathExpression xe = xf.compile("/plugin/extension[@point = 'org.eclipse.ui.menus']/menuContribution");
        NodeList result = (NodeList)xe.evaluate(parsedManifest, XPathConstants.NODESET);
        RuntimeCompilationTest.assertEquals((int)2, (int)result.getLength());
        String l1 = result.item(0).getAttributes().getNamedItem("locationURI").getNodeValue();
        String l2 = result.item(1).getAttributes().getNamedItem("locationURI").getNodeValue();
        RuntimeCompilationTest.assertEquals((String)l1, (String)"popup:org.eclipse.gmf.runtime.diagram.ui.DiagramEditorContextMenu");
        RuntimeCompilationTest.assertEquals((String)l2, (String)("popup:" + subMenu.getID()));
        xe = xf.compile("/plugin/extension[@point = 'org.eclipse.ui.menus']/menuContribution/menu");
        result = (NodeList)xe.evaluate(parsedManifest, XPathConstants.NODESET);
        RuntimeCompilationTest.assertEquals((int)1, (int)result.getLength());
        String menuIdAttr = result.item(0).getAttributes().getNamedItem("id").getNodeValue();
        RuntimeCompilationTest.assertEquals((String)subMenu.getID(), (String)menuIdAttr);
        xe = xf.compile("/plugin/extension[@point = 'org.eclipse.ui.menus']/menuContribution/command");
        result = (NodeList)xe.evaluate(parsedManifest, XPathConstants.NODESET);
        RuntimeCompilationTest.assertEquals((int)4, (int)result.getLength());
        xe = xf.compile("/plugin/extension[@point = 'org.eclipse.ui.menus']/menuContribution/separator");
        result = (NodeList)xe.evaluate(parsedManifest, XPathConstants.NODESET);
        RuntimeCompilationTest.assertEquals((int)2, (int)result.getLength());
        xe = xf.compile("/plugin/extension[@point = 'org.eclipse.ui.commands']/command[starts-with(@name,'testaction-')]");
        result = (NodeList)xe.evaluate(parsedManifest, XPathConstants.NODESET);
        RuntimeCompilationTest.assertEquals((int)3, (int)result.getLength());
        xe = xf.compile("/plugin/extension[@point = 'org.eclipse.ui.handlers']/handler");
        result = (NodeList)xe.evaluate(parsedManifest, XPathConstants.NODESET);
        RuntimeCompilationTest.assertEquals((int)3, (int)result.getLength());
        String h1 = result.item(0).getAttributes().getNamedItem("class").getNodeValue();
        String h2 = result.item(1).getAttributes().getNamedItem("class").getNodeValue();
        String h3 = result.item(2).getAttributes().getNamedItem("class").getNodeValue();
        RuntimeCompilationTest.assertEquals((String)a1.getQualifiedClassName(), (String)h1);
        RuntimeCompilationTest.assertEquals((String)a2.getQualifiedClassName(), (String)h2);
        RuntimeCompilationTest.assertEquals((String)a3.getQualifiedClassName(), (String)h3);
        IFile file_a1 = generatedProject.getFile("/src/" + a1.getQualifiedClassName().replace('.', '/') + ".java");
        IFile file_a2 = generatedProject.getFile("/src/" + a2.getQualifiedClassName().replace('.', '/') + ".java");
        IFile file_a3 = generatedProject.getFile("/src/" + a3.getQualifiedClassName().replace('.', '/') + ".java");
        RuntimeCompilationTest.assertFalse((boolean)file_a1.exists());
        RuntimeCompilationTest.assertTrue((boolean)file_a2.exists());
        RuntimeCompilationTest.assertTrue((boolean)file_a3.exists());
    }

    public void testPredefinedActions() throws Exception {
        DiaGenSource s1 = this.createLibraryGen(false);
        GenEditorGenerator editorGen = s1.getGenDiagram().getEditorGen();
        GenContextMenu menu = GMFGenFactory.eINSTANCE.createGenContextMenu();
        menu.getContext().add((Object)s1.getGenDiagram());
        CreateShortcutAction createShortcutAction = GMFGenFactory.eINSTANCE.createCreateShortcutAction();
        LoadResourceAction loadResourceAction = GMFGenFactory.eINSTANCE.createLoadResourceAction();
        menu.getItems().add((Object)createShortcutAction);
        menu.getItems().add((Object)loadResourceAction);
        editorGen.getContextMenus().clear();
        editorGen.getContextMenus().add((Object)menu);
        editorGen.getDiagram().getContainsShortcutsTo().add((Object)"ecore");
        RuntimeCompilationTest.assertTrue((String)"sanity", (boolean)editorGen.getDiagram().generateCreateShortcutAction());
        this.generateAndCompile(s1, new GenDiagramMutator[0]);
        IProject generatedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(editorGen.getPlugin().getID());
        IFile generatedManifest = generatedProject.getFile("plugin.xml");
        RuntimeCompilationTest.assertTrue((boolean)generatedManifest.exists());
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document parsedManifest = db.parse(new InputSource(generatedManifest.getContents()));
        XPath xf = XPathFactory.newInstance().newXPath();
        XPathExpression xe = xf.compile("/plugin/extension[@point = 'org.eclipse.ui.menus']/menuContribution/command");
        NodeList result = (NodeList)xe.evaluate(parsedManifest, XPathConstants.NODESET);
        RuntimeCompilationTest.assertEquals((int)2, (int)result.getLength());
        xe = xf.compile("/plugin/extension[@point = 'org.eclipse.ui.commands']/command");
        result = (NodeList)xe.evaluate(parsedManifest, XPathConstants.NODESET);
        RuntimeCompilationTest.assertTrue((result.getLength() > 2 ? 1 : 0) != 0);
        HashSet<String> allCommands = new HashSet<String>();
        int i = result.getLength() - 1;
        while (i >= 0) {
            allCommands.add(result.item(i).getAttributes().getNamedItem("defaultHandler").getNodeValue());
            --i;
        }
        RuntimeCompilationTest.assertTrue((boolean)allCommands.contains(createShortcutAction.getQualifiedClassName()));
        RuntimeCompilationTest.assertTrue((boolean)allCommands.contains(loadResourceAction.getQualifiedClassName()));
        IFile file1 = generatedProject.getFile("/src/" + createShortcutAction.getQualifiedClassName().replace('.', '/') + ".java");
        IFile file2 = generatedProject.getFile("/src/" + loadResourceAction.getQualifiedClassName().replace('.', '/') + ".java");
        RuntimeCompilationTest.assertTrue((boolean)file1.exists());
        RuntimeCompilationTest.assertTrue((boolean)file2.exists());
    }

    public void testCustomPreferences() throws Exception {
        DiaGenSource s = this.createLibraryGen(false);
        GenDiagram gd = s.getGenDiagram();
        GenCustomPreferencePage pp = GMFGenFactory.eINSTANCE.createGenCustomPreferencePage();
        if (gd.getPreferencePages().isEmpty()) {
            gd.getPreferencePages().add((Object)pp);
        } else {
            ((GenPreferencePage)gd.getPreferencePages().get(0)).getChildren().add((Object)pp);
        }
        pp.setGenerateBoilerplate(true);
        pp.setName("Page Name");
        pp.setQualifiedClassName(String.valueOf(gd.getEditorGen().getEditor().getPackageName()) + ".CustomPreferencePage");
        GenPreference p1 = GMFGenFactory.eINSTANCE.createGenPreference();
        p1.setName("PREF_XXX_ONE");
        p1.setDefaultValue("\"XXX_ONE_DEFAULT\"");
        GenPreference p2 = GMFGenFactory.eINSTANCE.createGenPreference();
        p2.setName("NO_PREFIX_XXX_TWO");
        p2.setKey("KEY.XXX.TWO");
        pp.getPreferences().add((Object)p1);
        pp.getPreferences().add((Object)p2);
        this.generateAndCompile(s, new GenDiagramMutator[0]);
        IProject generatedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(gd.getEditorGen().getPlugin().getID());
        IFile file_pp = generatedProject.getFile("/src/" + pp.getQualifiedClassName().replace('.', '/') + ".java");
        RuntimeCompilationTest.assertTrue((boolean)file_pp.exists());
        ICompilationUnit cuPage = (ICompilationUnit)JavaCore.create((IFile)file_pp);
        RuntimeCompilationTest.assertNotNull((Object)cuPage);
        IType mainClass = cuPage.getTypes()[0];
        RuntimeCompilationTest.assertNotNull((Object)mainClass);
        RuntimeCompilationTest.assertEquals((int)2, (int)mainClass.getFields().length);
        IField p1field = mainClass.getField(p1.getName());
        IField p2field = mainClass.getField(p2.getName());
        RuntimeCompilationTest.assertTrue((boolean)Flags.isPublic((int)p1field.getFlags()));
        RuntimeCompilationTest.assertTrue((boolean)Flags.isStatic((int)p1field.getFlags()));
        RuntimeCompilationTest.assertTrue((boolean)Flags.isPublic((int)p2field.getFlags()));
        RuntimeCompilationTest.assertTrue((boolean)Flags.isStatic((int)p2field.getFlags()));
        RuntimeCompilationTest.assertEquals((Object)(String.valueOf('\"') + p1.getKey() + '\"'), (Object)p1field.getConstant());
        RuntimeCompilationTest.assertEquals((Object)(String.valueOf('\"') + p2.getKey() + '\"'), (Object)p2field.getConstant());
        IMethod initMethod = mainClass.getMethod("initDefaults", new String[]{"Q" + IPreferenceStore.class.getSimpleName() + ";"});
        RuntimeCompilationTest.assertNotNull((Object)initMethod);
        String methodText = initMethod.getSource();
        RuntimeCompilationTest.assertTrue((methodText.indexOf(p1.getName()) != -1 ? 1 : 0) != 0);
        RuntimeCompilationTest.assertTrue((methodText.indexOf(p1.getDefaultValue()) != -1 ? 1 : 0) != 0);
        RuntimeCompilationTest.assertTrue((methodText.indexOf(p2.getName()) == -1 ? 1 : 0) != 0);
    }

    public void testCustomParsers() throws Exception {
        DiaGenSource s = this.createLibraryGen(false);
        GenEditorGenerator gd = s.getGenDiagram().getEditorGen();
        CustomParser cp1 = GMFGenFactory.eINSTANCE.createCustomParser();
        cp1.setQualifiedName(String.valueOf(gd.getLabelParsers().getImplPackageName()) + "CustomParserOne");
        CustomParser cp2 = GMFGenFactory.eINSTANCE.createCustomParser();
        cp2.setQualifiedName(String.valueOf(gd.getLabelParsers().getImplPackageName()) + "CustomParserTwo");
        cp2.setGenerateBoilerplate(true);
        gd.getLabelParsers().getImplementations().add((Object)cp1);
        gd.getLabelParsers().getImplementations().add((Object)cp2);
        this.generateAndCompile(s, new GenDiagramMutator[0]);
        IProject generatedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(gd.getPlugin().getID());
        IFile file_cp1 = generatedProject.getFile("/src/" + cp1.getQualifiedName().replace('.', '/') + ".java");
        IFile file_cp2 = generatedProject.getFile("/src/" + cp2.getQualifiedName().replace('.', '/') + ".java");
        RuntimeCompilationTest.assertFalse((boolean)file_cp1.exists());
        RuntimeCompilationTest.assertTrue((boolean)file_cp2.exists());
    }
}

