/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.figures;

import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemsAwareFreeFormLayer;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.layout.FreeFormLayoutEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.AnimatableScrollPane;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.OverlayScrollPaneLayout;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class ShapeCompartmentFigure
extends ResizableCompartmentFigure {
    public static final Font FONT_TITLE = new Font(null, new FontData("Helvetica", 9, 1));

    public ShapeCompartmentFigure(String title, IMapMode mm) {
        super(title, mm);
    }

    protected AnimatableScrollPane createScrollpane(IMapMode mm) {
        this.configureFigure(mm);
        return (AnimatableScrollPane)this.getScrollPane();
    }

    protected void configureFigure() {
        this.configureFigure(MapModeUtil.getMapMode((IFigure)this));
    }

    protected void configureFigure(IMapMode mm) {
        ScrollPane scrollpane = this.getScrollPane();
        if (scrollpane == null) {
            scrollpane = this.scrollPane = new AnimatableScrollPane();
        }
        scrollpane.setViewport((Viewport)new FreeformViewport());
        this.scrollPane.setScrollBarVisibility(1);
        scrollpane.setLayoutManager((LayoutManager)new OverlayScrollPaneLayout());
        BorderItemsAwareFreeFormLayer contents = new BorderItemsAwareFreeFormLayer();
        contents.setLayoutManager((LayoutManager)new FreeFormLayoutEx());
        scrollpane.setContents((IFigure)contents);
        int MB = mm.DPtoLP(5);
        scrollpane.setBorder((Border)new MarginBorder(MB, MB, MB, MB));
        int SZ = mm.DPtoLP(10);
        scrollpane.setMinimumSize(new Dimension(SZ, SZ));
        this.setFont(FONT_TITLE);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getScrollPane().getViewport().getVerticalRangeModel().addPropertyChangeListener(listener);
        this.getScrollPane().getViewport().getHorizontalRangeModel().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getScrollPane().getViewport().getVerticalRangeModel().removePropertyChangeListener(listener);
        this.getScrollPane().getViewport().getHorizontalRangeModel().removePropertyChangeListener(listener);
    }
}

