/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.AbstractProviderConfiguration;
import org.eclipse.gmf.runtime.notation.View;

public class ViewProviderConfiguration
extends AbstractProviderConfiguration {
    private static final String CONTEXT = "context";
    private static final String VIEW_CLASS = "viewClass";
    private static final String ELEMENTS = "elements";
    private static final String CONTAINERVIEWS = "containerViews";
    private static final String SEMANTICHINTS = "semanticHints";
    private List requests = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.core.providers.ViewProviderConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static ViewProviderConfiguration parse(IConfigurationElement configElement) {
        if (!$assertionsDisabled && configElement == null) {
            throw new AssertionError((Object)"Null provider configuration elemen in ViewProviderConfiguration");
        }
        return new ViewProviderConfiguration(configElement);
    }

    private ViewProviderConfiguration(IConfigurationElement configElement) {
        HashMap<String, AbstractProviderConfiguration.ObjectDescriptor> objects = new HashMap<String, AbstractProviderConfiguration.ObjectDescriptor>();
        IConfigurationElement[] configChildren = configElement.getChildren("object");
        int i = 0;
        while (i < configChildren.length) {
            String id = configChildren[i].getAttribute("id");
            if (id != null) {
                objects.put(id, new AbstractProviderConfiguration.ObjectDescriptor(configChildren[i]));
            }
            ++i;
        }
        configChildren = configElement.getChildren(CONTEXT);
        i = 0;
        while (i < configChildren.length) {
            String viewClassName = configChildren[i].getAttribute(VIEW_CLASS);
            List elements = ViewProviderConfiguration.getObjectList((String)configChildren[i].getAttribute(ELEMENTS), objects, (IConfigurationElement)configElement);
            List parentViews = ViewProviderConfiguration.getObjectList((String)configChildren[i].getAttribute(CONTAINERVIEWS), objects, (IConfigurationElement)configElement);
            Set semanticHints = ViewProviderConfiguration.getStrings((String)configChildren[i].getAttribute(SEMANTICHINTS));
            if (viewClassName != null || elements != null || parentViews != null || semanticHints != null) {
                this.requests.add(new ContextDescriptor(viewClassName, elements, parentViews, semanticHints));
            }
            ++i;
        }
    }

    public boolean supports(Class viewKind, IAdaptable semanticAdapter, View containerView, String semanticHint) {
        if (this.requests.isEmpty()) {
            return true;
        }
        Iterator iter = this.requests.iterator();
        while (iter.hasNext()) {
            ContextDescriptor request = (ContextDescriptor)iter.next();
            if (!request.matches(viewKind, semanticAdapter, containerView, semanticHint)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean access$0(Object object, List list) {
        return AbstractProviderConfiguration.objectMatches((Object)object, (List)list);
    }

    private static class ContextDescriptor {
        private String viewClassName;
        private final List elements;
        private final List parentViews;
        private final Set semanticHints;

        public ContextDescriptor(String viewClassName, List elements, List parentViews, Set semanticHints) {
            this.viewClassName = viewClassName;
            this.elements = elements;
            this.parentViews = parentViews;
            this.semanticHints = semanticHints;
        }

        public boolean matches(Class viewKind, IAdaptable semanticAdapter, View containerView, String semanticHint) {
            if (this.viewClassName != null && !this.viewClassName.equals(viewKind.getName())) {
                return false;
            }
            if (this.semanticHints != null && !this.semanticHints.contains(semanticHint)) {
                return false;
            }
            if (this.elements != null && !ViewProviderConfiguration.access$0(semanticAdapter, this.elements)) {
                return false;
            }
            return this.parentViews == null || ViewProviderConfiguration.access$0(containerView, this.parentViews);
        }
    }
}

