/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lpg.lpgjavaruntime.LexStream;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.parser.ExpressionLexer;
import org.eclipse.gmf.internal.xpand.expression.parser.ExpressionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFacade {
    private ExecutionContext execContext;

    public ExecutionContext getExecContext() {
        return this.execContext;
    }

    public ExpressionFacade(ExecutionContext execCtx) {
        this.execContext = execCtx;
    }

    public EClassifier analyze(String expression, Set<AnalysationIssue> issues) {
        Expression expr = this.parse(expression);
        return expr.analyze(this.execContext, issues);
    }

    public Object evaluate(String expression) {
        Map context = Collections.emptyMap();
        return this.evaluate(expression, context);
    }

    public Object evaluate(String expression, Map<String, ?> context) {
        Expression expr = this.parse(expression);
        ExecutionContext ctx = this.execContext;
        for (String key : context.keySet()) {
            Variable v = new Variable(key, context.get(key));
            ctx = ctx.cloneWithVariable(v);
        }
        return expr.evaluate(ctx);
    }

    private Expression parse(String expression) {
        ExpressionLexer scanner = new ExpressionLexer(expression.toCharArray(), "nofile");
        ExpressionParser parser = new ExpressionParser((LexStream)scanner);
        scanner.lexer(parser);
        return parser.parser();
    }
}

