/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.parts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.diagram.edit.figures.FigureFromLabelUtils;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EAnnotationSourceEditPart;
import org.eclipse.emf.ecoretools.diagram.edit.policies.EAnnotationItemSemanticEditPolicy;
import org.eclipse.emf.ecoretools.diagram.edit.policies.EcoreTextSelectionEditPolicy;
import org.eclipse.emf.ecoretools.diagram.part.EcoreVisualIDRegistry;
import org.eclipse.emf.ecoretools.diagram.providers.EcoreElementTypes;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConstrainedToolbarLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;

public class EAnnotationEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 1003;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public EAnnotationEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy(){

            public Command getCommand(Request request) {
                if (this.understandsRequest(request)) {
                    CreateElementRequestAdapter adapter;
                    IElementType type;
                    if (request instanceof CreateViewAndElementRequest && (type = (IElementType)(adapter = ((CreateViewAndElementRequest)request).getViewAndElementDescriptor().getCreateElementRequestAdapter()).getAdapter(IElementType.class)) == EcoreElementTypes.EStringToStringMapEntry_2007) {
                        IGraphicalEditPart compartmentEditPart = EAnnotationEditPart.this.getChildBySemanticHint(EcoreVisualIDRegistry.getType(5007));
                        return compartmentEditPart == null ? null : compartmentEditPart.getCommand(request);
                    }
                    return super.getCommand(request);
                }
                return null;
            }
        });
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new EAnnotationItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        ConstrainedToolbarLayoutEditPolicy lep = new ConstrainedToolbarLayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child.getEditPolicy((Object)"PrimaryDrag Policy") == null && child instanceof ITextAwareEditPart) {
                    return new EcoreTextSelectionEditPolicy();
                }
                return super.createChildEditPolicy(child);
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        AnnotationFigure figure = new AnnotationFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public AnnotationFigure getPrimaryShape() {
        return (AnnotationFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof EAnnotationSourceEditPart) {
            ((EAnnotationSourceEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureAnnotationNameLabel());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return super.getContentPaneFor(editPart);
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40)){

            public PointList getPolygonPoints() {
                return EAnnotationEditPart.this.getPrimaryShape().getPointsList();
            }
        };
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(EcoreVisualIDRegistry.getType(4007));
    }

    protected void handleNotificationEvent(Notification event) {
        if (event.getNotifier() == this.getModel() && EcorePackage.eINSTANCE.getEModelElement_EAnnotations().equals(event.getFeature())) {
            this.handleMajorSemanticChange();
        } else {
            super.handleNotificationEvent(event);
        }
    }

    protected void refreshVisuals() {
        EObject semanticElement = this.resolveSemanticElement();
        if (FigureFromLabelUtils.needFromLabel(semanticElement, this.getNotationView())) {
            this.getPrimaryShape().updateFromLabel(FigureFromLabelUtils.getQualifiedName(semanticElement));
            this.getPrimaryShape().addFromLabel();
        } else {
            this.getPrimaryShape().removeFromLabel();
        }
        super.refreshVisuals();
    }

    public class AnnotationFigure
    extends RectangleFigure {
        private WrappingLabel fFigureAnnotationNameLabel;
        protected static final int BENT_CORNER_WIDTH = 12;
        protected static final int BENT_CORNER_HEIGHT = 12;
        private boolean myUseLocalCoordinates = false;
        private boolean canRemovedFromLabel;
        private WrappingLabel fFigureFromLabel;

        public PointList getPointsList() {
            Rectangle r = this.getBounds();
            int x = r.x;
            int y = r.y;
            int h = r.height;
            int w = r.width;
            Point point1 = new Point(x, y);
            Point point2 = new Point(x + w - 12, y);
            Point point3 = new Point(x + w, y + 12);
            Point point4 = new Point(x + w, y + h);
            Point point5 = new Point(x, y + h);
            PointList desiredBounds = new PointList();
            desiredBounds.addPoint(point1);
            desiredBounds.addPoint(point2);
            desiredBounds.addPoint(point3);
            desiredBounds.addPoint(point4);
            desiredBounds.addPoint(point5);
            return desiredBounds;
        }

        protected void fillShape(Graphics graphics) {
            Rectangle r = this.getBounds();
            int x = r.x + this.lineWidth / 2;
            int y = r.y + this.lineWidth / 2;
            int h = r.height - Math.max(1, this.lineWidth);
            int w = r.width - Math.max(1, this.lineWidth);
            Point point1 = new Point(x, y);
            Point point2 = new Point(x + w - 12, y);
            Point point3 = new Point(x + w, y + 12);
            Point point4 = new Point(x + w, y + h);
            Point point5 = new Point(x, y + h);
            PointList desiredBounds = new PointList();
            desiredBounds.addPoint(point1);
            desiredBounds.addPoint(point2);
            desiredBounds.addPoint(point3);
            desiredBounds.addPoint(point4);
            desiredBounds.addPoint(point5);
            graphics.fillPolygon(desiredBounds);
        }

        protected void outlineShape(Graphics graphics) {
            Rectangle r = this.getBounds();
            int x = r.x + this.lineWidth / 2;
            int y = r.y + this.lineWidth / 2;
            int h = r.height - Math.max(1, this.lineWidth);
            int w = r.width - Math.max(1, this.lineWidth);
            Point point1 = new Point(x, y);
            Point point2 = new Point(x + w - 12, y);
            Point point3 = new Point(x + w, y + 12);
            Point point4 = new Point(x + w, y + h);
            Point point5 = new Point(x, y + h);
            Point point6 = new Point(x + w - 12, y + 12);
            PointList desiredBounds = new PointList();
            desiredBounds.addPoint(point1);
            desiredBounds.addPoint(point2);
            desiredBounds.addPoint(point3);
            desiredBounds.addPoint(point4);
            desiredBounds.addPoint(point5);
            graphics.drawPolygon(desiredBounds);
            graphics.drawLine(point2, point3);
            graphics.drawLine(point2, point6);
            graphics.drawLine(point6, point3);
        }

        public AnnotationFigure() {
            ToolbarLayout layoutThis = new ToolbarLayout();
            layoutThis.setStretchMinorAxis(true);
            layoutThis.setMinorAlignment(0);
            layoutThis.setSpacing(0);
            layoutThis.setVertical(true);
            this.setLayoutManager((LayoutManager)layoutThis);
            this.setMinimumSize(new Dimension(EAnnotationEditPart.this.getMapMode().DPtoLP(100), EAnnotationEditPart.this.getMapMode().DPtoLP(30)));
            this.setBorder((Border)new MarginBorder(EAnnotationEditPart.this.getMapMode().DPtoLP(0), EAnnotationEditPart.this.getMapMode().DPtoLP(0), EAnnotationEditPart.this.getMapMode().DPtoLP(0), EAnnotationEditPart.this.getMapMode().DPtoLP(14)));
            this.createContents();
        }

        private void createContents() {
            this.fFigureAnnotationNameLabel = new WrappingLabel();
            this.fFigureAnnotationNameLabel.setAlignment(8);
            this.fFigureAnnotationNameLabel.setText("<..>");
            this.add((IFigure)this.fFigureAnnotationNameLabel);
            this.fFigureFromLabel = new WrappingLabel();
            this.fFigureFromLabel.setAlignment(8);
            this.fFigureFromLabel.setText("<..>");
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public WrappingLabel getFigureAnnotationNameLabel() {
            return this.fFigureAnnotationNameLabel;
        }

        public void addFromLabel() {
            this.add((IFigure)this.getFigureFromLabel(), 1);
            this.canRemovedFromLabel = true;
        }

        public WrappingLabel getFigureFromLabel() {
            return this.fFigureFromLabel;
        }

        public void removeFromLabel() {
            if (this.canRemovedFromLabel) {
                this.remove((IFigure)this.getFigureFromLabel());
                this.canRemovedFromLabel = false;
            }
        }

        public void updateFromLabel(String text) {
            this.getFigureFromLabel().setText(text);
        }
    }
}

