/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.core.impl;

import org.eclipse.emf.cdo.core.NoMoreOIDsException;
import org.eclipse.emf.cdo.core.OIDEncoder;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;

public class OIDEncoderImpl
extends ServiceImpl
implements OIDEncoder {
    public static final int MIN_FRAGMENT_BITS = 32;
    public static final int MAX_FRAGMENT_BITS = 64;
    public static final int DEFAULT_FRAGMENT_BITS = 48;
    protected int fragmentBits = 48;
    private long fragmentMask;

    public int getRID(long oid) {
        return (int)(oid >> this.fragmentBits);
    }

    public long getOIDFragment(long oid) {
        return oid & this.fragmentMask;
    }

    public long getOID(int rid, long oidFragment) {
        if (oidFragment > this.fragmentMask) {
            throw new NoMoreOIDsException();
        }
        long offset = rid;
        return (offset <<= this.fragmentBits) + oidFragment;
    }

    public String toString(int rid, long oidFragment) {
        return rid + "#" + oidFragment;
    }

    public String toString(long oid) {
        if (oid >= 0L) {
            return this.toString(this.getRID(oid), this.getOIDFragment(oid));
        }
        return this.toString(this.getRID(-oid), -this.getOIDFragment(-oid));
    }

    public int getFragmentBits() {
        return this.fragmentBits;
    }

    public void setFragmentBits(int fragmentBits) {
        this.doSet("fragmentBits", fragmentBits);
    }

    protected void validate() throws ValidationException {
        super.validate();
        if (this.fragmentBits < 32 || this.fragmentBits > 64) {
            throw new ValidationException("fragmentBits is not in range (32-64): " + this.fragmentBits);
        }
        this.fragmentMask = 0L;
        int i = 0;
        while (i < this.fragmentBits) {
            this.fragmentMask <<= 1;
            ++this.fragmentMask;
            ++i;
        }
    }
}

