/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.helper.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.parameters.IModelSearchQueryParameters;
import org.eclipse.emf.search.core.scope.IModelSearchScope;
import org.eclipse.emf.search.ecore.evaluators.EcoreTextualModelSearchQueryEvaluator;
import org.eclipse.emf.search.ecore.factories.EcoreModelSearchQueryFactory;
import org.eclipse.emf.search.ecore.factories.EcoreModelSearchQueryParametersFactory;
import org.eclipse.emf.search.ecore.helper.builder.ICaseSensitiveModelSearchQueryBuilderHelper;
import org.eclipse.emf.search.ecore.helper.builder.IRegexModelSearchQueryBuilderHelper;
import org.eclipse.emf.search.ecore.helper.builder.ITextualModelSearchQueryBuilderHelper;
import org.eclipse.emf.search.ecore.regex.ModelSearchQueryTextualExpressionEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEcoreTextualModelSearchQueryBuilderHelper
implements ITextualModelSearchQueryBuilderHelper,
IRegexModelSearchQueryBuilderHelper,
ICaseSensitiveModelSearchQueryBuilderHelper {
    protected IModelSearchQueryParameters createParameters(IModelSearchScope<Object, Resource> scope, List<? extends Object> participants, ModelSearchQueryTextualExpressionEnum textualExpression) {
        IModelSearchQueryParameters parameters = EcoreModelSearchQueryParametersFactory.getInstance().createSearchQueryParameters();
        parameters.setEvaluator(new EcoreTextualModelSearchQueryEvaluator());
        parameters.setParticipantElements(participants);
        parameters.setScope(scope);
        this.initTextualQueryParametersFromPatternKind(parameters, textualExpression);
        return parameters;
    }

    protected IModelSearchQuery createQuery(String pattern, IModelSearchQueryParameters parameters) {
        return EcoreModelSearchQueryFactory.getInstance().createModelSearchQuery(pattern, parameters);
    }

    protected void initTextualQueryParametersFromPatternKind(IModelSearchQueryParameters parameters, ModelSearchQueryTextualExpressionEnum textualExpression) {
        switch (textualExpression) {
            case REGULAR_EXPRESSION: {
                parameters.setData("searchCaseSensitive", (Object)Boolean.FALSE);
                parameters.setData("searchRegularExpression", (Object)Boolean.TRUE);
                break;
            }
            case CASE_SENSITIVE: {
                parameters.setData("searchCaseSensitive", (Object)Boolean.TRUE);
                parameters.setData("searchRegularExpression", (Object)Boolean.FALSE);
                break;
            }
            default: {
                parameters.setData("searchCaseSensitive", (Object)Boolean.FALSE);
                parameters.setData("searchRegularExpression", (Object)Boolean.FALSE);
            }
        }
    }

    protected IModelSearchQuery buildTextualModelSearchQuery(String pattern, List<? extends Object> participants, ModelSearchQueryTextualExpressionEnum textualExpression, IModelSearchScope<Object, Resource> scope, String nsURI) {
        IModelSearchQueryParameters parameters = this.createParameters(scope, participants, textualExpression);
        return this.createQuery(pattern, parameters);
    }

    @Override
    public IModelSearchQuery buildFilteredTextualModelSearchQuery(String pattern, List<EObject> participants, IModelSearchScope<Object, Resource> scope, String nsURI) {
        return this.buildTextualModelSearchQuery(pattern, participants, ModelSearchQueryTextualExpressionEnum.NORMAL_TEXT, scope, nsURI);
    }

    @Override
    public IModelSearchQuery buildFilteredTextualModelSearchQuery(String pattern, EObject participant, IModelSearchScope<Object, Resource> scope, String nsURI) {
        ArrayList<EObject> participants = new ArrayList<EObject>();
        participants.add(participant);
        return this.buildTextualModelSearchQuery(pattern, participants, ModelSearchQueryTextualExpressionEnum.NORMAL_TEXT, scope, nsURI);
    }

    @Override
    public IModelSearchQuery buildFilteredRegexModelSearchQuery(String pattern, List<EObject> participants, IModelSearchScope<Object, Resource> scope, String nsURI) {
        return this.buildTextualModelSearchQuery(pattern, participants, ModelSearchQueryTextualExpressionEnum.REGULAR_EXPRESSION, scope, nsURI);
    }

    @Override
    public IModelSearchQuery buildFilteredRegexModelSearchQuery(String pattern, EObject participant, IModelSearchScope<Object, Resource> scope, String nsURI) {
        ArrayList<EObject> participants = new ArrayList<EObject>();
        participants.add(participant);
        return this.buildTextualModelSearchQuery(pattern, participants, ModelSearchQueryTextualExpressionEnum.REGULAR_EXPRESSION, scope, nsURI);
    }

    @Override
    public IModelSearchQuery buildFilteredCaseSensitiveModelSearchQuery(String pattern, EObject participant, IModelSearchScope<Object, Resource> scope, String nsURI) {
        ArrayList<EObject> participants = new ArrayList<EObject>();
        participants.add(participant);
        return this.buildTextualModelSearchQuery(pattern, participants, ModelSearchQueryTextualExpressionEnum.CASE_SENSITIVE, scope, nsURI);
    }

    @Override
    public IModelSearchQuery buildFilteredCaseSensitiveModelSearchQuery(String pattern, List<EObject> participants, IModelSearchScope<Object, Resource> scope, String nsURI) {
        return this.buildTextualModelSearchQuery(pattern, participants, ModelSearchQueryTextualExpressionEnum.CASE_SENSITIVE, scope, nsURI);
    }
}

