/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.workflow.debug;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.internal.core.ast.AbstractASTBase;
import org.eclipse.emf.mwe.internal.core.ast.ComponentAST;
import org.eclipse.emf.mwe.internal.core.ast.InclusionAST;
import org.eclipse.emf.mwe.internal.core.ast.parser.Location;
import org.eclipse.emf.mwe.internal.core.ast.parser.XmlLocationAnalyser;
import org.eclipse.emf.mwe.internal.core.ast.util.WorkflowFactory;
import org.eclipse.emf.mwe.internal.ui.workflow.Activator;
import org.eclipse.emf.mwe.ui.debug.model.MWEBreakpoint;
import org.eclipse.emf.mwe.ui.debug.processing.PluginAdapter;
import org.eclipse.emf.mwe.ui.workflow.util.PluginConfigurationElementUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWEPluginAdapter
implements PluginAdapter {
    private final XmlLocationAnalyser locationAnalyser = new XmlLocationAnalyser();
    private static Set<String> extensions = new HashSet<String>();
    private Image icon = null;

    static {
        extensions.add("mwe");
        extensions.add("oaw");
    }

    @Override
    public boolean canHandleResourceExtension(String ext) {
        return this.getRequiredExtension().contains(ext);
    }

    @Override
    public boolean canHandleType(String type) {
        return "workflow".equals(type);
    }

    private Set<String> getRequiredExtension() {
        return extensions;
    }

    @Override
    public String getEditorId() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = PluginConfigurationElementUtil.getConfigElements("org.eclipse.ui.editors/editor[extensions=mwe, oaw]/id");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("default").equalsIgnoreCase("true")) {
                return element.getAttribute("id");
            }
            ++n2;
        }
        return configElements.length != 0 ? configElements[0].getAttribute("id") : null;
    }

    @Override
    public boolean isToggleBpEnabled(IResource resource, int start, int end, int line) {
        return this.getComponentAstAtLine(resource, line) != null;
    }

    @Override
    public MWEBreakpoint createBreakpoint(IResource resource, int start, int end, int line) throws CoreException {
        ComponentAST comp = this.getComponentAstAtLine(resource, line);
        if (comp == null) {
            return null;
        }
        return new MWEBreakpoint(resource, this.getElementName(comp), comp.getLineNumber(), comp.getOffset(), comp.getLength());
    }

    @Override
    public IBreakpoint checkBreakpoints(IBreakpoint[] bps, IResource resource, int start, int end, int line) throws CoreException {
        ComponentAST comp = this.getComponentAstAtLine(resource, line);
        if (comp == null) {
            return null;
        }
        Location loc = this.locationAnalyser.adapt(comp.getLocation());
        IBreakpoint[] iBreakpointArray = bps;
        int n = bps.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp1 = iBreakpointArray[n2];
            MWEBreakpoint bp = (MWEBreakpoint)bp1;
            if (bp.getResource().equals(resource.getFullPath().toString()) && bp.getLine() == loc.getLineNumber() && bp.getCharStart() == loc.getNameStart() && bp.getCharEnd() == loc.getNameEnd()) {
                return bp;
            }
            ++n2;
        }
        return null;
    }

    private ComponentAST getComponentAstAtLine(IResource resource, int lineNumber) {
        HashMap params;
        IssuesImpl issues;
        IPath path = resource.getFullPath();
        WorkflowFactory factory = new WorkflowFactory();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        String wfFileName = file.getLocation().toString();
        AbstractASTBase wfAST = factory.parseAndInitialize(wfFileName, (Issues)(issues = new IssuesImpl()), params = new HashMap());
        if (wfAST != null && wfAST instanceof ComponentAST) {
            List candidates = ((ComponentAST)wfAST).getChildren();
            AbstractASTBase candidate = null;
            Location loc = null;
            for (AbstractASTBase next : candidates) {
                loc = this.locationAnalyser.adapt(next.getLocation());
                next.setLocation(loc);
                if (loc.getLineNumber() > lineNumber && candidate instanceof ComponentAST) {
                    return (ComponentAST)candidate;
                }
                candidate = next;
            }
            if (candidate instanceof ComponentAST) {
                return (ComponentAST)candidate;
            }
        }
        return null;
    }

    private String getElementName(ComponentAST ast) {
        if (ast.getId() != null) {
            return ast.getId();
        }
        if (ast instanceof InclusionAST) {
            return ((InclusionAST)ast).getFile();
        }
        String clazz = new Path(ast.getClazz()).getFileExtension();
        if (clazz != null) {
            return clazz;
        }
        return ast.getClazz();
    }

    @Override
    public Image getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        Path path = new Path("/icons/workflowfile.gif");
        InputStream is = null;
        try {
            is = FileLocator.openStream((Bundle)Activator.getDefault().getBundle(), (IPath)path, (boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (is != null) {
            ImageData iData = new ImageData(is);
            this.icon = new Image((Device)Display.getCurrent(), iData);
            return this.icon;
        }
        return null;
    }
}

