/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.factory;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.mwe2.language.factory.ISetting;
import org.eclipse.emf.mwe2.language.factory.ISettingProvider;
import org.eclipse.emf.mwe2.language.scoping.IInjectableFeatureLookup;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.JavaReflectAccess;
import org.eclipse.xtext.naming.QualifiedName;

public class SettingProviderImpl
implements ISettingProvider {
    private IInjectableFeatureLookup injectableFeatureLookup;
    private JavaReflectAccess reflectAccess;

    @Inject
    public void setReflectAccess(JavaReflectAccess reflectAccess) {
        this.reflectAccess = reflectAccess;
    }

    @Inject
    public void setInjectableFeatureLookup(IInjectableFeatureLookup injectableFeatureLookup) {
        this.injectableFeatureLookup = injectableFeatureLookup;
    }

    @Override
    public Map<QualifiedName, ISetting> getSettings(final Object obj, JvmType type) {
        Map<QualifiedName, JvmFeature> features = this.injectableFeatureLookup.getInjectableFeatures(type);
        Iterable settings = Iterables.transform(features.entrySet(), (Function)new Function<Map.Entry<QualifiedName, JvmFeature>, ISetting>(){

            public ISetting apply(final Map.Entry<QualifiedName, JvmFeature> from) {
                if (from.getValue() instanceof JvmOperation) {
                    return new ISetting(){

                        @Override
                        public void setValue(Object value) {
                            Method method = SettingProviderImpl.this.reflectAccess.getMethod((JvmOperation)from.getValue());
                            try {
                                method.invoke(obj, value);
                            }
                            catch (Exception e) {
                                throw new WrappedException(e);
                            }
                        }

                        @Override
                        public QualifiedName getName() {
                            return (QualifiedName)from.getKey();
                        }
                    };
                }
                if (from.getValue() instanceof JvmField) {
                    return new ISetting(){

                        @Override
                        public void setValue(Object value) {
                            Field field = SettingProviderImpl.this.reflectAccess.getField((JvmField)from.getValue());
                            try {
                                field.set(obj, value);
                            }
                            catch (Exception e) {
                                throw new WrappedException(e);
                            }
                        }

                        @Override
                        public QualifiedName getName() {
                            return (QualifiedName)from.getKey();
                        }
                    };
                }
                throw new IllegalArgumentException(String.valueOf(from.getValue().getIdentifier()) + " can not be handled.");
            }
        });
        return Maps.uniqueIndex((Iterable)settings, (Function)new Function<ISetting, QualifiedName>(){

            public QualifiedName apply(ISetting from) {
                return from.getName();
            }
        });
    }
}

