/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.clone;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinAttributeNode;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinEdge;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraph;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraphElement;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinNode;
import org.jgrapht.Graph;
import org.jgrapht.alg.isomorphism.VF2GraphIsomorphismInspector;
import org.jgrapht.graph.DefaultDirectedGraph;

public class JGraphTIsomorphyChecker {
    public boolean checkIsomorphyWithMultiEdges(Collection<HenshinGraph> clones) {
        HenshinGraph first = clones.iterator().next();
        for (HenshinGraph current : clones) {
            if (current == first || this.checkIsomorphyWithMultiEdges(first, current)) continue;
            return false;
        }
        return true;
    }

    private boolean checkIsomorphyWithMultiEdges(HenshinGraph g1, HenshinGraph g2) {
        DefaultDirectedGraph g1_ = new DefaultDirectedGraph(HenshinEdge.class);
        DefaultDirectedGraph g2_ = new DefaultDirectedGraph(HenshinEdge.class);
        this.populate((DefaultDirectedGraph<HenshinGraphElement, HenshinEdge>)g1_, g1);
        this.populate((DefaultDirectedGraph<HenshinGraphElement, HenshinEdge>)g2_, g2);
        Comparator<HenshinGraphElement> nodeComparator = new Comparator<HenshinGraphElement>(){

            @Override
            public int compare(HenshinGraphElement o1, HenshinGraphElement o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return -1;
                }
                if (o1 instanceof HenshinNode && o2 instanceof HenshinNode ? ((HenshinNode)o1).getType() == ((HenshinNode)o2).getType() && ((HenshinNode)o1).getActionType() == ((HenshinNode)o2).getActionType() : (o1 instanceof HenshinEdge && o2 instanceof HenshinEdge ? ((HenshinEdge)o1).getType() == ((HenshinEdge)o2).getType() && ((HenshinEdge)o1).getActionType() == ((HenshinEdge)o2).getActionType() : o1 instanceof HenshinAttributeNode && o2 instanceof HenshinAttributeNode && ((HenshinAttributeNode)o1).getType() == ((HenshinAttributeNode)o2).getType() && ((HenshinAttributeNode)o1).getActionType() == ((HenshinAttributeNode)o2).getActionType() && ((HenshinAttributeNode)o1).getValue().equals(((HenshinAttributeNode)o2).getValue()))) {
                    return 0;
                }
                return -1;
            }
        };
        Comparator<HenshinEdge> edgeComparator = new Comparator<HenshinEdge>(){

            @Override
            public int compare(HenshinEdge o1, HenshinEdge o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return -1;
                }
                if (o1.getType() == o2.getType() && o1.getActionType() == o2.getActionType()) {
                    return 0;
                }
                return -1;
            }
        };
        VF2GraphIsomorphismInspector insp = new VF2GraphIsomorphismInspector((Graph)g1_, (Graph)g2_, (Comparator)nodeComparator, (Comparator)edgeComparator, false);
        return insp.isomorphismExists();
    }

    private void populate(DefaultDirectedGraph<HenshinGraphElement, HenshinEdge> g_, HenshinGraph g) {
        for (HenshinNode v1 : g.vertexSet()) {
            g_.addVertex((Object)v1);
        }
        for (HenshinNode v1 : g.vertexSet()) {
            for (HenshinNode v2 : g.vertexSet()) {
                for (HenshinEdge e : g.getAllEdges(v1, v2)) {
                    g_.addVertex((Object)e);
                    g_.addEdge((Object)v1, (Object)e, (Object)e);
                    g_.addEdge((Object)e, (Object)v2, (Object)new HenshinEdge(e.getHenshinGraph(), e.getType(), e.getActionType(), e.getRuleName(), false));
                }
            }
        }
    }
}

