/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.unitTest;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;
import org.eclipse.emf.henshin.multicda.cda.dependency.DependencyReason;
import org.eclipse.emf.henshin.multicda.cda.framework.CdaWorker;
import org.eclipse.emf.henshin.multicda.cda.framework.CpaWorker;
import org.eclipse.emf.henshin.multicda.cda.framework.Options;
import org.eclipse.emf.henshin.multicda.cda.framework.ResultCreator;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.Span;
import org.eclipse.emf.henshin.multicda.cpa.result.CriticalPair;
import org.junit.AfterClass;
import org.junit.Test;

public class CompleteTest {
    private static CdaWorker cda;
    private static CpaWorker cpa;
    private static String henshin;
    private static Options options;
    private static boolean execute;
    private static long time;

    static {
        henshin = "testData/jevsTests/complete.henshin";
        options = new Options(4, new int[0]);
        execute = true;
        time = 0L;
    }

    @AfterClass
    public static void results() {
        System.out.println("Finished...");
    }

    @Test
    public void testOne() {
        execute = false;
        if (!execute) {
            int i = 0;
            while (i < 1) {
                CompleteTest.computeReasons();
                ++i;
            }
            System.out.println(CompleteTest.time(time /= 20L));
        } else {
            options.remove(64);
            options.remove(32);
        }
    }

    private static String time(long time) {
        long milis = time % 1000L;
        long seconds = time / 1000L % 60L;
        long minutes = time / 60000L % 60L;
        long hours = time / 3600000L % 24L;
        long days = time / 86400000L % 365L;
        long years = time / 31536000000L;
        return String.valueOf(years == 0L ? "" : String.valueOf(years) + "y, ") + (days == 0L ? "" : String.valueOf(days) + "d, ") + (hours == 0L ? "" : String.valueOf(hours) + "h, ") + (minutes == 0L ? "" : String.valueOf(minutes) + "m, ") + seconds + "s, " + milis + "ms";
    }

    private static Set<Span> computeReasons() {
        String r1 = "d2";
        String r2 = "d2";
        henshin = "testData/main/test.henshin";
        TreeSet<Span> cdaResult = new TreeSet<Span>();
        HashSet<CriticalPair> cpaResult = new HashSet<CriticalPair>();
        boolean executeAll = false;
        boolean executeCpa = false;
        boolean dependency = true;
        boolean compare = false;
        if (executeAll) {
            options.remove(64, 32);
        }
        options.remove(1);
        long cdaTime = System.currentTimeMillis();
        cda = executeAll ? new CdaWorker(henshin, options) : new CdaWorker(henshin, r1, r2, options);
        cda.print();
        cdaTime = System.currentTimeMillis() - cdaTime;
        cdaResult.addAll(cda.getAtoms());
        cdaResult.addAll(cda.getMinimalReasons());
        cdaResult.addAll(cda.getResult());
        long cpaTime = System.currentTimeMillis();
        if (executeCpa) {
            cpa = executeAll ? new CpaWorker(henshin, options) : new CpaWorker(henshin, new String[]{r1}, new String[]{r2}, options);
            cpaTime = System.currentTimeMillis() - cpaTime;
            cpaResult.addAll(cpa.getResult());
        }
        if (compare) {
            cda.compare(cpa.getResult(), new boolean[0]);
        }
        ResultCreator.create(cda, "Conflicts");
        if (dependency) {
            System.out.println("----------------------------------------------------------------");
            options.add(1);
            long tempTime = System.currentTimeMillis();
            cda = executeAll ? new CdaWorker(henshin, options) : new CdaWorker(henshin, r1, r2, options);
            cdaTime += System.currentTimeMillis() - tempTime;
            cdaResult.addAll(cda.getAtoms());
            cdaResult.addAll(cda.getResult());
            cdaResult.addAll(cda.getMinimalReasons());
            if (executeCpa) {
                tempTime = System.currentTimeMillis();
                cpa = executeAll ? new CpaWorker(henshin, options) : new CpaWorker(henshin, new String[]{r1}, new String[]{r2}, options);
                cdaTime += System.currentTimeMillis() - tempTime;
                cpaResult.addAll(cpa.getResult());
            }
            ResultCreator.create(cda, "Dependencies");
        }
        System.out.println("Reasons found: " + cdaResult.size());
        if (executeCpa) {
            System.out.println("Critical Pairs found: " + cpaResult.size());
        }
        if (compare) {
            cda.compare(cpa.getResult(), new boolean[0]);
        }
        System.out.println("\nCDA Time: " + CompleteTest.time(cdaTime));
        time += cdaTime;
        if (executeCpa) {
            System.out.println("CPA Time: " + CompleteTest.time(cpaTime));
        }
        System.out.println();
        System.out.println("______________________________________________________________________________");
        return cdaResult;
    }

    private static void test(Atom a) {
        TreeSet<Span> s = new TreeSet<Span>();
        s.add(new Atom.DeleteConflictAtom(a));
        s.add(new Atom.CreateConflictAtom(a));
        s.add(new Atom.ChangeConflictAtom(a));
        s.add(new Atom.CreateDependencyAtom(a));
        s.add(new Atom.DeleteDependencyAtom(a));
        s.add(new Atom.ChangeDependencyAtom(a));
        s.add((Span)new Atom.DeleteConflictAtom(a).setForbid(true));
        s.add((Span)new Atom.CreateConflictAtom(a).setForbid(true));
        s.add((Span)new Atom.ChangeConflictAtom(a).setForbid(true));
        s.add((Span)new Atom.CreateDependencyAtom(a).setForbid(true));
        s.add((Span)new Atom.DeleteDependencyAtom(a).setForbid(true));
        s.add((Span)new Atom.ChangeDependencyAtom(a).setForbid(true));
        s.add((Span)new Atom.DeleteConflictAtom(a).setRequire(true));
        s.add((Span)new Atom.CreateConflictAtom(a).setRequire(true));
        s.add((Span)new Atom.ChangeConflictAtom(a).setRequire(true));
        s.add((Span)new Atom.CreateDependencyAtom(a).setRequire(true));
        s.add((Span)new Atom.DeleteDependencyAtom(a).setRequire(true));
        s.add((Span)new Atom.ChangeDependencyAtom(a).setRequire(true));
        s.add(new ConflictReason.DeleteConflictReason(a).setMinimalReason(true));
        s.add(new ConflictReason.CreateConflictReason(a).setMinimalReason(true));
        s.add(new ConflictReason.ChangeConflictReason(a).setMinimalReason(true));
        s.add(new DependencyReason.CreateDependencyReason(a).setMinimalReason(true));
        s.add(new DependencyReason.DeleteDependencyReason(a).setMinimalReason(true));
        s.add(new DependencyReason.ChangeDependencyReason(a).setMinimalReason(true));
        s.add((Span)new ConflictReason.DeleteConflictReason(a).setMinimalReason(true).setForbid(true));
        s.add((Span)new ConflictReason.CreateConflictReason(a).setMinimalReason(true).setForbid(true));
        s.add((Span)new ConflictReason.ChangeConflictReason(a).setMinimalReason(true).setForbid(true));
        s.add((Span)new DependencyReason.CreateDependencyReason(a).setMinimalReason(true).setForbid(true));
        s.add((Span)new DependencyReason.DeleteDependencyReason(a).setMinimalReason(true).setForbid(true));
        s.add((Span)new DependencyReason.ChangeDependencyReason(a).setMinimalReason(true).setForbid(true));
        s.add((Span)new ConflictReason.DeleteConflictReason(a).setMinimalReason(true).setRequire(true));
        s.add((Span)new ConflictReason.CreateConflictReason(a).setMinimalReason(true).setRequire(true));
        s.add((Span)new ConflictReason.ChangeConflictReason(a).setMinimalReason(true).setRequire(true));
        s.add((Span)new DependencyReason.CreateDependencyReason(a).setMinimalReason(true).setRequire(true));
        s.add((Span)new DependencyReason.DeleteDependencyReason(a).setMinimalReason(true).setRequire(true));
        s.add((Span)new DependencyReason.ChangeDependencyReason(a).setMinimalReason(true).setRequire(true));
        s.add(new ConflictReason.DeleteConflictReason(a));
        s.add(new ConflictReason.CreateConflictReason(a));
        s.add(new ConflictReason.ChangeConflictReason(a));
        s.add(new DependencyReason.CreateDependencyReason(a));
        s.add(new DependencyReason.DeleteDependencyReason(a));
        s.add(new DependencyReason.ChangeDependencyReason(a));
        s.add((Span)new ConflictReason.DeleteConflictReason(a).setForbid(true));
        s.add((Span)new ConflictReason.CreateConflictReason(a).setForbid(true));
        s.add((Span)new ConflictReason.ChangeConflictReason(a).setForbid(true));
        s.add((Span)new DependencyReason.CreateDependencyReason(a).setForbid(true));
        s.add((Span)new DependencyReason.DeleteDependencyReason(a).setForbid(true));
        s.add((Span)new DependencyReason.ChangeDependencyReason(a).setForbid(true));
        s.add((Span)new ConflictReason.DeleteConflictReason(a).setRequire(true));
        s.add((Span)new ConflictReason.CreateConflictReason(a).setRequire(true));
        s.add((Span)new ConflictReason.ChangeConflictReason(a).setRequire(true));
        s.add((Span)new DependencyReason.CreateDependencyReason(a).setRequire(true));
        s.add((Span)new DependencyReason.DeleteDependencyReason(a).setRequire(true));
        s.add((Span)new DependencyReason.ChangeDependencyReason(a).setRequire(true));
        CdaWorker.print(s, new boolean[0]);
    }
}

