/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.runner.pullback;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.runner.pullback.LoggerPB;

public class ConflictAtomLoggerPB
extends LoggerPB {
    private static DateFormat dateFormat = new SimpleDateFormat("yy_MM_dd-HHmmss");
    String[][] runtimeResults;
    String[][] numberOfDeleteUseConflicts;
    Map<Rule, Integer> rowPositionOfRule;
    Map<Rule, Integer> columnPositionOfRule;
    int numberOfRules;
    boolean addDetailsOnRuleName = false;
    String totalRunTimes;
    String totalResults;

    @Override
    public void init(int numberOfRules) {
        this.runtimeResults = new String[numberOfRules + 3][numberOfRules + 3];
        this.numberOfDeleteUseConflicts = new String[numberOfRules + 3][numberOfRules + 3];
        this.rowPositionOfRule = new HashMap<Rule, Integer>();
        this.columnPositionOfRule = new HashMap<Rule, Integer>();
        this.numberOfRules = numberOfRules + 1;
    }

    @Override
    public void setAnalysisKinds(boolean normal, boolean essential, boolean atomic) {
        String runtimeString = "";
        String deleteUseconflicts = "";
        StringBuffer sb = new StringBuffer("");
        if (normal) {
            sb.append("normalCPs");
        }
        if (sb.length() > 1 && essential) {
            sb.append("/");
        }
        if (essential) {
            sb.append("essentialCPs");
        }
        if (sb.length() > 1 && atomic) {
            sb.append(" / ");
        }
        if (atomic) {
            sb.append("conflictAtoms");
        }
        runtimeString = sb.toString();
        deleteUseconflicts = sb.toString();
        if (atomic) {
            deleteUseconflicts = deleteUseconflicts.concat(" / Candidates / Minimal Reasons");
        }
        this.runtimeResults[0][0] = "RUNTIME - " + runtimeString + "[ms]";
        this.numberOfDeleteUseConflicts[0][0] = "D-U-CONFLICTS - " + deleteUseconflicts;
    }

    @Override
    public void addData(Rule rule1, Rule rule2, String runtime, String results) {
        Integer rowPosition = this.rowPositionOfRule.get(rule1);
        if (rowPosition == null) {
            rowPosition = this.rowPositionOfRule.size() + 2;
            this.rowPositionOfRule.put(rule1, rowPosition);
            this.runtimeResults[rowPosition.intValue()][0] = rule1.getName();
            this.numberOfDeleteUseConflicts[rowPosition.intValue()][0] = rule1.getName();
            this.runtimeResults[rowPosition.intValue()][1] = runtime;
            this.numberOfDeleteUseConflicts[rowPosition.intValue()][1] = results;
        }
        Integer columnPosition = null;
        if (rule2 == null) {
            columnPosition = -2;
        } else {
            if (rule2 != null) {
                columnPosition = this.columnPositionOfRule.get(rule2);
            }
            if (columnPosition == null) {
                columnPosition = this.columnPositionOfRule.size() + 2;
                this.columnPositionOfRule.put(rule2, columnPosition);
                this.runtimeResults[0][columnPosition.intValue()] = rule2.getName();
                this.numberOfDeleteUseConflicts[0][columnPosition.intValue()] = rule2.getName();
                this.runtimeResults[1][columnPosition.intValue()] = runtime;
                this.numberOfDeleteUseConflicts[1][columnPosition.intValue()] = results;
            }
            this.runtimeResults[rowPosition.intValue()][columnPosition.intValue()] = runtime;
            this.numberOfDeleteUseConflicts[rowPosition.intValue()][columnPosition.intValue()] = results;
        }
    }

    @Override
    public void setAddDetailsOnRuleName(boolean addDetailsOnRuleName) {
        this.addDetailsOnRuleName = addDetailsOnRuleName;
    }

    private String analyseDetailsOfRule(Rule rule) {
        int numberOfLhsNodes = rule.getLhs().getNodes().size();
        int numberOfLhsEdges = rule.getLhs().getEdges().size();
        Action deleteAction = new Action(Action.Type.DELETE);
        EList deletionNodes = rule.getActionNodes(deleteAction);
        int numberOfDeletionNodes = deletionNodes.size();
        EList deletionEdges = rule.getActionEdges(deleteAction);
        int numberOfDeletionEdges = deletionEdges.size();
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("#LhsNode:");
        sb.append(numberOfLhsNodes);
        sb.append(" ,#LhsEdges:");
        sb.append(numberOfLhsEdges);
        sb.append(" ,#deleteNodes:");
        sb.append(numberOfDeletionNodes);
        sb.append(" ,#deleteEdges:");
        sb.append(numberOfDeletionEdges);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void exportStoredRuntimeToCSV(String targetFolder) {
        try {
            Date start = new Date();
            String filename = String.valueOf(targetFolder) + File.separator + dateFormat.format(start) + "_conflictAtoms-runtime.csv";
            FileWriter fw = new FileWriter(filename);
            int row = 0;
            while (row <= this.numberOfRules) {
                int column = 0;
                while (column <= this.numberOfRules) {
                    fw.append(this.runtimeResults[row][column]);
                    fw.append(";");
                    ++column;
                }
                fw.append("\n");
                ++row;
            }
            if (this.totalRunTimes != null) {
                fw.append(this.totalRunTimes);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportStoredConflictsToCSV(String targetFolder) {
        try {
            Date start = new Date();
            String filename = String.valueOf(targetFolder) + File.separator + dateFormat.format(start) + "_conflictAtoms.csv";
            FileWriter fw = new FileWriter(filename);
            int row = 0;
            while (row <= this.numberOfRules) {
                int column = 0;
                while (column <= this.numberOfRules) {
                    fw.append(this.numberOfDeleteUseConflicts[row][column]);
                    fw.append(";");
                    ++column;
                }
                fw.append("\n");
                ++row;
            }
            if (this.totalResults != null) {
                fw.append(this.totalResults);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addRunTimes(long totalNormalRuntime, long totalEssentialRuntime, long totalAtomicRuntime) {
        StringBuffer sb = new StringBuffer();
        sb.append("Total run times [ms]- normal CPA: ");
        sb.append(totalNormalRuntime);
        sb.append(" essential CPA: ");
        sb.append(totalEssentialRuntime);
        sb.append(" atomic CPA: ");
        sb.append(totalAtomicRuntime);
        this.totalRunTimes = sb.toString();
    }

    @Override
    public void addTotalResults(int totalNumberOfNormalCPs, int totalNumberOfEssentialCPs, int totalNumberOfAtomicCPs, int totalNumberOfConflictAtomCandidates, int totalNumberOfMinimalConflictReasons) {
        StringBuffer sb = new StringBuffer();
        sb.append("Total amount of rsults -");
        sb.append(" normal CPs: ");
        sb.append(totalNumberOfNormalCPs);
        sb.append(" essential CPs: ");
        sb.append(totalNumberOfEssentialCPs);
        sb.append(" conflict atoms: ");
        sb.append(totalNumberOfAtomicCPs);
        sb.append(" conflictAtomCandidates: ");
        sb.append(totalNumberOfConflictAtomCandidates);
        sb.append(" minimalConflictReasons: ");
        sb.append(totalNumberOfMinimalConflictReasons);
        this.totalResults = sb.toString();
    }
}

