/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.RuleApplicationImpl;
import org.eclipse.emf.henshin.interpreter.util.HenshinEGraph;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.multicda.cda.Pair;
import org.eclipse.emf.henshin.multicda.cda.Pushout;
import org.eclipse.emf.henshin.multicda.cda.ReasonFactory;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;
import org.eclipse.emf.henshin.multicda.cda.dependency.DependencyReason;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;
import org.eclipse.emf.henshin.multicda.cda.units.Span;
import org.eclipse.emf.henshin.multicda.cda.units.SymmetricReason;
import org.eclipse.emf.henshin.multicda.cpa.result.Conflict;
import org.eclipse.emf.henshin.multicda.cpa.result.CriticalElement;
import org.eclipse.emf.henshin.multicda.cpa.result.CriticalPair;
import org.eclipse.emf.henshin.multicda.cpa.result.Dependency;
import org.eclipse.emf.henshin.preprocessing.RulePair;

public abstract class Utils {
    private static final String INVERTED_TAG = "_Inv";
    private static HenshinFactory factory = HenshinFactory.eINSTANCE;
    private static final String NAC_TAG = "NAC";
    private static final String PAC_TAG = "PAC";
    private static Engine engine = new EngineImpl(new String[0]);

    public static Rule invertRule(Rule rule1) {
        EcoreUtil.Copier ruleC = new EcoreUtil.Copier();
        Rule invRule = (Rule)ruleC.copy((EObject)rule1);
        ruleC.copyReferences();
        String d = rule1.getDescription();
        invRule.setDescription(String.valueOf(d == null ? "" : d) + INVERTED_TAG);
        Graph newLhs = invRule.getRhs();
        Graph newRhs = invRule.getLhs();
        newLhs.setName("LHS");
        invRule.setLhs(newLhs);
        newRhs.setName("RHS");
        invRule.setRhs(newRhs);
        MappingList mappings = invRule.getMappings();
        for (Mapping mapping : mappings) {
            Node original = mapping.getOrigin();
            Node image = mapping.getImage();
            mapping.setImage(original);
            mapping.setOrigin(image);
        }
        return invRule;
    }

    public static Rule invertRuleForForbid(Rule rule1) {
        Rule invRule = Utils.invertRule(rule1);
        for (Node n : invRule.getRhs().getNodes()) {
            if (invRule.getMappings().getOrigin(n) != null) continue;
            Node lhsNode = HenshinFactory.eINSTANCE.createNode(invRule.getLhs(), n.getType(), n.getName());
            invRule.getMappings().add((Object)HenshinFactory.eINSTANCE.createMapping(lhsNode, n));
            for (Attribute a : n.getAttributes()) {
                HenshinFactory.eINSTANCE.createAttribute(lhsNode, a.getType(), a.getValue());
            }
        }
        for (Edge e : invRule.getRhs().getEdges()) {
            Node lhsSource = invRule.getMappings().getOrigin(e.getSource());
            Node lhsTarget = invRule.getMappings().getOrigin(e.getTarget());
            if (lhsSource.getOutgoing(e.getType(), lhsTarget) != null) continue;
            HenshinFactory.eINSTANCE.createEdge(lhsSource, lhsTarget, e.getType());
        }
        return invRule;
    }

    public static List<RulePair> prepareNonDeletingVersions(List<Rule> rules) {
        LinkedList<RulePair> copiesOfRulesWithoutDeletion = new LinkedList<RulePair>();
        Iterator<Rule> iterator = rules.iterator();
        while (iterator.hasNext()) {
            Rule nonDelete;
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            Rule delete = iterator.next();
            String d = (nonDelete = (Rule)copier.copy((EObject)delete)).getDescription();
            nonDelete.setDescription(String.valueOf(d == null ? "" : d) + "_NonDelete");
            copier.copyReferences();
            for (Node n : nonDelete.getActionNodes(new Action(Action.Type.DELETE))) {
                Node image = HenshinFactory.eINSTANCE.createNode(nonDelete.getRhs(), n.getType(), n.getName());
                nonDelete.getMappings().add((Object)HenshinFactory.eINSTANCE.createMapping(n, image));
            }
            Map<Node, Set<Pair<Attribute, Attribute>>> nodes = Utils.getAttributeChanges(nonDelete);
            for (Node node : nodes.keySet()) {
                Set<Pair<Attribute, Attribute>> attributes = nodes.get(node);
                for (Pair<Attribute, Attribute> attribute : attributes) {
                    if (attribute.second != null) continue;
                    HenshinFactory.eINSTANCE.createAttribute(nonDelete.getMappings().getImage(node, null), ((Attribute)attribute.first).getType(), ((Attribute)attribute.first).getValue());
                }
            }
            for (Edge e : nonDelete.getActionEdges(new Action(Action.Type.DELETE))) {
                Node s = nonDelete.getMappings().getImage(e.getSource(), null);
                Node t = nonDelete.getMappings().getImage(e.getTarget(), null);
                nonDelete.getRhs().getEdges().add((Object)HenshinFactory.eINSTANCE.createEdge(s, t, e.getType()));
            }
            copiesOfRulesWithoutDeletion.add(new RulePair(nonDelete, delete));
        }
        return copiesOfRulesWithoutDeletion;
    }

    public static List<Rule> prepareNoneDeletingsVersionsRules(List<Rule> rules) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        List<RulePair> pairs = Utils.prepareNonDeletingVersions(rules);
        for (RulePair rulePair : pairs) {
            result.add(rulePair.getCopy());
        }
        return result;
    }

    public static Rule nonDeleteRule(Rule rule) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        result.add(rule);
        List<RulePair> pairs = Utils.prepareNonDeletingVersions(result);
        return pairs.get(0).getCopy();
    }

    public static Set<Rule> createNACRules(Rule rule1) {
        return Utils.getNestedRules(rule1, true);
    }

    public static Set<Rule> createPACRules(Rule rule1) {
        return Utils.getNestedRules(rule1, false);
    }

    public static Set<Rule> getNestedRules(Rule rule, boolean isNac) {
        int id = 0;
        int nodeId = 0;
        HashSet<Rule> result = new HashSet<Rule>();
        for (NestedCondition nac : isNac ? rule.getLhs().getNACs() : rule.getLhs().getPACs()) {
            Node target;
            Node source;
            Rule ncRule = factory.createRule(rule.getName());
            String d = ncRule.getDescription();
            String nested = PAC_TAG;
            if (isNac) {
                nested = NAC_TAG;
            }
            ncRule.setDescription(String.valueOf(d == null ? "" : d) + "_" + nested + "rule_" + id++);
            EcoreUtil.Copier cL = new EcoreUtil.Copier();
            Graph newLhs = (Graph)cL.copy((EObject)rule.getLhs());
            cL.copyReferences();
            if (isNac) {
                newLhs = factory.createGraph();
            }
            newLhs.setDescription(": this is the " + nested + " of the Original Rule");
            EcoreUtil.Copier cR = new EcoreUtil.Copier();
            Graph newRhs = (Graph)cR.copy((EObject)rule.getRhs());
            cR.copyReferences();
            if (isNac) {
                newRhs = factory.createGraph();
            }
            newRhs.setDescription(": this is the " + nested + " of the Original Rule");
            ncRule.setLhs(newLhs);
            ncRule.setRhs(newRhs);
            HashMap<Parameter, Parameter> parameterMap = new HashMap<Parameter, Parameter>();
            for (Parameter p : rule.getParameters()) {
                parameterMap.put(p, factory.createParameter(p.getName()));
                ncRule.getParameters().add((Object)((Parameter)parameterMap.get(p)));
            }
            for (ParameterMapping pm : rule.getParameterMappings()) {
                ParameterMapping pM = factory.createParameterMapping();
                pM.setSource((Parameter)parameterMap.get(pm.getSource()));
                pM.setTarget((Parameter)parameterMap.get(pm.getTarget()));
                ncRule.getParameterMappings().add((Object)pM);
            }
            HashMap<Node, Node> map = new HashMap<Node, Node>();
            if (isNac) {
                for (Node n : rule.getLhs().getNodes()) {
                    Node newLhsNode = factory.createNode(newLhs, n.getType(), n.getName());
                    Node newRhsNode = factory.createNode(newRhs, n.getType(), n.getName());
                    map.put(n, newLhsNode);
                    Mapping createdMapping = factory.createMapping(newLhsNode, newRhsNode);
                    ncRule.getMappings().add((Object)createdMapping);
                    ncRule.getMappings().add((Object)factory.createMapping(n, newLhsNode));
                }
            } else {
                for (Node n : rule.getLhs().getNodes()) {
                    Node newL = (Node)cL.get((Object)n);
                    Node nR = rule.getMappings().getImage(n, null);
                    ncRule.getMappings().add((Object)factory.createMapping(n, newL));
                    map.put(n, newL);
                    if (nR == null) continue;
                    Node newR = (Node)cR.get((Object)nR);
                    ncRule.getMappings().add((Object)factory.createMapping(newL, newR));
                }
            }
            for (Edge e : rule.getLhs().getEdges()) {
                source = (Node)map.get(e.getSource());
                target = (Node)map.get(e.getTarget());
                if (source == null || target == null || source.getOutgoing(e.getType(), target) != null) continue;
                factory.createEdge(source, target, e.getType());
                factory.createEdge(ncRule.getMappings().getImage(source, null), ncRule.getMappings().getImage(target, null), e.getType());
            }
            for (Node fn : nac.getConclusion().getNodes()) {
                Node fOrigin = nac.getMappings().getOrigin(fn);
                Node FNL = null;
                Node FNR = null;
                if (fOrigin != null) {
                    FNL = (Node)map.get(fOrigin);
                    FNR = ncRule.getMappings().getImage(FNL, null);
                } else {
                    char type = isNac ? (char)'f' : 'r';
                    String name = fn.getName();
                    if (name == null) {
                        name = "|" + type + nodeId + "|";
                        ++nodeId;
                    }
                    FNL = factory.createNode(newLhs, fn.getType(), name);
                    FNR = factory.createNode(newRhs, fn.getType(), name);
                    Mapping createdMapping = factory.createMapping(FNL, FNR);
                    ncRule.getMappings().add((Object)createdMapping);
                }
                map.put(fn, FNL);
                if (isNac) continue;
                for (Attribute a : fn.getAttributes()) {
                    if (FNL.getAttribute(a.getType()) != null) continue;
                    factory.createAttribute(FNL, a.getType(), a.getValue());
                    factory.createAttribute(FNR, a.getType(), a.getValue());
                }
            }
            for (Edge fe : nac.getConclusion().getEdges()) {
                source = (Node)map.get(fe.getSource());
                target = (Node)map.get(fe.getTarget());
                if (source == null || target == null || source.getOutgoing(fe.getType(), target) != null) continue;
                factory.createEdge(source, target, fe.getType());
                if (ncRule.getMappings().getImage(source, null) == null || ncRule.getMappings().getImage(target, null) == null) continue;
                factory.createEdge(ncRule.getMappings().getImage(source, null), ncRule.getMappings().getImage(target, null), fe.getType());
            }
            result.add(ncRule);
        }
        return result;
    }

    public static Node addNodeToGraph(Node nodeInRule1, Node nodeInRule2, Graph S1, Set<Mapping> rule1Mappings, Set<Mapping> rule2Mappings) {
        EClass subNodeType = Utils.identifySubNodeType(nodeInRule1, nodeInRule2);
        Node commonNode = factory.createNode(S1, subNodeType, String.valueOf(nodeInRule1.getName()) + "_" + nodeInRule2.getName());
        rule1Mappings.add(factory.createMapping(commonNode, nodeInRule1));
        rule2Mappings.add(factory.createMapping(commonNode, nodeInRule2));
        return commonNode;
    }

    public static boolean nodeTypeEqual(Node node1, Node node2) {
        return Utils.identifySubNodeType(node1, node2) != null;
    }

    public static EClass identifySubNodeType(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return null;
        }
        if (node1.getType() == node2.getType() || node1.getType().getEAllSuperTypes().contains((Object)node2.getType())) {
            return node1.getType();
        }
        if (node2.getType().getEAllSuperTypes().contains((Object)node1.getType())) {
            return node2.getType();
        }
        return null;
    }

    public static void checkNull(Object o) throws IllegalArgumentException {
        Utils.checkNull(o, "object");
    }

    public static void checkNull(Object o, String name) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " must not be null");
        }
    }

    public boolean isRuleSupported(Rule rule) {
        if (rule.getMultiRules().size() > 0 && rule.getLhs().getPACs().size() > 0) {
            throw new RuntimeException("positive application conditions (PAC) are not supported");
        }
        return true;
    }

    public static void removeRedundantNodes(Graph graph2Copy, Collection<Mapping> mappingsS2Rule1Copies, Collection<Mapping> mappingsS2Rule2Copies, List<Node> toDeleteInG2Copy) {
        LinkedList<Mapping> toDeleteMappingsToRule1 = new LinkedList<Mapping>();
        for (Mapping mapS2ToRule1 : mappingsS2Rule1Copies) {
            if (!toDeleteInG2Copy.contains(mapS2ToRule1.getOrigin())) continue;
            toDeleteMappingsToRule1.add(mapS2ToRule1);
        }
        mappingsS2Rule1Copies.removeAll(toDeleteMappingsToRule1);
        LinkedList<Mapping> mappingsInRule2ToRemove = new LinkedList<Mapping>();
        for (Mapping mappingOfSpan2InRule2 : mappingsS2Rule2Copies) {
            if (!toDeleteInG2Copy.contains(mappingOfSpan2InRule2.getOrigin())) continue;
            mappingsInRule2ToRemove.add(mappingOfSpan2InRule2);
        }
        mappingsS2Rule2Copies.removeAll(mappingsInRule2ToRemove);
        graph2Copy.getNodes().removeAll(toDeleteInG2Copy);
    }

    public static Map<Node, Node> getS2toS1Map(Reason span1, Reason span2) {
        HashMap<Node, Node> s2ToS1 = new HashMap<Node, Node>();
        for (Node n1 : span1.getGraph().getNodes()) {
            for (Node n2 : span2.getGraph().getNodes()) {
                boolean sameImageInRule2;
                if (Utils.identifySubNodeType(n1, n2) == null) continue;
                boolean sameImageInRule1 = span1.getMappingIntoRule1(n1).getImage() == span2.getMappingIntoRule1(n2).getImage();
                boolean bl = sameImageInRule2 = span1.getMappingIntoRule2(n1).getImage() == span2.getMappingIntoRule2(n2).getImage();
                if (sameImageInRule1 && sameImageInRule2) {
                    s2ToS1.put(n2, n1);
                    continue;
                }
                if (!(sameImageInRule1 ^ sameImageInRule2)) continue;
                return null;
            }
        }
        return s2ToS1;
    }

    public static Map<CriticalPair, Reason> compare(Set<CriticalPair> cps, Set<Reason> reasons) {
        HashMap<CriticalPair, Reason> result = new HashMap<CriticalPair, Reason>();
        if (reasons == null || cps == null) {
            return result;
        }
        block0: for (CriticalPair cp : cps) {
            for (Reason reason : reasons) {
                boolean foundElement = false;
                if (reason instanceof SymmetricReason) {
                    reason = ((SymmetricReason)reason).getS1();
                }
                if ((!(cp instanceof Conflict) || !(reason instanceof ConflictReason)) && (!(cp instanceof Dependency) || !(reason instanceof DependencyReason))) continue;
                List delCE = cp.getCriticalElements();
                Set<GraphElement> delRE = reason.getDeletionElementsInRule1_2();
                if (delCE.size() == delRE.size()) {
                    block2: for (GraphElement d1 : delRE) {
                        foundElement = false;
                        for (CriticalElement d2 : delCE) {
                            if (!(d1 instanceof Node && d2.elementInFirstRule instanceof Node || d1 instanceof Node && d2.elementInFirstRule instanceof Attribute) && (!(d1 instanceof Edge) || !(d2.elementInFirstRule instanceof Edge)) || !d1.toString().equals(d2.toString())) continue;
                            foundElement = true;
                            continue block2;
                        }
                    }
                }
                if (!foundElement) continue;
                result.put(cp, reason);
                continue block0;
            }
        }
        return result;
    }

    public static Set<DanglingEdge> findDanglingEdgesOfRule1(Rule rule, List<Mapping> embedding) {
        HashMap<Node, Node> mapL1toG = new HashMap<Node, Node>();
        HashMap<Node, Node> mapGtoL1 = new HashMap<Node, Node>();
        for (Mapping mapping : embedding) {
            mapL1toG.put(mapping.getOrigin(), mapping.getImage());
            mapGtoL1.put(mapping.getImage(), mapping.getOrigin());
        }
        HashSet<DanglingEdge> danglingEdges = new HashSet<DanglingEdge>();
        EList l1DeletingNodes = rule.getActionNodes(new Action(Action.Type.DELETE));
        for (Node l1Deleting : l1DeletingNodes) {
            int parallelLhs1;
            int parallelPO;
            Node poDeleting = (Node)mapL1toG.get(l1Deleting);
            for (Edge edgePO : poDeleting.getOutgoing()) {
                Node l1DelTarget = (Node)mapGtoL1.get(edgePO.getTarget());
                parallelPO = Utils.getParallelEdges(poDeleting, edgePO.getTarget(), edgePO.getType()).size();
                parallelLhs1 = Utils.getParallelEdges(l1Deleting, l1DelTarget, edgePO.getType()).size();
                if (l1DelTarget == null) {
                    danglingEdges.add(new DanglingEdge(edgePO, DanglingCase.targetDangling));
                    continue;
                }
                if (parallelLhs1 >= parallelPO) continue;
                danglingEdges.add(new DanglingEdge(edgePO, DanglingCase.unspecifiedEdge));
            }
            for (Edge edgePO : poDeleting.getIncoming()) {
                Node l1DelSource = (Node)mapGtoL1.get(edgePO.getSource());
                parallelPO = Utils.getParallelEdges(edgePO.getSource(), poDeleting, edgePO.getType()).size();
                parallelLhs1 = Utils.getParallelEdges(l1DelSource, l1Deleting, edgePO.getType()).size();
                if (l1DelSource == null) {
                    danglingEdges.add(new DanglingEdge(edgePO, DanglingCase.sourceDangling));
                    continue;
                }
                if (parallelLhs1 >= parallelPO) continue;
                danglingEdges.add(new DanglingEdge(edgePO, DanglingCase.unspecifiedEdge));
            }
        }
        return danglingEdges;
    }

    public static Set<Edge> getParallelEdges(Node source, Node target, EReference type) {
        HashSet<Edge> result = new HashSet<Edge>();
        if (source == null || target == null) {
            return result;
        }
        for (Edge edge : source.getOutgoing()) {
            if (edge.getTarget() != target || edge.getType() != type) continue;
            result.add(edge);
        }
        return result;
    }

    public static EPackage graphToEPackage(Graph g) {
        HashSet<String> added = new HashSet<String>();
        EPackage result = EcoreFactory.eINSTANCE.createEPackage();
        result.setName(g.getName());
        result.setNsURI("http://cdapackage/" + g.getName());
        result.setNsPrefix("CDAPackage");
        EList classifiers = result.getEClassifiers();
        for (Node node : g.getNodes()) {
            EClass n = Utils.getSimpleClassifier(node);
            added.add(n.getName());
            classifiers.add((Object)n);
        }
        for (Edge edge : g.getEdges()) {
            EClass s = Utils.getSimpleClassifier(edge.getSource());
            EClass t = Utils.getSimpleClassifier(edge.getTarget());
            if (!added.contains(s.getName())) {
                classifiers.add((Object)s);
                added.add(s.getName());
            } else {
                s = (EClass)result.getEClassifier(s.getName());
            }
            if (!added.contains(t.getName())) {
                classifiers.add((Object)t);
                added.add(t.getName());
            } else {
                t = (EClass)result.getEClassifier(t.getName());
            }
            EReference ref = EcoreFactory.eINSTANCE.createEReference();
            ref.setName(edge.getType().getName());
            ref.setEType((EClassifier)t);
            s.getEStructuralFeatures().add((Object)ref);
        }
        return result;
    }

    public static EPackage spanToEPackage(Span r) {
        HashSet<String> added = new HashSet<String>();
        EPackage result = EcoreFactory.eINSTANCE.createEPackage();
        result.setName(String.valueOf(r.getRule1().getName()) + "_" + r.getRule2().getName());
        result.setNsURI("http://cdapackage/" + r.getRule1().getName() + "/" + r.getRule2().getName() + "/" + r.getClass().getSimpleName());
        result.setNsPrefix("CDAPackage");
        EList classifiers = result.getEClassifiers();
        Set<GraphElement> deletions = r.getDeletionElementsInRule1_2();
        for (Node node : r.getGraph().getNodes()) {
            EClass n = Utils.getClassifier(r, deletions, node);
            added.add(n.getName());
            classifiers.add((Object)n);
        }
        for (Edge edge : r.getGraph().getEdges()) {
            EClass s = Utils.getClassifier(r, deletions, edge.getSource());
            EClass t = Utils.getClassifier(r, deletions, edge.getTarget());
            if (!added.contains(s.getName())) {
                classifiers.add((Object)s);
                added.add(s.getName());
            } else {
                s = (EClass)result.getEClassifier(s.getName());
            }
            if (!added.contains(t.getName())) {
                classifiers.add((Object)t);
                added.add(t.getName());
            } else {
                t = (EClass)result.getEClassifier(t.getName());
            }
            EReference ref = EcoreFactory.eINSTANCE.createEReference();
            ref.setName(edge.getType().getName());
            if (!r.getRule1().getRhs().getEdges().contains((Object)edge)) {
                ref.setName("#" + ref.getName() + "#");
            }
            ref.setEType((EClassifier)t);
            s.getEStructuralFeatures().add((Object)ref);
        }
        return result;
    }

    public static EClass getSimpleClassifier(Node node) {
        EClass nodeClass = node.getType();
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName(String.valueOf(node.getName()) + ":" + nodeClass.getName());
        for (Attribute a : node.getAttributes()) {
            EcoreUtil.Copier cAttribute = new EcoreUtil.Copier();
            EAttribute at = (EAttribute)cAttribute.copy((EObject)a.getType());
            cAttribute.copyReferences();
            at.setName(String.valueOf(a.getType().getName()) + "=" + a.getValue());
            eclass.getEStructuralFeatures().add((Object)at);
        }
        return eclass;
    }

    public static EClass getClassifier(Span r, Set<GraphElement> deletions, Node node) {
        Attribute a2L;
        String name1;
        EClass nodeClass = node.getType();
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName(String.valueOf(node.getName()) + ":" + nodeClass.getName());
        Node image1L = r.getMappingIntoRule1(node).getImage();
        Node image2L = r.getMappingIntoRule2(node).getImage();
        Node image1R = r.getRule1().getMappings().getImage(image1L, null);
        Node image2R = r.getRule2().getMappings().getImage(image2L, null);
        for (Attribute a1L : image1L.getAttributes()) {
            Attribute a1R;
            name1 = "";
            name1 = image1R != null ? ((a1R = image1R.getAttribute(a1L.getType())) != null && a1L.getValue().equals(a1R.getValue()) ? a1L.getValue() : String.valueOf(a1L.getValue()) + "->" + (a1R == null ? " " : a1R.getValue())) : a1L.getValue();
            a2L = image2L.getAttribute(a1L.getType());
            String name2 = " ";
            if (image2R != null) {
                Attribute a2R = image2R.getAttribute(a1L.getType());
                name2 = a2R != null && a1L.getValue().equals(a2R.getValue()) ? a1L.getValue() : String.valueOf(a2L == null ? " " : a2L.getValue()) + "->" + (a2R == null ? " " : a2R.getValue());
            } else if (a2L != null) {
                name2 = a2L.getValue();
            }
            EcoreUtil.Copier cAttribute = new EcoreUtil.Copier();
            EAttribute at = (EAttribute)cAttribute.copy((EObject)a1L.getType());
            cAttribute.copyReferences();
            at.setName(String.valueOf(a1L.getType().getName()) + "=" + name1 + " " + "_" + " " + name2);
            eclass.getEStructuralFeatures().add((Object)at);
        }
        if (image1R != null) {
            for (Attribute a1R : image1R.getAttributes()) {
                if (image1L.getAttribute(a1R.getType()) != null) continue;
                name1 = " ->" + a1R.getValue();
                a2L = image2L.getAttribute(a1R.getType());
                Attribute a2R = image2R.getAttribute(a1R.getType());
                String name2 = String.valueOf(a2L == null ? " " : a2L.getValue()) + "->" + (a2R == null ? " " : a2R.getValue());
                EcoreUtil.Copier cAttribute = new EcoreUtil.Copier();
                EAttribute at = (EAttribute)cAttribute.copy((EObject)a1R.getType());
                cAttribute.copyReferences();
                at.setName(String.valueOf(a1R.getType().getName()) + "=" + name1 + " " + "_" + " " + name2);
                eclass.getEStructuralFeatures().add((Object)at);
            }
        }
        if (deletions.contains(node)) {
            eclass.setName("#" + eclass.getName() + "#");
        }
        return eclass;
    }

    public static boolean isNcRule(Rule rule, boolean ... nac) {
        Boolean n;
        String d = rule.getDescription();
        Boolean bl = n = nac.length == 0 ? null : Boolean.valueOf(nac[0]);
        if (d != null) {
            if (n == null && (d.contains(NAC_TAG) || d.contains(PAC_TAG))) {
                return true;
            }
            if (n != null && (n.booleanValue() && d.contains(NAC_TAG) || !n.booleanValue() && d.contains(PAC_TAG))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isRealNcNode(Node n) {
        if (n == null) {
            return false;
        }
        Rule r = n.getGraph().getRule();
        if (Utils.isNcRule(r, new boolean[0])) {
            Node origin;
            if (n.getGraph().isRhs()) {
                n = r.getMappings().getOrigin(n);
            }
            if ((origin = r.getMappings().getOrigin(n)) == null) {
                return true;
            }
            for (Attribute a : n.getAttributes()) {
                if (origin.getAttribute(a.getType()) != null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRealNcNode(Node n, boolean nac) {
        if (!Utils.isRealNcNode(n)) {
            return false;
        }
        Rule r = n.getGraph().getRule();
        return r.getDescription() != null && (nac && r.getDescription().contains(NAC_TAG) || !nac && r.getDescription().contains(PAC_TAG));
    }

    public static boolean isInverted(Rule rule) {
        String dsc = rule.getDescription();
        dsc = dsc == null ? "" : dsc;
        int parts = (dsc.length() - dsc.replaceAll(INVERTED_TAG, "").length()) / INVERTED_TAG.length();
        return parts % 2 == 1;
    }

    public static boolean attributesCheck(Span reason) {
        for (Mapping m : reason.getMappingsInRule1()) {
            Node n1L = m.getImage();
            Node n2L = reason.getMappingIntoRule2(m.getOrigin()).getImage();
            if (!(Utils.isInverted(reason.getRule1()) ? (Utils.isNcRule(reason.getRule2(), true) ? !Utils.strongAttributesCheck(n2L, n1L) : !Utils.attributesCheck(n2L, n1L)) : !Utils.attributesCheck(n1L, n2L))) continue;
            return false;
        }
        return true;
    }

    public static boolean attributesCheck(Node node1, Node node2) {
        if (Utils.identifySubNodeType(node1, node2) == null) {
            return false;
        }
        for (Attribute attr1L : node1.getAttributes()) {
            Attribute attr2L = node2.getAttribute(attr1L.getType());
            if (attr2L == null || Utils.equalAttributes(attr1L, attr2L)) continue;
            return false;
        }
        return true;
    }

    public static boolean strongAttributesCheck(Node node1, Node node2) {
        if (Utils.identifySubNodeType(node1, node2) == null) {
            return false;
        }
        for (Attribute attr1L : node1.getAttributes()) {
            Attribute attr2L;
            if (Utils.equalAttributes(attr1L, attr2L = node2.getAttribute(attr1L.getType()))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalAttributes(Attribute a1, Attribute a2) {
        if (a1 == null || a2 == null || a1.getType() != a2.getType()) {
            return false;
        }
        Rule r1 = a1.getNode().getGraph().getRule();
        Rule r2 = a2.getNode().getGraph().getRule();
        for (Parameter p : r1.getParameters()) {
            if (!p.getName().equals(a1.getValue())) continue;
            return true;
        }
        for (Parameter p : r2.getParameters()) {
            if (!p.getName().equals(a2.getValue())) continue;
            return true;
        }
        return a1.getValue().equals(a2.getValue());
    }

    public static Map<Node, Set<Pair<Attribute, Attribute>>> getAttributeChanges(Rule rule1) {
        HashMap<Node, Set<Pair<Attribute, Attribute>>> changeUse = new HashMap<Node, Set<Pair<Attribute, Attribute>>>();
        for (Node nL : rule1.getLhs().getNodes()) {
            Pair<Node, Set<Pair<Attribute, Attribute>>> attributes = Utils.getAttributeChanges(nL);
            if (attributes == null || ((Set)attributes.second).isEmpty()) continue;
            changeUse.put((Node)attributes.first, (Set)attributes.second);
        }
        return changeUse;
    }

    public static Pair<Node, Set<Pair<Attribute, Attribute>>> getAttributeChanges(Node node) {
        if (node.getGraph().isRhs()) {
            return null;
        }
        Pair<Node, Set<Pair<Attribute, Attribute>>> attributes = new Pair<Node, Set<Pair<Attribute, Attribute>>>(node, new HashSet());
        HashSet<Attribute> added = new HashSet<Attribute>();
        for (Attribute a : node.getActionAttributes(new Action(Action.Type.CREATE))) {
            ((Set)attributes.second).add(new Pair<Object, Attribute>(null, a));
            added.add(a);
        }
        for (Attribute a : node.getActionAttributes(new Action(Action.Type.DELETE))) {
            ((Set)attributes.second).add(new Pair<Attribute, Object>(a, null));
            added.add(a);
        }
        for (Attribute a1 : node.getAttributes()) {
            Attribute a2;
            if (added.contains(a1) || (a2 = node.getGraph().getRule().getMappings().getImage(node, null).getAttribute(a1.getType())) == null || a1.getValue().equals(a2.getValue())) continue;
            ((Set)attributes.second).add(new Pair<Attribute, Attribute>(a1, a2));
        }
        return attributes;
    }

    public static boolean haveCommonDeletionElement(Reason current, ConflictReason extensionCandidate) {
        Set<GraphElement> deletionElementsCand;
        Set<GraphElement> deletionElementsCur = current.getDeletionElementsInRule1();
        return !Collections.disjoint(deletionElementsCur, deletionElementsCand = extensionCandidate.getDeletionElementsInRule1());
    }

    public static Set<ConflictReason> computeMinimalConflictReasons(Reason current, Set<ConflictReason> remaining) {
        HashSet<ConflictReason> result = new HashSet<ConflictReason>();
        for (ConflictReason mcr : remaining) {
            ConflictReason initialReason;
            if (!mcr.isMinimalReason() || Utils.haveCommonDeletionElement(current, mcr) || (initialReason = ReasonFactory.eINSTANCE.createJoinedReason(current, mcr)) == null) continue;
            result.add(initialReason);
            result.addAll(Utils.computeMinimalConflictReasons(initialReason, remaining));
        }
        return result;
    }

    public static boolean checkNcReason(Span reason, Rule originalR1, Rule originalR2) {
        if (!Utils.containsNCElements(reason)) {
            return false;
        }
        if (Utils.validateCreateForbidReason(reason, originalR1, originalR2)) {
            return true;
        }
        Utils.extendPreservedPartsOfReason(reason);
        return Utils.validateCreateForbidReason(reason, originalR1, originalR2);
    }

    public static boolean validateCreateForbidReason(Span reason, Rule originalR1, Rule originalR2) {
        ArrayList<Mapping> H1G;
        List<Mapping> N2H1;
        HenshinEGraph g;
        Pushout pH = new Pushout(reason.getRule1(), reason, reason.getRule2());
        Graph H = pH.getResultGraph();
        if (Utils.checkSuperTypes(H)) {
            return false;
        }
        Pushout pG = new Pushout(reason.getRule1(), reason, reason.getRule2());
        Graph G = pG.getResultGraph();
        try {
            g = new HenshinEGraph(G);
        }
        catch (Exception exception) {
            return false;
        }
        RuleApplicationImpl app = new RuleApplicationImpl(engine);
        app.setEGraph((EGraph)g);
        app.setUnit((Unit)reason.getRule1());
        Match match = Utils.getMatch(pG.getRule1Mappings(), g, reason.getRule1());
        app.setCompleteMatch(match);
        if (!app.execute(null)) {
            return false;
        }
        Match comatch = app.getResultMatch();
        Set<Mapping> trace = Utils.getTrace(H, G);
        EcoreUtil.Copier c = new EcoreUtil.Copier();
        Graph GCopy = (Graph)c.copy((EObject)G);
        c.copyReferences();
        HenshinEGraph gCopy = new HenshinEGraph(GCopy);
        app.setEGraph((EGraph)gCopy);
        app.setUnit((Unit)originalR1);
        app.setPartialMatch(comatch);
        if (!app.execute(null)) {
            return false;
        }
        List<Mapping> L2N2 = Utils.getNacMappingsOfNacRule(reason.getRule2());
        List<Mapping> L2H1 = Utils.composeMappings(L2N2, N2H1 = pH.getRule2Mappings());
        List<Mapping> L2G = Utils.composeMappings(L2H1, H1G = new ArrayList<Mapping>(trace));
        if (L2G.size() != L2N2.size()) {
            return false;
        }
        try {
            g = new HenshinEGraph(G);
        }
        catch (Exception exception) {
            return false;
        }
        app.setEGraph((EGraph)g);
        app.setUnit((Unit)originalR2);
        match = Utils.getMatch(L2G, g, originalR2);
        app.setCompleteMatch(match);
        return app.execute(null);
    }

    public static boolean attributesDetected(Span reason) {
        for (Node n : reason.getRule1().getLhs().getNodes()) {
            if (n.getAttributes().isEmpty()) continue;
            return true;
        }
        for (Node n : reason.getRule2().getLhs().getNodes()) {
            if (n.getAttributes().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void deleteParameters(Graph g, Rule r1, Rule r2) {
        HashSet<Attribute> toRemove = new HashSet<Attribute>();
        if (!r1.getParameters().isEmpty()) {
            for (Node n : g.getNodes()) {
                for (Attribute a : n.getAttributes()) {
                    if (r1.getParameter(a.getValue()) == null) continue;
                    toRemove.add(a);
                }
                n.getAttributes().removeAll(toRemove);
                toRemove.clear();
            }
        }
        if (!r2.getParameters().isEmpty()) {
            for (Node n : g.getNodes()) {
                for (Attribute a : n.getAttributes()) {
                    if (r2.getParameter(a.getValue()) == null) continue;
                    toRemove.add(a);
                }
                n.getAttributes().removeAll(toRemove);
                toRemove.clear();
            }
        }
    }

    private static boolean checkSuperTypes(Graph graph) {
        for (Edge e : graph.getEdges()) {
            EClass typeB;
            EClass typeA = (EClass)e.getType().getEType();
            if (Utils.isSuper(typeA, typeB = e.getTarget().getType())) {
                return true;
            }
            typeB = e.getSource().getType();
            if (!Utils.isSuper(typeA, typeB)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSuper(EClass subClass, EClass superClass) {
        if (subClass.getESuperTypes().contains((Object)superClass)) {
            return true;
        }
        for (EClass eclass : subClass.getESuperTypes()) {
            if (!Utils.isSuper(eclass, superClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNCElements(Span reason) {
        for (Mapping map : reason.getMappingsInRule2()) {
            Node image = map.getImage();
            if (!Utils.isRealNcNode(image)) continue;
            return true;
        }
        for (Edge e : reason.getGraph().getEdges()) {
            Node source = reason.getMappingIntoRule2(e.getSource()).getImage();
            Node target = reason.getMappingIntoRule2(e.getTarget()).getImage();
            source = reason.getRule2().getMappings().getOrigin(source);
            target = reason.getRule2().getMappings().getOrigin(target);
            if (source.getOutgoing(e.getType(), target) != null) continue;
            return true;
        }
        return false;
    }

    public static void extendPreservedPartsOfReason(Span reason) {
        HashSet<Node> p1nodes = new HashSet<Node>();
        HashSet<Node> p2nodes = new HashSet<Node>();
        for (Node node : reason.getRule1().getActionNodes(new Action(Action.Type.PRESERVE))) {
            if (reason.getMappingFromGraphToRule1(node) != null) continue;
            p1nodes.add(node);
        }
        for (Node node : reason.getRule2().getLhs().getNodes()) {
            if (reason.getMappingFromGraphToRule2(node) != null || reason.getRule2().getMappings().getImage(node, null) == null) continue;
            p2nodes.add(node);
        }
        Map<Node, Node> maps = Utils.mapNodes(p1nodes, p2nodes, null, new boolean[0]);
        for (Node n : maps.keySet()) {
            Mapping source;
            Mapping target;
            Node n2 = maps.get(n);
            String name = String.valueOf(n.getName()) + "_" + n2.getName();
            if (reason.getGraph().getNode(name) != null) continue;
            Node reasonNode = HenshinFactory.eINSTANCE.createNode(reason.getGraph(), n.getType(), name);
            reason.getMappingsInRule1().add(HenshinFactory.eINSTANCE.createMapping(reasonNode, n));
            reason.getMappingsInRule2().add(HenshinFactory.eINSTANCE.createMapping(reasonNode, n2));
            for (Edge e : n.getOutgoing()) {
                if (e.getAction().getType() != Action.Type.PRESERVE || (target = reason.getMappingFromGraphToRule1(e.getTarget())) == null || reasonNode.getOutgoing(e.getType(), target.getOrigin()) != null) continue;
                HenshinFactory.eINSTANCE.createEdge(reasonNode, target.getOrigin(), e.getType());
            }
            for (Edge e : n.getIncoming()) {
                if (e.getAction().getType() != Action.Type.PRESERVE || (source = reason.getMappingFromGraphToRule1(e.getSource())) == null || source.getOrigin().getOutgoing(e.getType(), reasonNode) != null) continue;
                HenshinFactory.eINSTANCE.createEdge(source.getOrigin(), reasonNode, e.getType());
            }
            for (Edge e : n2.getOutgoing()) {
                if (e.getAction().getType() != Action.Type.PRESERVE || (target = reason.getMappingFromGraphToRule1(e.getTarget())) == null || reasonNode.getOutgoing(e.getType(), target.getOrigin()) != null) continue;
                HenshinFactory.eINSTANCE.createEdge(reasonNode, target.getOrigin(), e.getType());
            }
            for (Edge e : n2.getIncoming()) {
                if (e.getAction().getType() != Action.Type.PRESERVE || (source = reason.getMappingFromGraphToRule1(e.getSource())) == null || source.getOrigin().getOutgoing(e.getType(), reasonNode) != null) continue;
                HenshinFactory.eINSTANCE.createEdge(source.getOrigin(), reasonNode, e.getType());
            }
        }
    }

    private static Match getMatch(List<Mapping> neededMappings, HenshinEGraph g, Rule rule) {
        for (Match m : engine.findMatches(rule, (EGraph)g, null)) {
            if (m.getNodeTargets().size() != neededMappings.size()) continue;
            boolean found = true;
            for (Mapping mapping : neededMappings) {
                Node node = mapping.getOrigin();
                EObject graphNode = m.getNodeTarget(node);
                node = mapping.getImage();
                if (g.getObject2NodeMap().get(graphNode) == node) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return m;
        }
        return null;
    }

    private static List<Mapping> getNacMappingsOfNacRule(Rule r) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        for (Mapping m : r.getMappings()) {
            if (r.getLhs().getNodes().contains((Object)m.getOrigin())) continue;
            result.add(factory.createMapping(m.getOrigin(), m.getImage()));
        }
        return result;
    }

    public static List<Mapping> composeMappings(List<Mapping> map1, List<Mapping> map2) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        block0: for (Mapping m1 : map1) {
            for (Mapping m2 : map2) {
                if (m1.getImage() != m2.getOrigin()) continue;
                result.add(HenshinFactory.eINSTANCE.createMapping(m1.getOrigin(), m2.getImage()));
                continue block0;
            }
        }
        return result;
    }

    public static Set<Mapping> getTrace(Graph G, Graph H) {
        HashSet<Mapping> result = new HashSet<Mapping>();
        HashMap<Node, Node> map = new HashMap<Node, Node>();
        block0: for (Node nH : H.getNodes()) {
            for (Node nG : G.getNodes()) {
                if (nH.getName() == null || nG.getName() == null || map.get(nG) != null || !nH.getName().equals(nG.getName())) continue;
                map.put(nG, nH);
                result.add(HenshinFactory.eINSTANCE.createMapping(nG, nH));
                continue block0;
            }
        }
        return result;
    }

    private static Map<EClass, Set<Node>> classifyNodes(Set<Node> nodes) {
        HashMap<EClass, Set<Node>> result = new HashMap<EClass, Set<Node>>();
        for (Node n : nodes) {
            HashSet<Node> classNodes = (HashSet<Node>)result.get(n.getType());
            if (classNodes == null) {
                classNodes = new HashSet<Node>();
                result.put(n.getType(), classNodes);
            }
            classNodes.add(n);
        }
        return result;
    }

    public static Map<Node, Node> mapNodes(Set<Node> nodes1, Set<Node> nodes2, Map<Node, Node> result, boolean ... delete) {
        return Utils.mapNodes(nodes1, nodes2, nodes2, result, delete.length != 0 && delete[0]);
    }

    public static Map<Node, Node> mapNodes(Node nodes1, Node nodes2, Map<Node, Node> result, boolean ... delete) {
        HashSet<Node> n1 = new HashSet<Node>();
        HashSet<Node> n2 = new HashSet<Node>();
        n1.add(nodes1);
        n2.add(nodes2);
        return Utils.mapNodes(n1, n2, result, delete);
    }

    public static Map<Node, Node> mapNodes(Node nodes1, Set<Node> nodes2, Map<Node, Node> result, boolean ... delete) {
        HashSet<Node> n1 = new HashSet<Node>();
        n1.add(nodes1);
        return Utils.mapNodes(n1, nodes2, result, delete);
    }

    public static Map<Node, Node> mapNodes(Set<Node> nodes1, Node nodes2, Map<Node, Node> result, boolean ... delete) {
        HashSet<Node> n2 = new HashSet<Node>();
        n2.add(nodes2);
        return Utils.mapNodes(nodes1, n2, result, delete);
    }

    public static Map<Node, Node> mapNodes(Set<Node> nodesOriginal1, Set<Node> nodesOriginal2, Set<Node> nodes2, Map<Node, Node> result, boolean allActionTypes) {
        if (result == null) {
            result = new HashMap<Node, Node>();
        }
        for (Node n2 : nodes2) {
            for (Node n1 : nodesOriginal1) {
                boolean foundEdge;
                EList e1;
                if (result.get(n1) != null || !Utils.strongAttributesCheck(n2, n1)) continue;
                boolean found = true;
                for (Edge e2 : n2.getOutgoing()) {
                    if (!found || !nodesOriginal2.contains(e2.getTarget())) continue;
                    e1 = n1.getOutgoing(e2.getType());
                    foundEdge = false;
                    for (Edge e : e1) {
                        if (!allActionTypes && e.getAction().getType() != Action.Type.PRESERVE || result.get(e.getTarget()) != null && result.get(e.getTarget()) != e2.getTarget()) continue;
                        foundEdge = true;
                        break;
                    }
                    if (e1.size() == 0) continue;
                    found = foundEdge;
                }
                if (found) {
                    for (Edge e2 : n2.getIncoming()) {
                        if (!found || !nodesOriginal2.contains(e2.getSource())) continue;
                        e1 = n1.getIncoming(e2.getType());
                        foundEdge = false;
                        for (Edge e : e1) {
                            if (!allActionTypes && e.getAction().getType() != Action.Type.PRESERVE || result.get(e.getSource()) != null && result.get(e.getSource()) != e2.getSource()) continue;
                            foundEdge = true;
                            break;
                        }
                        if (e1.size() == 0) continue;
                        found = foundEdge;
                    }
                }
                if (!found) continue;
                result.put(n1, n2);
                HashSet<Node> remained = new HashSet<Node>(nodes2);
                remained.remove(n2);
                if (remained.isEmpty()) {
                    return result;
                }
                Utils.mapNodes(nodesOriginal1, nodesOriginal2, remained, result, allActionTypes);
                if (result.size() == Math.min(nodesOriginal1.size(), nodesOriginal2.size())) {
                    return result;
                }
                result.remove(n1);
            }
        }
        return result;
    }

    public static <T extends Span> Set<T> computeCreateEdgeDeleteNode(Set<T> s2Set) {
        HashSet<Span> result = new HashSet<Span>();
        for (Span s2 : s2Set) {
            for (Edge cEdge : s2.getRule2().getActionEdges(new Action(Action.Type.CREATE))) {
                Node originT;
                Node originS = s2.getRule2().getMappings().getOrigin(cEdge.getSource());
                boolean sourceIsDel = false;
                boolean targetIsDel = false;
                if (originS != null && s2.getMappingFromGraphToRule2(originS) != null && (originS = s2.getMappingFromGraphToRule2(originS).getOrigin()) != null && s2.getMappingIntoRule1(originS) != null) {
                    boolean bl = sourceIsDel = (originS = s2.getMappingIntoRule1(originS).getImage()).getAction().getType() == Action.Type.DELETE;
                }
                if ((originT = s2.getRule2().getMappings().getOrigin(cEdge.getTarget())) != null && s2.getMappingFromGraphToRule2(originT) != null && (originT = s2.getMappingFromGraphToRule2(originT).getOrigin()) != null && s2.getMappingIntoRule1(originT) != null) {
                    boolean bl = targetIsDel = (originT = s2.getMappingIntoRule1(originT).getImage()).getAction().getType() == Action.Type.DELETE;
                }
                if (sourceIsDel && targetIsDel) {
                    Edge e1 = originS.getOutgoing(cEdge.getType(), originT);
                    if (e1 != null) continue;
                    result.add(ReasonFactory.eINSTANCE.createCEDNReason(s2));
                    continue;
                }
                if (!(sourceIsDel ^ targetIsDel)) continue;
                result.add(ReasonFactory.eINSTANCE.createCEDNReason(s2));
            }
        }
        return result;
    }

    public static <T extends Span> Set<T> filterDoubles(Set<T> spans) {
        HashSet<Span> toRemove = new HashSet<Span>();
        block0: for (Span s : spans) {
            if (s.isForbid() || s.isRequire()) continue;
            for (Span s2 : spans) {
                if (s == s2 || !s.equalElements(s2)) continue;
                toRemove.add(s);
                continue block0;
            }
        }
        spans.removeAll(toRemove);
        return spans;
    }

    public static enum DanglingCase {
        sourceDangling,
        targetDangling,
        unspecifiedEdge;

    }

    public static class DanglingEdge {
        public Edge edge;
        public DanglingCase danglingCase;

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.danglingCase == null ? 0 : this.danglingCase.hashCode());
            result = 31 * result + (this.edge == null ? 0 : this.edge.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DanglingEdge other = (DanglingEdge)obj;
            if (this.danglingCase != other.danglingCase) {
                return false;
            }
            return !(this.edge == null ? other.edge != null : !this.edge.equals(other.edge));
        }

        public String toString() {
            return "DanglingEdge [edge=" + this.edge + ", danglingCase=" + (Object)((Object)this.danglingCase) + "]";
        }

        public DanglingEdge(Edge edge, DanglingCase danglingCase) {
            this.edge = edge;
            this.danglingCase = danglingCase;
        }

        public Edge getEdge() {
            return this.edge;
        }

        public void setEdge(Edge edge) {
            this.edge = edge;
        }

        public DanglingCase getDanglingCase() {
            return this.danglingCase;
        }

        public void setDanglingCase(DanglingCase danglingCase) {
            this.danglingCase = danglingCase;
        }
    }
}

