/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions;

import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.MapEditor;

public abstract class AbstractMapEditor<E extends GraphElement>
implements MapEditor<E> {
    private Graph source;
    private Graph target;
    private MappingList mappings;

    public AbstractMapEditor(Graph source, Graph target, MappingList mappings) {
        this.setSourceAndTarget(source, target);
        this.mappings = mappings;
    }

    public AbstractMapEditor(Graph target) {
        Rule rule = target.getRule();
        if (rule == null) {
            throw new IllegalArgumentException("Source graph not contained in a rule");
        }
        this.setSourceAndTarget(rule.getLhs(), target);
        if (target == rule.getRhs()) {
            this.mappings = rule.getMappings();
        } else if (target.eContainer() instanceof NestedCondition) {
            this.mappings = ((NestedCondition)target.eContainer()).getMappings();
        } else {
            throw new IllegalArgumentException("Target graph must be either the RHS or contained in a NestedCondition");
        }
    }

    public AbstractMapEditor(MapEditor<?> mapEditor) {
        this(mapEditor.getSource(), mapEditor.getTarget(), mapEditor.getMappings());
    }

    private void setSourceAndTarget(Graph source, Graph target) {
        if (source == null || target == null || source == target) {
            throw new IllegalArgumentException("Source and target graph cannot be the same or null");
        }
        this.source = source;
        this.target = target;
    }

    @Override
    public final Graph getSource() {
        return this.source;
    }

    @Override
    public final Graph getTarget() {
        return this.target;
    }

    @Override
    public final MappingList getMappings() {
        return this.mappings;
    }

    @Override
    public final E getOpposite(E e) {
        if (this.mappings == null) {
            return null;
        }
        Graph graph = e.getGraph();
        if (graph == null || graph != this.source && graph != this.target) {
            throw new IllegalArgumentException("Illegal element container: " + graph);
        }
        if (graph == this.source) {
            return this.mappings.getImage(e, this.target);
        }
        return this.mappings.getOrigin(e);
    }

    @Override
    protected final Graph getOpposite(Graph graph) {
        if (graph == this.source) {
            return this.target;
        }
        if (graph == this.target) {
            return this.source;
        }
        return null;
    }

    @Override
    public final void move(E e) {
        E opposite = this.getOpposite(e);
        if (opposite != null) {
            this.replace(opposite);
            return;
        }
        this.doMove(e);
        if (this.getTarget().isRhs()) {
            for (Rule multi : this.getTarget().getRule().getMultiRules()) {
                E eImage = multi.getMultiMappings().getImage(e, (Graph)null);
                if (eImage == null) continue;
                this.newInstance(multi.getLhs(), multi.getRhs(), multi.getMappings()).move(eImage);
            }
        }
    }

    protected abstract void doMove(E var1);

    @Override
    public final void remove(E e) {
        Graph container = e.getGraph();
        if (container != this.source && container != this.target) {
            throw new IllegalArgumentException();
        }
        E opposite = this.getOpposite(e);
        if (opposite != null) {
            this.removeMapping(e, opposite);
        }
        this.doRemove(e);
        if (this.getTarget().isRhs()) {
            for (Rule multi : this.getTarget().getRule().getMultiRules()) {
                E eImage = multi.getMultiMappings().getImage(e, (Graph)null);
                if (eImage == null) continue;
                this.newInstance(multi.getLhs(), multi.getRhs(), multi.getMappings()).remove(eImage);
                multi.getMultiMappings().remove(e, eImage);
            }
        }
    }

    protected abstract void doRemove(E var1);

    @Override
    public final E replace(E e) {
        if (this.getOpposite(e) == null) {
            throw new IllegalArgumentException("Cannot replace an element that is not mapped: " + e);
        }
        E r = this.doReplace(e);
        if (this.getTarget().isRhs()) {
            for (Rule multi : this.getTarget().getRule().getMultiRules()) {
                E eImage = multi.getMultiMappings().getImage(e, (Graph)null);
                E rImage = multi.getMultiMappings().getImage(r, (Graph)null);
                if (eImage == null || rImage == null) continue;
                this.newInstance(multi.getLhs(), multi.getRhs(), multi.getMappings()).replace(eImage);
                multi.getMultiMappings().remove(e, eImage);
            }
        }
        return r;
    }

    protected abstract E doReplace(E var1);

    @Override
    public final E copy(E e) {
        E c = this.doCopy(e);
        if (this.getTarget().isRhs()) {
            for (Rule multi : this.getTarget().getRule().getMultiRules()) {
                E eImage = multi.getMultiMappings().getImage(e, (Graph)null);
                if (eImage == null) continue;
                E cImage = this.newInstance(multi.getLhs(), multi.getRhs(), multi.getMappings()).copy(eImage);
                multi.getMultiMappings().add(c, cImage);
            }
        }
        return c;
    }

    protected abstract E doCopy(E var1);

    protected final void removeMapping(E e1, E e2) {
        if (this.mappings == null) {
            return;
        }
        Graph g1 = e1.getGraph();
        Graph g2 = e2.getGraph();
        if (g1 == this.source && g2 == this.target) {
            this.doRemoveMapping(e1, e2);
        } else if (g1 == this.target && g2 == this.source) {
            this.doRemoveMapping(e2, e1);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void doRemoveMapping(E origin, E image) {
    }

    protected final void createMapping(E e1, E e2) {
        if (this.mappings == null) {
            return;
        }
        Graph g1 = e1.getGraph();
        Graph g2 = e2.getGraph();
        if (g1 == this.source && g2 == this.target) {
            this.doCreateMapping(e1, e2);
        } else if (g1 == this.target && g2 == this.source) {
            this.doCreateMapping(e2, e1);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void doCreateMapping(E origin, E image) {
    }

    private MapEditor<E> newInstance(Graph source, Graph target, MappingList mappings) {
        try {
            return (MapEditor)this.getClass().getConstructor(Graph.class, Graph.class, MappingList.class).newInstance(source, target, mappings);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

