/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.units;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.multicda.cda.conflict.EssentialConflictReason;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.Span;

public abstract class Reason
extends Span {
    protected Set<Reason> originMCRs = new HashSet<Reason>();
    protected Set<Atom> containedConflictAtom = new HashSet<Atom>();
    protected boolean isMinimalReason = false;

    public void addContainedConflictAtom(Atom conflictAtom) {
        this.containedConflictAtom.add(conflictAtom);
    }

    public Set<Atom> getContainedConflictAtoms() {
        return this.containedConflictAtom;
    }

    public Set<Reason> getOriginMCRs() {
        return this.originMCRs;
    }

    public final boolean isMinimalReason() {
        return this.isMinimalReason;
    }

    public final Reason setMinimalReason(boolean isMinimalReason) {
        this.isMinimalReason = isMinimalReason;
        return this;
    }

    public Reason(Reason reason) {
        this(reason, reason.ID, reason.NAME);
    }

    protected Reason(Span reason, String tag, String name) {
        super(reason, tag, name);
        this.originMCRs = new HashSet<Reason>();
        if (reason instanceof Reason && ((Reason)reason).isMinimalReason()) {
            this.isMinimalReason = ((Reason)reason).isMinimalReason;
            this.originMCRs.add((Reason)reason);
            this.containedConflictAtom.addAll(((Reason)reason).getContainedConflictAtoms());
        }
    }

    protected Reason(Set<Mapping> mappingsOfNewSpanInRule1, Graph graph1Copy, Set<Mapping> mappingsOfNewSpanInRule2, Set<Reason> originMCRs, String tag, String name) {
        super(mappingsOfNewSpanInRule1, graph1Copy, mappingsOfNewSpanInRule2, tag, name);
        this.originMCRs = originMCRs;
    }

    protected Reason(Set<Mapping> hashSet, Graph graph, Set<Mapping> hashSet2, String tag, String name) {
        super(hashSet, graph, hashSet2, tag, name);
    }

    protected Reason(Reason extSpan, Node origin, Node image, String tag, String name) {
        super(extSpan, origin, image, tag, name);
    }

    public Set<Atom> getCoveredEdgeConflictAtoms() {
        HashSet<Atom> edgeConflictAtoms = new HashSet<Atom>();
        for (Reason mcr : this.originMCRs) {
            Set<Atom> containedConflictAtoms = mcr.getContainedConflictAtoms();
            for (Atom conflictAtom : containedConflictAtoms) {
                if (!conflictAtom.isDeleteEdgeConflictAtom()) continue;
                edgeConflictAtoms.add(conflictAtom);
            }
        }
        return edgeConflictAtoms;
    }

    public Set<EssentialConflictReason> getAllDerivedConflictReasons(Set<Atom.ConflictAtom> uncoveredConflictAtoms) {
        HashSet<EssentialConflictReason> result = new HashSet<EssentialConflictReason>();
        if (!(this instanceof EssentialConflictReason)) {
            EssentialConflictReason conflictReasonWithoutBA = new EssentialConflictReason(this);
            result.add(conflictReasonWithoutBA);
        }
        for (Atom.ConflictAtom uncoveredCA : uncoveredConflictAtoms) {
            Set<Node> usedR1 = this.getUsedNodesOfR1();
            Set<Node> usedR2 = this.getUsedNodesOfR2();
            EList nodesOfUncoveredCA = uncoveredCA.getGraph().getNodes();
            if (nodesOfUncoveredCA.size() <= 1) {
                return result;
            }
            Node node1 = (Node)nodesOfUncoveredCA.get(0);
            Node node2 = (Node)nodesOfUncoveredCA.get(1);
            LinkedList potentialUsesN1R2 = new LinkedList(this.getRule2().getLhs().getNodes(node1.getType()));
            potentialUsesN1R2.removeAll(usedR2);
            boolean node1UsedInR1 = usedR1.contains(uncoveredCA.getMappingIntoRule1(node1).getImage());
            boolean node1UsedInR2 = usedR2.contains(uncoveredCA.getMappingIntoRule2(node1).getImage());
            if (!node1UsedInR1 && !node1UsedInR2) {
                for (Node potentialUseN1R2 : potentialUsesN1R2) {
                    this.processPotentialUsesN1R2(uncoveredConflictAtoms, uncoveredCA, node1, node2, usedR2, potentialUseN1R2, result);
                }
            }
            LinkedList potentialUseNodesN2AloneR2 = new LinkedList(this.getRule2().getLhs().getNodes(node2.getType()));
            potentialUsesN1R2.removeAll(usedR2);
            boolean node2AlreadyUsedInR1 = usedR1.contains(uncoveredCA.getMappingIntoRule1(node2).getImage());
            boolean node2AlreadyUsedInR2 = usedR2.contains(uncoveredCA.getMappingIntoRule2(node2).getImage());
            if (!(!node2AlreadyUsedInR1 & !node2AlreadyUsedInR2)) continue;
            for (Node potentialUseN2R2 : potentialUseNodesN2AloneR2) {
                this.extendCR(this, uncoveredConflictAtoms, uncoveredCA, node2, potentialUseN2R2, result);
            }
        }
        return result;
    }

    private EssentialConflictReason extendCR(Reason original, Set<Atom.ConflictAtom> byInitialReasonUncoveredConflictAtoms, Atom.ConflictAtom uncoveredCA, Node node2, Node potentialUseN2R2, Set<EssentialConflictReason> result) {
        boolean stop = this.checkStoppingCriterion(uncoveredCA, potentialUseN2R2);
        if (!stop) {
            EssentialConflictReason extendedCR = new EssentialConflictReason(original, node2, potentialUseN2R2, uncoveredCA);
            result.add(extendedCR);
            HashSet<Atom.ConflictAtom> remainingUncoveredCAs = new HashSet<Atom.ConflictAtom>(byInitialReasonUncoveredConflictAtoms);
            remainingUncoveredCAs.remove(uncoveredCA);
            Set<EssentialConflictReason> recursivelyDerivedCRs = extendedCR.getAllDerivedConflictReasons(remainingUncoveredCAs);
            result.addAll(recursivelyDerivedCRs);
            return extendedCR;
        }
        return null;
    }

    private void processPotentialUsesN1R2(Set<Atom.ConflictAtom> uncoveredCAs, Atom.ConflictAtom uncoveredCA, Node node1, Node node2, Set<Node> usedR2, Node potentialUseN1R2, Set<EssentialConflictReason> result) {
        EssentialConflictReason extendedCR = this.extendCR(this, uncoveredCAs, uncoveredCA, node1, potentialUseN1R2, result);
        if (extendedCR != null) {
            LinkedList potentialUsesN2R2 = new LinkedList(this.getRule2().getLhs().getNodes(node2.getType()));
            potentialUsesN2R2.removeAll(usedR2);
            potentialUsesN2R2.remove(potentialUseN1R2);
            Set<Node> usedR1ExtendedCR = extendedCR.getUsedNodesOfR1();
            Set<Node> usedR2ExtendedCR = extendedCR.getUsedNodesOfR2();
            for (Node potentialUseN2N2 : potentialUsesN2R2) {
                boolean stop2;
                boolean node2MatchedOnCAOrigin;
                boolean usedInR1 = usedR1ExtendedCR.contains(uncoveredCA.getMappingIntoRule1(node2).getImage());
                boolean usedInR2 = usedR2ExtendedCR.contains(potentialUseN2N2);
                if (usedInR1 || usedInR2) continue;
                boolean node1MatchedOnCAOrigin = uncoveredCA.getMappingIntoRule2(node1).getImage() == potentialUseN1R2;
                boolean bl = node2MatchedOnCAOrigin = uncoveredCA.getMappingIntoRule2(node2).getImage() == potentialUseN2N2;
                if (node1MatchedOnCAOrigin && node2MatchedOnCAOrigin || (stop2 = this.checkStoppingCriterion(uncoveredCA, potentialUseN2N2))) continue;
                this.extendCR(extendedCR, uncoveredCAs, uncoveredCA, node2, potentialUseN2N2, result);
            }
        }
    }

    protected Set<Node> getUsedNodesOfR1() {
        HashSet<Node> usedNodesOfR1 = new HashSet<Node>();
        if (this.graph.getNodes().size() != this.mappingsInRule1.size()) {
            System.err.println("Error!");
        }
        for (Mapping mappingInRule1 : this.mappingsInRule1) {
            usedNodesOfR1.add(mappingInRule1.getImage());
        }
        return usedNodesOfR1;
    }

    protected Set<Node> getUsedNodesOfR2() {
        HashSet<Node> usedNodesOfR2 = new HashSet<Node>();
        if (this.graph.getNodes().size() != this.mappingsInRule2.size()) {
            System.err.println("Error!");
        }
        for (Mapping mappingInRule2 : this.mappingsInRule2) {
            usedNodesOfR2.add(mappingInRule2.getImage());
        }
        return usedNodesOfR2;
    }

    private boolean checkStoppingCriterion(Atom.ConflictAtom uncoveredCA, Node potentialUseInR2) {
        boolean potentialUseNodeCompletesContainedBA = false;
        boolean secondUncoveredCANodeIsAlreadyPresent = false;
        if (this instanceof EssentialConflictReason) {
            Set<Node> useNodesOfR2OfAllInvolvedCAs;
            Set<Node> lhsNodesOfR2UsedByAdditionalCAs = ((EssentialConflictReason)this).getLhsNodesOfR2UsedByAdditionalCAs();
            if (lhsNodesOfR2UsedByAdditionalCAs.contains(potentialUseInR2)) {
                potentialUseNodeCompletesContainedBA = true;
            }
            if ((useNodesOfR2OfAllInvolvedCAs = this.getAllUseNodesOfR2()).contains(potentialUseInR2)) {
                secondUncoveredCANodeIsAlreadyPresent = true;
            }
        }
        return potentialUseNodeCompletesContainedBA || secondUncoveredCANodeIsAlreadyPresent;
    }

    private Set<Node> getAllUseNodesOfR2() {
        HashSet<Node> allUseNodesOfLhsOfR2 = new HashSet<Node>();
        for (Mapping mappingInRule2 : this.mappingsInRule2) {
            allUseNodesOfLhsOfR2.add(mappingInRule2.getImage());
        }
        return allUseNodesOfLhsOfR2;
    }

    @Override
    public String toString() {
        return String.valueOf(this.isMinimalReason ? "M" : "") + super.toString();
    }

    @Override
    protected int sortID() {
        return super.sortID() - (this.isMinimalReason ? 24 : 0);
    }

    @Override
    public boolean equals(Object obj) {
        return this.isMinimalReason() == ((Reason)obj).isMinimalReason() && super.equals(obj);
    }
}

